/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage;

public class ChunkStorageConfig {
    private boolean enabled = true;
    private int cacheCapacity = 1000;
    private String evictionPolicy = "LRU";
    private int asyncThreadPoolSize = 4;
    private boolean enableAsyncOperations = true;
    private long maintenanceIntervalMinutes = 60L;
    private boolean enableBackups = true;
    private String backupPath = "backups/chunkstorage";
    private boolean enableChecksums = true;
    private boolean enableCompression = false;
    private int maxBackupFiles = 10;
    private long backupRetentionDays = 7L;
    private String databaseType = "rust";
    private boolean useRustDatabase = true;
    private boolean enableSwapManager = true;
    private long swapMemoryCheckIntervalMs = 5000L;
    private int maxConcurrentSwaps = 10;
    private int swapBatchSize = 50;
    private long swapTimeoutMs = 30000L;
    private boolean enableAutomaticSwapping = true;
    private double criticalMemoryThreshold = 0.95;
    private double highMemoryThreshold = 0.85;
    private double elevatedMemoryThreshold = 0.75;
    private int minSwapChunkAgeMs = 60000;
    private boolean enableSwapStatistics = true;

    public ChunkStorageConfig() {
    }

    public ChunkStorageConfig(boolean enabled, int cacheCapacity, String evictionPolicy) {
        this.enabled = enabled;
        this.cacheCapacity = cacheCapacity;
        this.evictionPolicy = evictionPolicy;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getCacheCapacity() {
        return this.cacheCapacity;
    }

    public void setCacheCapacity(int cacheCapacity) {
        if (cacheCapacity <= 0) {
            throw new IllegalArgumentException("Cache capacity must be positive");
        }
        this.cacheCapacity = cacheCapacity;
    }

    public String getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public void setEvictionPolicy(String evictionPolicy) {
        if (evictionPolicy == null || evictionPolicy.isEmpty()) {
            throw new IllegalArgumentException("Eviction policy cannot be null or empty");
        }
        this.evictionPolicy = evictionPolicy;
    }

    public int getAsyncThreadPoolSize() {
        return this.asyncThreadPoolSize;
    }

    public void setAsyncThreadPoolSize(int asyncThreadPoolSize) {
        if (asyncThreadPoolSize <= 0) {
            throw new IllegalArgumentException("Async thread pool size must be positive");
        }
        this.asyncThreadPoolSize = asyncThreadPoolSize;
    }

    public boolean isEnableAsyncOperations() {
        return this.enableAsyncOperations;
    }

    public void setEnableAsyncOperations(boolean enableAsyncOperations) {
        this.enableAsyncOperations = enableAsyncOperations;
    }

    public long getMaintenanceIntervalMinutes() {
        return this.maintenanceIntervalMinutes;
    }

    public void setMaintenanceIntervalMinutes(long maintenanceIntervalMinutes) {
        if (maintenanceIntervalMinutes <= 0L) {
            throw new IllegalArgumentException("Maintenance interval must be positive");
        }
        this.maintenanceIntervalMinutes = maintenanceIntervalMinutes;
    }

    public boolean isEnableBackups() {
        return this.enableBackups;
    }

    public void setEnableBackups(boolean enableBackups) {
        this.enableBackups = enableBackups;
    }

    public String getBackupPath() {
        return this.backupPath;
    }

    public void setBackupPath(String backupPath) {
        if (backupPath == null || backupPath.isEmpty()) {
            throw new IllegalArgumentException("Backup path cannot be null or empty");
        }
        this.backupPath = backupPath;
    }

    public boolean isEnableChecksums() {
        return this.enableChecksums;
    }

    public void setEnableChecksums(boolean enableChecksums) {
        this.enableChecksums = enableChecksums;
    }

    public boolean isEnableCompression() {
        return this.enableCompression;
    }

    public void setEnableCompression(boolean enableCompression) {
        this.enableCompression = enableCompression;
    }

    public int getMaxBackupFiles() {
        return this.maxBackupFiles;
    }

    public void setMaxBackupFiles(int maxBackupFiles) {
        if (maxBackupFiles <= 0) {
            throw new IllegalArgumentException("Max backup files must be positive");
        }
        this.maxBackupFiles = maxBackupFiles;
    }

    public long getBackupRetentionDays() {
        return this.backupRetentionDays;
    }

    public void setBackupRetentionDays(long backupRetentionDays) {
        if (backupRetentionDays <= 0L) {
            throw new IllegalArgumentException("Backup retention days must be positive");
        }
        this.backupRetentionDays = backupRetentionDays;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        if (databaseType == null || databaseType.isEmpty()) {
            throw new IllegalArgumentException("Database type cannot be null or empty");
        }
        this.databaseType = databaseType;
    }

    public boolean isUseRustDatabase() {
        return this.useRustDatabase;
    }

    public void setUseRustDatabase(boolean useRustDatabase) {
        this.useRustDatabase = useRustDatabase;
    }

    public boolean isEnableSwapManager() {
        return this.enableSwapManager;
    }

    public void setEnableSwapManager(boolean enableSwapManager) {
        this.enableSwapManager = enableSwapManager;
    }

    public long getSwapMemoryCheckIntervalMs() {
        return this.swapMemoryCheckIntervalMs;
    }

    public void setSwapMemoryCheckIntervalMs(long swapMemoryCheckIntervalMs) {
        this.swapMemoryCheckIntervalMs = swapMemoryCheckIntervalMs;
    }

    public int getMaxConcurrentSwaps() {
        return this.maxConcurrentSwaps;
    }

    public void setMaxConcurrentSwaps(int maxConcurrentSwaps) {
        this.maxConcurrentSwaps = maxConcurrentSwaps;
    }

    public int getSwapBatchSize() {
        return this.swapBatchSize;
    }

    public void setSwapBatchSize(int swapBatchSize) {
        this.swapBatchSize = swapBatchSize;
    }

    public long getSwapTimeoutMs() {
        return this.swapTimeoutMs;
    }

    public void setSwapTimeoutMs(long swapTimeoutMs) {
        this.swapTimeoutMs = swapTimeoutMs;
    }

    public boolean isEnableAutomaticSwapping() {
        return this.enableAutomaticSwapping;
    }

    public void setEnableAutomaticSwapping(boolean enableAutomaticSwapping) {
        this.enableAutomaticSwapping = enableAutomaticSwapping;
    }

    public double getCriticalMemoryThreshold() {
        return this.criticalMemoryThreshold;
    }

    public void setCriticalMemoryThreshold(double criticalMemoryThreshold) {
        this.criticalMemoryThreshold = criticalMemoryThreshold;
    }

    public double getHighMemoryThreshold() {
        return this.highMemoryThreshold;
    }

    public void setHighMemoryThreshold(double highMemoryThreshold) {
        this.highMemoryThreshold = highMemoryThreshold;
    }

    public double getElevatedMemoryThreshold() {
        return this.elevatedMemoryThreshold;
    }

    public void setElevatedMemoryThreshold(double elevatedMemoryThreshold) {
        this.elevatedMemoryThreshold = elevatedMemoryThreshold;
    }

    public int getMinSwapChunkAgeMs() {
        return this.minSwapChunkAgeMs;
    }

    public void setMinSwapChunkAgeMs(int minSwapChunkAgeMs) {
        this.minSwapChunkAgeMs = minSwapChunkAgeMs;
    }

    public boolean isEnableSwapStatistics() {
        return this.enableSwapStatistics;
    }

    public void setEnableSwapStatistics(boolean enableSwapStatistics) {
        this.enableSwapStatistics = enableSwapStatistics;
    }

    public String toString() {
        return String.format("ChunkStorageConfig{enabled=%s, cacheCapacity=%d, evictionPolicy='%s', asyncThreadPoolSize=%d, enableAsyncOperations=%s, maintenanceIntervalMinutes=%d, enableBackups=%s, backupPath='%s', enableChecksums=%s, enableCompression=%s, maxBackupFiles=%d, backupRetentionDays=%d, databaseType='%s', useRustDatabase=%s, enableSwapManager=%s, swapMemoryCheckIntervalMs=%d, maxConcurrentSwaps=%d, swapBatchSize=%d, swapTimeoutMs=%d, enableAutomaticSwapping=%s, criticalMemoryThreshold=%.2f, highMemoryThreshold=%.2f, elevatedMemoryThreshold=%.2f, minSwapChunkAgeMs=%d, enableSwapStatistics=%s}", this.enabled, this.cacheCapacity, this.evictionPolicy, this.asyncThreadPoolSize, this.enableAsyncOperations, this.maintenanceIntervalMinutes, this.enableBackups, this.backupPath, this.enableChecksums, this.enableCompression, this.maxBackupFiles, this.backupRetentionDays, this.databaseType, this.useRustDatabase, this.enableSwapManager, this.swapMemoryCheckIntervalMs, this.maxConcurrentSwaps, this.swapBatchSize, this.swapTimeoutMs, this.enableAutomaticSwapping, this.criticalMemoryThreshold, this.highMemoryThreshold, this.elevatedMemoryThreshold, this.minSwapChunkAgeMs, this.enableSwapStatistics);
    }

    public static ChunkStorageConfig createDefault() {
        return new ChunkStorageConfig(true, 1000, "LRU");
    }

    public static ChunkStorageConfig createDevelopment() {
        ChunkStorageConfig config = new ChunkStorageConfig(true, 100, "LRU");
        config.setAsyncThreadPoolSize(2);
        config.setMaintenanceIntervalMinutes(30L);
        return config;
    }

    public static ChunkStorageConfig createProduction() {
        ChunkStorageConfig config = new ChunkStorageConfig(true, 5000, "Hybrid");
        config.setAsyncThreadPoolSize(8);
        config.setMaintenanceIntervalMinutes(60L);
        config.setEnableCompression(true);
        config.setEnableSwapManager(true);
        config.setMaxConcurrentSwaps(20);
        config.setSwapBatchSize(100);
        return config;
    }
}

