/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage;

import com.kneaf.core.chunkstorage.ChunkSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NbtChunkSerializer
implements ChunkSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NbtChunkSerializer.class);
    private static final String FORMAT_NAME = "NBT";
    private static final int FORMAT_VERSION = 1;
    private static final String TAG_VERSION = "DataVersion";
    private static final String TAG_CHUNK_DATA = "ChunkData";
    private static final String TAG_CHECKSUM = "Checksum";
    private static final String TAG_TIMESTAMP = "Timestamp";
    private static final boolean MINECRAFT_CLASSES_AVAILABLE;

    public static boolean isMinecraftAvailable() {
        return MINECRAFT_CLASSES_AVAILABLE;
    }

    @Override
    public byte[] serialize(Object chunk) throws IOException {
        if (!MINECRAFT_CLASSES_AVAILABLE) {
            throw new IOException("Minecraft classes not available - cannot serialize chunks");
        }
        if (chunk == null) {
            throw new IllegalArgumentException("Chunk cannot be null");
        }
        return this.serializeChunk(chunk);
    }

    @Override
    public Object deserialize(byte[] data) throws IOException {
        if (!MINECRAFT_CLASSES_AVAILABLE) {
            throw new IOException("Minecraft classes not available - cannot deserialize chunks");
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Data cannot be null or empty");
        }
        return this.deserializeChunk(data);
    }

    @Override
    public String getFormat() {
        return FORMAT_NAME;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean supports(String format, int version) {
        return FORMAT_NAME.equals(format) && version == 1;
    }

    private byte[] serializeChunk(Object chunk) throws IOException {
        try {
            Class<?> levelChunkClass = Class.forName("net.minecraft.world.level.chunk.LevelChunk");
            Class<?> compoundTagClass = Class.forName("net.minecraft.nbt.CompoundTag");
            Class<?> listTagClass = Class.forName("net.minecraft.nbt.ListTag");
            Class<?> nbtIoClass = Class.forName("net.minecraft.nbt.NbtIo");
            Class<?> blockPosClass = Class.forName("net.minecraft.core.BlockPos");
            Class<?> blockStateClass = Class.forName("net.minecraft.world.level.block.state.BlockState");
            Class<?> blockEntityClass = Class.forName("net.minecraft.world.level.block.entity.BlockEntity");
            long startTime = System.nanoTime();
            Object rootTag = compoundTagClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            compoundTagClass.getMethod("putInt", String.class, Integer.TYPE).invoke(rootTag, TAG_VERSION, 1);
            compoundTagClass.getMethod("putLong", String.class, Long.TYPE).invoke(rootTag, TAG_TIMESTAMP, System.currentTimeMillis());
            Object chunkData = compoundTagClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Object chunkPos = levelChunkClass.getMethod("getPos", new Class[0]).invoke(chunk, new Object[0]);
            int chunkX = (Integer)chunkPos.getClass().getMethod("x", new Class[0]).invoke(chunkPos, new Object[0]);
            int chunkZ = (Integer)chunkPos.getClass().getMethod("z", new Class[0]).invoke(chunkPos, new Object[0]);
            compoundTagClass.getMethod("putInt", String.class, Integer.TYPE).invoke(chunkData, "xPos", chunkX);
            compoundTagClass.getMethod("putInt", String.class, Integer.TYPE).invoke(chunkData, "zPos", chunkZ);
            try {
                Object fullStatus = levelChunkClass.getMethod("getFullStatus", new Class[0]).invoke(chunk, new Object[0]);
                String statusName = fullStatus.toString();
                compoundTagClass.getMethod("putString", String.class, String.class).invoke(chunkData, "status", statusName);
            }
            catch (Exception e) {
                LOGGER.debug("Could not get chunk status, using default");
                compoundTagClass.getMethod("putString", String.class, String.class).invoke(chunkData, "status", "FULL");
            }
            this.serializeChunkSections(chunk, chunkData, levelChunkClass, compoundTagClass, listTagClass, blockStateClass);
            this.serializeHeightmaps(chunk, chunkData, levelChunkClass, compoundTagClass, blockPosClass, blockStateClass);
            this.serializeBlockEntities(chunk, chunkData, levelChunkClass, compoundTagClass, blockPosClass, blockEntityClass);
            compoundTagClass.getMethod("put", String.class, compoundTagClass).invoke(rootTag, TAG_CHUNK_DATA, chunkData);
            byte[] chunkBytes = this.writeCompoundTagToBytes(chunkData, nbtIoClass);
            long checksum = this.calculateChecksum(chunkBytes);
            compoundTagClass.getMethod("putLong", String.class, Long.TYPE).invoke(rootTag, TAG_CHECKSUM, checksum);
            byte[] serializedData = this.writeCompoundTagToBytes(rootTag, nbtIoClass);
            if (LOGGER.isDebugEnabled()) {
                long duration = System.nanoTime() - startTime;
                LOGGER.debug("Serialized chunk at ({}, {}) to {} bytes in {} ms", new Object[]{chunkX, chunkZ, serializedData.length, duration / 1000000L});
            }
            return serializedData;
        }
        catch (Exception e) {
            LOGGER.error("Failed to serialize chunk due to error: {}", (Object)e.getMessage(), (Object)e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Failed to serialize chunk: " + e.getMessage(), e);
        }
    }

    private Object deserializeChunk(byte[] data) throws IOException {
        try {
            Class<?> compoundTagClass = Class.forName("net.minecraft.nbt.CompoundTag");
            Class<?> nbtIoClass = Class.forName("net.minecraft.nbt.NbtIo");
            long startTime = System.nanoTime();
            Object rootTag = this.readCompoundTagFromBytes(data, nbtIoClass);
            int version = (Integer)compoundTagClass.getMethod("getInt", String.class).invoke(rootTag, TAG_VERSION);
            if (version != 1) {
                throw new IOException("Unsupported format version: " + version);
            }
            if (((Boolean)compoundTagClass.getMethod("contains", String.class, Integer.TYPE).invoke(rootTag, TAG_CHECKSUM, 4)).booleanValue()) {
                long actualChecksum;
                Object chunkData = compoundTagClass.getMethod("getCompound", String.class).invoke(rootTag, TAG_CHUNK_DATA);
                byte[] chunkBytes = this.writeCompoundTagToBytes(chunkData, nbtIoClass);
                long expectedChecksum = (Long)compoundTagClass.getMethod("getLong", String.class).invoke(rootTag, TAG_CHECKSUM);
                if (expectedChecksum != (actualChecksum = this.calculateChecksum(chunkBytes))) {
                    throw new IOException("Checksum mismatch: expected " + expectedChecksum + ", got " + actualChecksum);
                }
            }
            Object result = compoundTagClass.getMethod("getCompound", String.class).invoke(rootTag, TAG_CHUNK_DATA);
            if (LOGGER.isDebugEnabled()) {
                long duration = System.nanoTime() - startTime;
                LOGGER.debug("Deserialized chunk data from {} bytes in {} ms", (Object)data.length, (Object)(duration / 1000000L));
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Failed to deserialize chunk data due to error: {}", (Object)e.getMessage(), (Object)e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Failed to deserialize chunk data: " + e.getMessage(), e);
        }
    }

    private void serializeChunkSections(Object chunk, Object chunkData, Class<?> levelChunkClass, Class<?> compoundTagClass, Class<?> listTagClass, Class<?> blockStateClass) throws Exception {
        Object sectionsList = listTagClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        int minSection = (Integer)levelChunkClass.getMethod("getMinSection", new Class[0]).invoke(chunk, new Object[0]);
        int maxSection = (Integer)levelChunkClass.getMethod("getMaxSection", new Class[0]).invoke(chunk, new Object[0]);
        for (int y = minSection; y < maxSection; ++y) {
            Object section = levelChunkClass.getMethod("getSection", Integer.TYPE).invoke(chunk, levelChunkClass.getMethod("getSectionIndexFromSectionY", Integer.TYPE).invoke(chunk, y));
            if (section == null || ((Boolean)section.getClass().getMethod("hasOnlyAir", new Class[0]).invoke(section, new Object[0])).booleanValue()) continue;
            Object sectionTag = compoundTagClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            compoundTagClass.getMethod("putInt", String.class, Integer.TYPE).invoke(sectionTag, "y", y);
            this.serializeBlockStates(section, sectionTag, compoundTagClass, listTagClass, blockStateClass);
            listTagClass.getMethod("add", compoundTagClass).invoke(sectionsList, sectionTag);
        }
        compoundTagClass.getMethod("put", String.class, listTagClass).invoke(chunkData, "sections", sectionsList);
    }

    private void serializeBlockStates(Object section, Object sectionTag, Class<?> compoundTagClass, Class<?> listTagClass, Class<?> blockStateClass) throws Exception {
        Object blockStatesList = listTagClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    Object blockState = section.getClass().getMethod("getBlockState", Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(section, x, y, z);
                    if (((Boolean)blockStateClass.getMethod("isAir", new Class[0]).invoke(blockState, new Object[0])).booleanValue()) continue;
                    Object blockTag = compoundTagClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    compoundTagClass.getMethod("putInt", String.class, Integer.TYPE).invoke(blockTag, "x", x);
                    compoundTagClass.getMethod("putInt", String.class, Integer.TYPE).invoke(blockTag, "y", y);
                    compoundTagClass.getMethod("putInt", String.class, Integer.TYPE).invoke(blockTag, "z", z);
                    compoundTagClass.getMethod("putString", String.class, String.class).invoke(blockTag, "block", blockState.toString());
                    listTagClass.getMethod("add", compoundTagClass).invoke(blockStatesList, blockTag);
                }
            }
        }
        compoundTagClass.getMethod("put", String.class, listTagClass).invoke(sectionTag, "block_states", blockStatesList);
    }

    private void serializeHeightmaps(Object chunk, Object chunkData, Class<?> levelChunkClass, Class<?> compoundTagClass, Class<?> blockPosClass, Class<?> blockStateClass) throws Exception {
        Object heightmapsTag = compoundTagClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        try {
            int minHeight = (Integer)levelChunkClass.getMethod("getMinBuildHeight", new Class[0]).invoke(chunk, new Object[0]);
            int maxHeight = (Integer)levelChunkClass.getMethod("getMaxBuildHeight", new Class[0]).invoke(chunk, new Object[0]);
            compoundTagClass.getMethod("putInt", String.class, Integer.TYPE).invoke(heightmapsTag, "minHeight", minHeight);
            compoundTagClass.getMethod("putInt", String.class, Integer.TYPE).invoke(heightmapsTag, "maxHeight", maxHeight);
            Object chunkPos = levelChunkClass.getMethod("getPos", new Class[0]).invoke(chunk, new Object[0]);
            int minBlockX = (Integer)chunkPos.getClass().getMethod("getMinBlockX", new Class[0]).invoke(chunkPos, new Object[0]);
            int minBlockZ = (Integer)chunkPos.getClass().getMethod("getMinBlockZ", new Class[0]).invoke(chunkPos, new Object[0]);
            for (int x = 0; x < 16; x += 4) {
                for (int z = 0; z < 16; z += 4) {
                    int surfaceY = this.findSurfaceHeight(chunk, x, z, minHeight, maxHeight, levelChunkClass, blockPosClass, blockStateClass, minBlockX, minBlockZ);
                    String key = "height_" + x + "_" + z;
                    compoundTagClass.getMethod("putInt", String.class, Integer.TYPE).invoke(heightmapsTag, key, surfaceY);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while serializing heightmaps: {}", (Object)e.getMessage(), (Object)e);
        }
        compoundTagClass.getMethod("put", String.class, compoundTagClass).invoke(chunkData, "heightmaps", heightmapsTag);
    }

    private void serializeBlockEntities(Object chunk, Object chunkData, Class<?> levelChunkClass, Class<?> compoundTagClass, Class<?> blockPosClass, Class<?> blockEntityClass) throws Exception {
        Object blockEntitiesPos = levelChunkClass.getMethod("getBlockEntitiesPos", new Class[0]).invoke(chunk, new Object[0]);
        if (blockEntitiesPos instanceof Iterable) {
            for (Object pos : (Iterable)blockEntitiesPos) {
                Object blockEntity = levelChunkClass.getMethod("getBlockEntity", blockPosClass).invoke(chunk, pos);
                if (blockEntity == null) continue;
                try {
                    Object beTag = compoundTagClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    int x = (Integer)blockPosClass.getMethod("getX", new Class[0]).invoke(pos, new Object[0]);
                    int y = (Integer)blockPosClass.getMethod("getY", new Class[0]).invoke(pos, new Object[0]);
                    int z = (Integer)blockPosClass.getMethod("getZ", new Class[0]).invoke(pos, new Object[0]);
                    compoundTagClass.getMethod("putInt", String.class, Integer.TYPE).invoke(beTag, "x", x);
                    compoundTagClass.getMethod("putInt", String.class, Integer.TYPE).invoke(beTag, "y", y);
                    compoundTagClass.getMethod("putInt", String.class, Integer.TYPE).invoke(beTag, "z", z);
                    try {
                        Object blockEntityType = blockEntityClass.getMethod("getType", new Class[0]).invoke(blockEntity, new Object[0]);
                        String typeString = blockEntityType.toString();
                        compoundTagClass.getMethod("putString", String.class, String.class).invoke(beTag, "id", typeString);
                    }
                    catch (Exception e) {
                        compoundTagClass.getMethod("putString", String.class, String.class).invoke(beTag, "id", "unknown");
                    }
                    String key = "block_entity_" + x + "_" + y + "_" + z;
                    compoundTagClass.getMethod("put", String.class, compoundTagClass).invoke(chunkData, key, beTag);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not serialize block entity at {}: {}", new Object[]{pos, e.getMessage(), e});
                }
            }
        }
    }

    private int findSurfaceHeight(Object chunk, int x, int z, int minHeight, int maxHeight, Class<?> levelChunkClass, Class<?> blockPosClass, Class<?> blockStateClass, int minBlockX, int minBlockZ) throws Exception {
        for (int y = maxHeight - 1; y >= minHeight; --y) {
            Object pos = blockPosClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(minBlockX + x, y, minBlockZ + z);
            Object blockState = levelChunkClass.getMethod("getBlockState", blockPosClass).invoke(chunk, pos);
            if (((Boolean)blockStateClass.getMethod("isAir", new Class[0]).invoke(blockState, new Object[0])).booleanValue()) continue;
            return y;
        }
        return minHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeCompoundTagToBytes(Object tag, Class<?> nbtIoClass) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(baos);){
            nbtIoClass.getMethod("write", Class.forName("net.minecraft.nbt.CompoundTag"), DataOutput.class).invoke(null, tag, dos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readCompoundTagFromBytes(byte[] data, Class<?> nbtIoClass) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try (DataInputStream dis = new DataInputStream(bais);){
            Object object = nbtIoClass.getMethod("read", DataInput.class).invoke(null, dis);
            return object;
        }
    }

    private long calculateChecksum(byte[] data) {
        if (data == null || data.length == 0) {
            return 0L;
        }
        long checksum = 0L;
        for (int i = 0; i < data.length; ++i) {
            checksum = checksum << 1 ^ (long)(data[i] & 0xFF);
            checksum = checksum << 7 | checksum >>> 57;
        }
        return checksum;
    }

    static {
        boolean minecraftAvailable = false;
        try {
            Class.forName("net.minecraft.nbt.CompoundTag");
            minecraftAvailable = true;
            LOGGER.info("Minecraft classes available - NbtChunkSerializer fully functional");
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Minecraft classes not available - NbtChunkSerializer will be non-functional");
        }
        MINECRAFT_CLASSES_AVAILABLE = minecraftAvailable;
    }
}

