/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.config;

import java.util.Arrays;

public class PerformanceConfiguration {
    private final boolean enabled;
    private final int threadPoolSize;
    private final int logIntervalTicks;
    private final int scanIntervalTicks;
    private final double tpsThresholdForAsync;
    private final int maxEntitiesToCollect;
    private final double entityDistanceCutoff;
    private final long maxLogBytes;
    private final boolean adaptiveThreadPool;
    private final int maxThreadPoolSize;
    private final String[] excludedEntityTypes;
    private final int networkExecutorPoolSize;
    private final boolean profilingEnabled;
    private final long slowTickThresholdMs;
    private final int profilingSampleRate;
    private final int minThreadPoolSize;
    private final boolean dynamicThreadScaling;
    private final double threadScaleUpThreshold;
    private final double threadScaleDownThreshold;
    private final int threadScaleUpDelayTicks;
    private final int threadScaleDownDelayTicks;
    private final boolean workStealingEnabled;
    private final int workStealingQueueSize;
    private final boolean cpuAwareThreadSizing;
    private final double cpuLoadThreshold;
    private final int threadPoolKeepAliveSeconds;
    private final int distanceCalculationInterval;
    private final boolean distanceApproximationEnabled;
    private final int distanceCacheSize;
    private final int itemProcessingIntervalMultiplier;
    private final int spatialGridUpdateInterval;
    private final boolean incrementalSpatialUpdates;

    private PerformanceConfiguration(Builder builder) {
        this.enabled = builder.enabled;
        this.threadPoolSize = builder.threadPoolSize;
        this.logIntervalTicks = builder.logIntervalTicks;
        this.scanIntervalTicks = builder.scanIntervalTicks;
        this.tpsThresholdForAsync = builder.tpsThresholdForAsync;
        this.maxEntitiesToCollect = builder.maxEntitiesToCollect;
        this.entityDistanceCutoff = builder.entityDistanceCutoff;
        this.maxLogBytes = builder.maxLogBytes;
        this.adaptiveThreadPool = builder.adaptiveThreadPool;
        this.maxThreadPoolSize = builder.maxThreadPoolSize;
        this.excludedEntityTypes = builder.excludedEntityTypes == null ? new String[]{} : (String[])builder.excludedEntityTypes.clone();
        this.networkExecutorPoolSize = builder.networkExecutorPoolSize;
        this.profilingEnabled = builder.profilingEnabled;
        this.slowTickThresholdMs = builder.slowTickThresholdMs;
        this.profilingSampleRate = builder.profilingSampleRate;
        this.minThreadPoolSize = builder.minThreadPoolSize;
        this.dynamicThreadScaling = builder.dynamicThreadScaling;
        this.threadScaleUpThreshold = builder.threadScaleUpThreshold;
        this.threadScaleDownThreshold = builder.threadScaleDownThreshold;
        this.threadScaleUpDelayTicks = builder.threadScaleUpDelayTicks;
        this.threadScaleDownDelayTicks = builder.threadScaleDownDelayTicks;
        this.workStealingEnabled = builder.workStealingEnabled;
        this.workStealingQueueSize = builder.workStealingQueueSize;
        this.cpuAwareThreadSizing = builder.cpuAwareThreadSizing;
        this.cpuLoadThreshold = builder.cpuLoadThreshold;
        this.threadPoolKeepAliveSeconds = builder.threadPoolKeepAliveSeconds;
        this.distanceCalculationInterval = builder.distanceCalculationInterval;
        this.distanceApproximationEnabled = builder.distanceApproximationEnabled;
        this.distanceCacheSize = builder.distanceCacheSize;
        this.itemProcessingIntervalMultiplier = builder.itemProcessingIntervalMultiplier;
        this.spatialGridUpdateInterval = builder.spatialGridUpdateInterval;
        this.incrementalSpatialUpdates = builder.incrementalSpatialUpdates;
        this.validate();
    }

    private void validate() {
        if (this.minThreadPoolSize > this.maxThreadPoolSize) {
            throw new IllegalArgumentException("minThreadPoolSize (" + this.minThreadPoolSize + ") cannot be greater than maxThreadPoolSize (" + this.maxThreadPoolSize + ")");
        }
        if (this.threadScaleUpThreshold <= this.threadScaleDownThreshold) {
            throw new IllegalArgumentException("threadScaleUpThreshold (" + this.threadScaleUpThreshold + ") must be greater than threadScaleDownThreshold (" + this.threadScaleDownThreshold + ")");
        }
        if (this.scanIntervalTicks < 1 || this.scanIntervalTicks > 100) {
            throw new IllegalArgumentException("scanIntervalTicks must be between 1 and 100, got: " + this.scanIntervalTicks);
        }
        if (this.tpsThresholdForAsync < 10.0 || this.tpsThresholdForAsync > 20.0) {
            throw new IllegalArgumentException("tpsThresholdForAsync must be between 10.0 and 20.0, got: " + this.tpsThresholdForAsync);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getLogIntervalTicks() {
        return this.logIntervalTicks;
    }

    public int getScanIntervalTicks() {
        return this.scanIntervalTicks;
    }

    public double getTpsThresholdForAsync() {
        return this.tpsThresholdForAsync;
    }

    public int getMaxEntitiesToCollect() {
        return this.maxEntitiesToCollect;
    }

    public double getEntityDistanceCutoff() {
        return this.entityDistanceCutoff;
    }

    public long getMaxLogBytes() {
        return this.maxLogBytes;
    }

    public boolean isAdaptiveThreadPool() {
        return this.adaptiveThreadPool;
    }

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public String[] getExcludedEntityTypes() {
        return (String[])this.excludedEntityTypes.clone();
    }

    public int getNetworkExecutorPoolSize() {
        return this.networkExecutorPoolSize;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public long getSlowTickThresholdMs() {
        return this.slowTickThresholdMs;
    }

    public int getProfilingSampleRate() {
        return this.profilingSampleRate;
    }

    public int getMinThreadPoolSize() {
        return this.minThreadPoolSize;
    }

    public boolean isDynamicThreadScaling() {
        return this.dynamicThreadScaling;
    }

    public double getThreadScaleUpThreshold() {
        return this.threadScaleUpThreshold;
    }

    public double getThreadScaleDownThreshold() {
        return this.threadScaleDownThreshold;
    }

    public int getThreadScaleUpDelayTicks() {
        return this.threadScaleUpDelayTicks;
    }

    public int getThreadScaleDownDelayTicks() {
        return this.threadScaleDownDelayTicks;
    }

    public boolean isWorkStealingEnabled() {
        return this.workStealingEnabled;
    }

    public int getWorkStealingQueueSize() {
        return this.workStealingQueueSize;
    }

    public boolean isCpuAwareThreadSizing() {
        return this.cpuAwareThreadSizing;
    }

    public double getCpuLoadThreshold() {
        return this.cpuLoadThreshold;
    }

    public int getThreadPoolKeepAliveSeconds() {
        return this.threadPoolKeepAliveSeconds;
    }

    public int getDistanceCalculationInterval() {
        return this.distanceCalculationInterval;
    }

    public boolean isDistanceApproximationEnabled() {
        return this.distanceApproximationEnabled;
    }

    public int getDistanceCacheSize() {
        return this.distanceCacheSize;
    }

    public int getItemProcessingIntervalMultiplier() {
        return this.itemProcessingIntervalMultiplier;
    }

    public int getSpatialGridUpdateInterval() {
        return this.spatialGridUpdateInterval;
    }

    public boolean isIncrementalSpatialUpdates() {
        return this.incrementalSpatialUpdates;
    }

    public String toString() {
        return "PerformanceConfiguration{enabled=" + this.enabled + ", threadPoolSize=" + this.threadPoolSize + ", logIntervalTicks=" + this.logIntervalTicks + ", scanIntervalTicks=" + this.scanIntervalTicks + ", tpsThresholdForAsync=" + this.tpsThresholdForAsync + ", maxEntitiesToCollect=" + this.maxEntitiesToCollect + ", entityDistanceCutoff=" + this.entityDistanceCutoff + ", maxLogBytes=" + this.maxLogBytes + ", adaptiveThreadPool=" + this.adaptiveThreadPool + ", maxThreadPoolSize=" + this.maxThreadPoolSize + ", excludedEntityTypes=" + Arrays.toString(this.excludedEntityTypes) + ", profilingEnabled=" + this.profilingEnabled + ", slowTickThresholdMs=" + this.slowTickThresholdMs + ", profilingSampleRate=" + this.profilingSampleRate + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean enabled = true;
        private int threadPoolSize = 4;
        private int logIntervalTicks = 100;
        private int scanIntervalTicks = 1;
        private double tpsThresholdForAsync = 19.0;
        private int maxEntitiesToCollect = 20000;
        private double entityDistanceCutoff = 256.0;
        private long maxLogBytes = 0xA00000L;
        private boolean adaptiveThreadPool = false;
        private int maxThreadPoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        private String[] excludedEntityTypes = new String[0];
        private int networkExecutorPoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        private boolean profilingEnabled = true;
        private long slowTickThresholdMs = 50L;
        private int profilingSampleRate = 100;
        private int minThreadPoolSize = 2;
        private boolean dynamicThreadScaling = true;
        private double threadScaleUpThreshold = 0.8;
        private double threadScaleDownThreshold = 0.3;
        private int threadScaleUpDelayTicks = 100;
        private int threadScaleDownDelayTicks = 200;
        private boolean workStealingEnabled = true;
        private int workStealingQueueSize = 100;
        private boolean cpuAwareThreadSizing = false;
        private double cpuLoadThreshold = 0.7;
        private int threadPoolKeepAliveSeconds = 60;
        private int distanceCalculationInterval = 1;
        private boolean distanceApproximationEnabled = true;
        private int distanceCacheSize = 100;
        private int itemProcessingIntervalMultiplier = 1;
        private int spatialGridUpdateInterval = 1;
        private boolean incrementalSpatialUpdates = true;

        public Builder enabled(boolean v) {
            this.enabled = v;
            return this;
        }

        public Builder threadPoolSize(int v) {
            this.threadPoolSize = v;
            return this;
        }

        public Builder logIntervalTicks(int v) {
            this.logIntervalTicks = v;
            return this;
        }

        public Builder scanIntervalTicks(int v) {
            this.scanIntervalTicks = v;
            return this;
        }

        public Builder tpsThresholdForAsync(double v) {
            this.tpsThresholdForAsync = v;
            return this;
        }

        public Builder maxEntitiesToCollect(int v) {
            this.maxEntitiesToCollect = v;
            return this;
        }

        public Builder entityDistanceCutoff(double v) {
            this.entityDistanceCutoff = v;
            return this;
        }

        public Builder maxLogBytes(long v) {
            this.maxLogBytes = v;
            return this;
        }

        public Builder adaptiveThreadPool(boolean v) {
            this.adaptiveThreadPool = v;
            return this;
        }

        public Builder maxThreadPoolSize(int v) {
            this.maxThreadPoolSize = v;
            return this;
        }

        public Builder excludedEntityTypes(String[] v) {
            this.excludedEntityTypes = v == null ? new String[]{} : (String[])v.clone();
            return this;
        }

        public Builder networkExecutorPoolSize(int v) {
            this.networkExecutorPoolSize = v;
            return this;
        }

        public Builder profilingEnabled(boolean v) {
            this.profilingEnabled = v;
            return this;
        }

        public Builder slowTickThresholdMs(long v) {
            this.slowTickThresholdMs = v;
            return this;
        }

        public Builder profilingSampleRate(int v) {
            this.profilingSampleRate = v;
            return this;
        }

        public Builder minThreadPoolSize(int v) {
            this.minThreadPoolSize = v;
            return this;
        }

        public Builder dynamicThreadScaling(boolean v) {
            this.dynamicThreadScaling = v;
            return this;
        }

        public Builder threadScaleUpThreshold(double v) {
            this.threadScaleUpThreshold = v;
            return this;
        }

        public Builder threadScaleDownThreshold(double v) {
            this.threadScaleDownThreshold = v;
            return this;
        }

        public Builder threadScaleUpDelayTicks(int v) {
            this.threadScaleUpDelayTicks = v;
            return this;
        }

        public Builder threadScaleDownDelayTicks(int v) {
            this.threadScaleDownDelayTicks = v;
            return this;
        }

        public Builder workStealingEnabled(boolean v) {
            this.workStealingEnabled = v;
            return this;
        }

        public Builder workStealingQueueSize(int v) {
            this.workStealingQueueSize = v;
            return this;
        }

        public Builder cpuAwareThreadSizing(boolean v) {
            this.cpuAwareThreadSizing = v;
            return this;
        }

        public Builder cpuLoadThreshold(double v) {
            this.cpuLoadThreshold = v;
            return this;
        }

        public Builder threadPoolKeepAliveSeconds(int v) {
            this.threadPoolKeepAliveSeconds = v;
            return this;
        }

        public Builder distanceCalculationInterval(int v) {
            this.distanceCalculationInterval = v;
            return this;
        }

        public Builder distanceApproximationEnabled(boolean v) {
            this.distanceApproximationEnabled = v;
            return this;
        }

        public Builder distanceCacheSize(int v) {
            this.distanceCacheSize = v;
            return this;
        }

        public Builder itemProcessingIntervalMultiplier(int v) {
            this.itemProcessingIntervalMultiplier = v;
            return this;
        }

        public Builder spatialGridUpdateInterval(int v) {
            this.spatialGridUpdateInterval = v;
            return this;
        }

        public Builder incrementalSpatialUpdates(boolean v) {
            this.incrementalSpatialUpdates = v;
            return this;
        }

        public PerformanceConfiguration build() {
            return new PerformanceConfiguration(this);
        }
    }
}

