/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions;

import com.kneaf.core.exceptions.KneafCoreException;

public class DatabaseException
extends KneafCoreException {
    private final DatabaseErrorType errorType;
    private final String databaseType;
    private final String key;

    public DatabaseException(DatabaseErrorType errorType, String message) {
        super(KneafCoreException.ErrorCategory.DATABASE_OPERATION, message);
        this.errorType = errorType;
        this.databaseType = null;
        this.key = null;
    }

    public DatabaseException(DatabaseErrorType errorType, String message, Throwable cause) {
        super(KneafCoreException.ErrorCategory.DATABASE_OPERATION, message, cause);
        this.errorType = errorType;
        this.databaseType = null;
        this.key = null;
    }

    public DatabaseException(DatabaseErrorType errorType, String operation, String databaseType, String key, String message, Throwable cause) {
        super(KneafCoreException.ErrorCategory.DATABASE_OPERATION, operation, message, String.format("Database: %s, Key: %s", databaseType, key), cause);
        this.errorType = errorType;
        this.databaseType = databaseType;
        this.key = key;
    }

    public DatabaseException(DatabaseErrorType errorType, String databaseType, String message, Throwable cause) {
        super(KneafCoreException.ErrorCategory.DATABASE_OPERATION, message, String.format("Database: %s", databaseType), cause);
        this.errorType = errorType;
        this.databaseType = databaseType;
        this.key = null;
    }

    public DatabaseErrorType getErrorType() {
        return this.errorType;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getKey() {
        return this.key;
    }

    public static DatabaseException asyncOperationFailed(String operation, String databaseType, String key, Throwable cause) {
        return new DatabaseException(DatabaseErrorType.ASYNC_OPERATION_FAILED, operation, databaseType, key, String.format("Async %s operation failed", operation), cause);
    }

    public static DatabaseException nativeLibraryError(String databaseType, String message, Throwable cause) {
        return new DatabaseException(DatabaseErrorType.NATIVE_LIBRARY_ERROR, databaseType, message, cause);
    }

    public static enum DatabaseErrorType {
        CONNECTION_FAILED("Database connection failed"),
        OPERATION_FAILED("Database operation failed"),
        TRANSACTION_FAILED("Database transaction failed"),
        VALIDATION_FAILED("Database validation failed"),
        BACKUP_FAILED("Database backup failed"),
        MAINTENANCE_FAILED("Database maintenance failed"),
        NATIVE_LIBRARY_ERROR("Native database library error"),
        ASYNC_OPERATION_FAILED("Async database operation failed");

        private final String description;

        private DatabaseErrorType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

