/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions;

public class KneafCoreException
extends RuntimeException {
    private final ErrorCategory category;
    private final String operation;
    private final Object context;

    public KneafCoreException(ErrorCategory category, String message) {
        super(message);
        this.category = category;
        this.operation = null;
        this.context = null;
    }

    public KneafCoreException(ErrorCategory category, String message, Throwable cause) {
        super(message, cause);
        this.category = category;
        this.operation = null;
        this.context = null;
    }

    public KneafCoreException(ErrorCategory category, String operation, String message, Throwable cause) {
        super(KneafCoreException.formatMessage(category, operation, message), cause);
        this.category = category;
        this.operation = operation;
        this.context = null;
    }

    public KneafCoreException(ErrorCategory category, String operation, String message, Object context, Throwable cause) {
        super(KneafCoreException.formatMessage(category, operation, message), cause);
        this.category = category;
        this.operation = operation;
        this.context = context;
    }

    public ErrorCategory getCategory() {
        return this.category;
    }

    public String getOperation() {
        return this.operation;
    }

    public Object getContext() {
        return this.context;
    }

    private static String formatMessage(ErrorCategory category, String operation, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(category.name()).append("] ");
        if (operation != null) {
            sb.append("Operation '").append(operation).append("': ");
        }
        sb.append(message);
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(": ");
        sb.append(this.getMessage());
        if (this.operation != null) {
            sb.append(" [Operation: ").append(this.operation).append("]");
        }
        if (this.context != null) {
            sb.append(" [Context: ").append(this.context).append("]");
        }
        if (this.getCause() != null) {
            sb.append(" [Cause: ").append(this.getCause().getMessage()).append("]");
        }
        return sb.toString();
    }

    public static enum ErrorCategory {
        DATABASE_OPERATION("Database operation failed"),
        NATIVE_LIBRARY("Native library error"),
        ASYNC_PROCESSING("Async processing error"),
        CONFIGURATION("Configuration error"),
        RESOURCE_MANAGEMENT("Resource management error"),
        PROTOCOL_ERROR("Protocol error"),
        VALIDATION_ERROR("Validation error"),
        SYSTEM_ERROR("System error");

        private final String description;

        private ErrorCategory(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

