/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import com.kneaf.core.performance.RustPerformance;
import com.mojang.logging.LogUtils;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkEvent;
import org.slf4j.Logger;

@EventBusSubscriber(modid="kneafcore")
public class ChunkGeneratorOptimizer {
    private static final Logger LOGGER = LogUtils.getLogger();

    private ChunkGeneratorOptimizer() {
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        int chunkZ;
        int chunkX;
        int generated;
        if (event.getLevel() instanceof ServerLevel && (generated = RustPerformance.preGenerateNearbyChunks(chunkX = event.getChunk().getPos().x, chunkZ = event.getChunk().getPos().z, 1)) > 0) {
            LOGGER.debug("Pre-generated {} chunks around ({}, {})", new Object[]{generated, chunkX, chunkZ});
        }
    }

    public static void shutdown() {
    }
}

