/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import com.kneaf.core.performance.RustPerformance;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.StampedLock;

public final class EnhancedNativeFloatBuffer
implements AutoCloseable {
    private static final Cleaner CLEANER = Cleaner.create();
    private static final int MIN_POOL_SIZE_PER_BUCKET = 5;
    private static final int MAX_POOL_SIZE_PER_BUCKET = 50;
    private static final int BUCKET_SIZE_POWER = 12;
    private static final int MAX_BUCKET_SIZE = 24;
    private static final long CLEANUP_INTERVAL_MS = 15000L;
    private static final long ADAPTIVE_CHECK_INTERVAL_MS = 5000L;
    private static final int MEMORY_PRESSURE_LOW = 0;
    private static final int MEMORY_PRESSURE_MODERATE = 1;
    private static final int MEMORY_PRESSURE_HIGH = 2;
    private static final int MEMORY_PRESSURE_CRITICAL = 3;
    private static final ConcurrentHashMap<Integer, LockFreePool> bufferPools = new ConcurrentHashMap();
    private static final AtomicReference<MemoryPressureLevel> currentPressure = new AtomicReference<MemoryPressureLevel>(new MemoryPressureLevel(0, System.currentTimeMillis()));
    private static final AtomicLong totalAllocations = new AtomicLong(0L);
    private static final AtomicLong totalReuses = new AtomicLong(0L);
    private static final AtomicLong totalFrees = new AtomicLong(0L);
    private static final AtomicLong allocationFailures = new AtomicLong(0L);
    private static final AtomicLong adaptiveResizes = new AtomicLong(0L);
    private static final AtomicReference<AdaptivePoolConfig> adaptiveConfig = new AtomicReference<AdaptivePoolConfig>(new AdaptivePoolConfig(10, 25, 0.75));
    private static final StampedLock configLock = new StampedLock();
    private final ByteBuffer buf;
    private final FloatBuffer view;
    private final long rows;
    private final long cols;
    private final long elementCount;
    private final int byteCapacity;
    private final Cleaner.Cleanable cleanable;
    private volatile boolean closed = false;
    private final boolean isPooled;
    private final int bucketIndex;
    private final long creationTime;

    private EnhancedNativeFloatBuffer(ByteBuffer buf, long rows, long cols, boolean isPooled, int bucketIndex) {
        if (buf == null) {
            throw new IllegalArgumentException("buf must not be null");
        }
        if (rows < 0L || cols < 0L) {
            throw new IllegalArgumentException("rows/cols must be non-negative");
        }
        this.buf = buf.order(ByteOrder.LITTLE_ENDIAN);
        this.rows = rows;
        this.cols = cols;
        this.elementCount = rows * cols;
        this.byteCapacity = this.buf.capacity();
        this.view = this.buf.asFloatBuffer();
        this.creationTime = System.currentTimeMillis();
        this.cleanable = CLEANER.register(this, new EnhancedState(this.buf, isPooled, bucketIndex, this.creationTime, 0));
        this.isPooled = isPooled;
        this.bucketIndex = bucketIndex;
    }

    private static int getBucketIndex(int byteCapacity) {
        int bucket = 0;
        for (int size = 4096; size < byteCapacity && bucket < 24; size <<= 1, ++bucket) {
        }
        return bucket;
    }

    private static PooledBuffer getFromEnhancedPool(int byteCapacity) {
        PooledBuffer pooled;
        int bucketIndex = EnhancedNativeFloatBuffer.getBucketIndex(byteCapacity);
        LockFreePool pool = bufferPools.get(bucketIndex);
        if (pool != null && (pooled = pool.poll()) != null) {
            pooled.buffer.clear();
            return pooled;
        }
        for (int i = bucketIndex + 1; i <= Math.min(bucketIndex + 2, 24); ++i) {
            PooledBuffer pooled2;
            LockFreePool largerPool = bufferPools.get(i);
            if (largerPool == null || (pooled2 = largerPool.poll()) == null) continue;
            pooled2.buffer.clear();
            return pooled2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performAdaptivePoolManagement() {
        long stamp = configLock.readLock();
        try {
            int totalBuffers = 0;
            int totalHighWater = 0;
            for (LockFreePool pool : bufferPools.values()) {
                totalBuffers += pool.getSize();
                totalHighWater += pool.getHighWaterMark();
            }
            double utilizationRate = totalHighWater > 0 ? (double)totalBuffers / (double)totalHighWater : 0.0;
            long currentTime = System.currentTimeMillis();
            MemoryPressureLevel currentLevel = currentPressure.get();
            int newPressureLevel = 0;
            if (utilizationRate > 0.9) {
                newPressureLevel = 3;
            } else if (utilizationRate > 0.7) {
                newPressureLevel = 2;
            } else if (utilizationRate > 0.5) {
                newPressureLevel = 1;
            }
            if (newPressureLevel != currentLevel.level || currentTime - currentLevel.timestamp > 5000L) {
                currentPressure.set(new MemoryPressureLevel(newPressureLevel, currentTime));
                adaptiveResizes.incrementAndGet();
            }
            if (newPressureLevel >= 2) {
                for (Map.Entry<Integer, LockFreePool> entry : bufferPools.entrySet()) {
                    LockFreePool pool = entry.getValue();
                    int currentSize = pool.getSize();
                    int targetSize = Math.max(1, currentSize / 4);
                    pool.clearExcess(targetSize);
                }
            } else if (newPressureLevel == 1) {
                for (Map.Entry<Integer, LockFreePool> entry : bufferPools.entrySet()) {
                    LockFreePool pool = entry.getValue();
                    int currentSize = pool.getSize();
                    int targetSize = Math.max(2, currentSize / 2);
                    pool.clearExcess(targetSize);
                }
            }
        }
        finally {
            configLock.unlockRead(stamp);
        }
    }

    public static EnhancedNativeFloatBuffer allocateEnhanced(long rows, long cols) {
        return EnhancedNativeFloatBuffer.allocateEnhanced(rows, cols, true);
    }

    /*
     * Exception decompiling
     */
    public static EnhancedNativeFloatBuffer allocateEnhanced(long rows, long cols, boolean usePool) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 2[TRYBLOCK], 6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ByteBuffer buffer() {
        if (this.closed) {
            throw new IllegalStateException("EnhancedNativeFloatBuffer is closed");
        }
        return this.buf;
    }

    public float getFloatAtIndex(int idx) {
        return this.view.get(idx);
    }

    public void setFloatAtIndex(int idx, float val) {
        this.view.put(idx, val);
    }

    public FloatBuffer asFloatBuffer() {
        this.checkOpen();
        return this.view.duplicate();
    }

    public FloatBuffer rowBuffer(int row) {
        this.checkOpen();
        if (row < 0 || (long)row >= this.rows) {
            throw new IndexOutOfBoundsException("row out of range");
        }
        int start = (int)((long)row * this.cols);
        FloatBuffer dup = this.view.duplicate();
        dup.position(start);
        dup.limit(start + (int)this.cols);
        return dup.slice();
    }

    public FloatBuffer colBuffer(int col) {
        this.checkOpen();
        if (col < 0 || (long)col >= this.cols) {
            throw new IndexOutOfBoundsException("col out of range");
        }
        int rCount = (int)this.rows;
        float[] tmp = new float[rCount];
        int base = col;
        int c = (int)this.cols;
        for (int r = 0; r < rCount; ++r) {
            tmp[r] = this.view.get(base + r * c);
        }
        return FloatBuffer.wrap(tmp);
    }

    public void fill(float value) {
        this.checkOpen();
        int cap = this.view.capacity();
        if (cap > 1000) {
            int chunkSize = Math.min(cap, 16384);
            float[] chunk = new float[chunkSize];
            Arrays.fill(chunk, value);
            for (int i = 0; i < cap; i += chunkSize) {
                int remaining = Math.min(chunkSize, cap - i);
                this.view.position(i);
                this.view.put(chunk, 0, remaining);
            }
            this.view.position(0);
        } else {
            for (int i = 0; i < cap; ++i) {
                this.view.put(i, value);
            }
        }
    }

    public void copyTo(EnhancedNativeFloatBuffer dest) {
        this.checkOpen();
        if (dest == null) {
            throw new IllegalArgumentException("dest is null");
        }
        if (dest.getElementCount() != this.getElementCount()) {
            throw new IllegalArgumentException("shape mismatch");
        }
        FloatBuffer s = this.asFloatBuffer();
        FloatBuffer d = dest.asFloatBuffer();
        d.position(0);
        s.position(0);
        d.put(s);
    }

    public float getFloatAt(long row, long col) {
        this.checkOpen();
        this.checkBounds(row, col);
        int idx = (int)(row * this.cols + col);
        return this.view.get(idx);
    }

    public void setFloatAt(long row, long col, float val) {
        this.checkOpen();
        this.checkBounds(row, col);
        int idx = (int)(row * this.cols + col);
        this.view.put(idx, val);
    }

    private void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException("EnhancedNativeFloatBuffer is closed");
        }
    }

    private void checkBounds(long row, long col) {
        if (row < 0L || col < 0L || row >= this.rows || col >= this.cols) {
            throw new IndexOutOfBoundsException("row/col out of range");
        }
    }

    public long getRows() {
        return this.rows;
    }

    public long getCols() {
        return this.cols;
    }

    public long getElementCount() {
        return this.elementCount;
    }

    public int getByteCapacity() {
        return this.byteCapacity;
    }

    public static String getEnhancedPoolStats() {
        StringBuilder stats = new StringBuilder();
        stats.append("Enhanced Buffer Pool Statistics:\n");
        stats.append("Total Allocations: ").append(totalAllocations.get()).append("\n");
        stats.append("Total Reuses: ").append(totalReuses.get()).append("\n");
        stats.append("Total Frees: ").append(totalFrees.get()).append("\n");
        stats.append("Allocation Failures: ").append(allocationFailures.get()).append("\n");
        stats.append("Adaptive Resizes: ").append(adaptiveResizes.get()).append("\n");
        stats.append("Reuse Rate: ").append(String.format("%.2f%%", totalAllocations.get() > 0L ? 100.0 * (double)totalReuses.get() / (double)totalAllocations.get() : 0.0)).append("\n");
        MemoryPressureLevel pressure = currentPressure.get();
        stats.append("Current Memory Pressure: ").append(EnhancedNativeFloatBuffer.getPressureName(pressure.level)).append("\n");
        AdaptivePoolConfig config = adaptiveConfig.get();
        stats.append("Pool Config - Min: ").append(config.minPoolSize).append(", Max: ").append(config.maxPoolSize).append(", Pressure Factor: ").append(config.pressureFactor).append("\n");
        stats.append("Pool Buckets:\n");
        int totalBuffers = 0;
        int totalHighWater = 0;
        for (Map.Entry<Integer, LockFreePool> entry : bufferPools.entrySet()) {
            LockFreePool pool = entry.getValue();
            int currentSize = pool.getSize();
            int highWater = pool.getHighWaterMark();
            int bucketByteSize = 1 << 12 + entry.getKey();
            totalBuffers += currentSize;
            totalHighWater += highWater;
            stats.append("  Bucket ").append(entry.getKey()).append(" (").append(bucketByteSize).append(" bytes): ").append(currentSize).append(" current, ").append(highWater).append(" peak\n");
        }
        stats.append("Total Buffers in Pools: ").append(totalBuffers).append("\n");
        stats.append("Total High Water Mark: ").append(totalHighWater).append("\n");
        stats.append("Pool Utilization: ").append(String.format("%.2f%%", totalHighWater > 0 ? 100.0 * (double)totalBuffers / (double)totalHighWater : 0.0)).append("\n");
        return stats.toString();
    }

    private static String getPressureName(int level) {
        return switch (level) {
            case 0 -> "LOW";
            case 1 -> "MODERATE";
            case 2 -> "HIGH";
            case 3 -> "CRITICAL";
            default -> "UNKNOWN";
        };
    }

    public static void forceEnhancedCleanup() {
        EnhancedNativeFloatBuffer.performAdaptivePoolManagement();
    }

    public static void clearEnhancedPools() {
        for (Map.Entry<Integer, LockFreePool> entry : bufferPools.entrySet()) {
            LockFreePool pool = entry.getValue();
            pool.clearExcess(0);
        }
        bufferPools.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAdaptiveConfig(int minPoolSize, int maxPoolSize, double pressureFactor) {
        long stamp = configLock.writeLock();
        try {
            adaptiveConfig.set(new AdaptivePoolConfig(minPoolSize, maxPoolSize, pressureFactor));
        }
        finally {
            configLock.unlockWrite(stamp);
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.cleanable.clean();
        }
    }

    static {
        Thread adaptiveThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(15000L);
                        EnhancedNativeFloatBuffer.performAdaptivePoolManagement();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    System.err.println("Error in adaptive pool management: " + e.getMessage());
                    continue;
                }
                break;
            }
        }, "EnhancedNativeFloatBuffer-AdaptiveManager");
        adaptiveThread.setDaemon(true);
        adaptiveThread.start();
    }

    private static final class EnhancedState
    implements Runnable {
        private final ByteBuffer buf;
        private final boolean isPooled;
        private final int bucketIndex;
        private final long creationTime;
        private final int reuseCount;

        EnhancedState(ByteBuffer buf, boolean isPooled, int bucketIndex, long creationTime, int reuseCount) {
            this.buf = buf;
            this.isPooled = isPooled;
            this.bucketIndex = bucketIndex;
            this.creationTime = creationTime;
            this.reuseCount = reuseCount;
        }

        private void returnToPool() {
            PooledBuffer pooled;
            int bucket;
            LockFreePool pool;
            if (this.reuseCount < 10 && System.currentTimeMillis() - this.creationTime < 300000L && (pool = bufferPools.computeIfAbsent(bucket = Math.max(0, Math.min(24, this.bucketIndex)), k -> new LockFreePool(bucket))).offer(pooled = new PooledBuffer(this.buf, this.bucketIndex, this.creationTime, this.reuseCount + 1))) {
                totalReuses.incrementAndGet();
                return;
            }
            this.freeBufferDirect();
        }

        private void freeBufferDirect() {
            try {
                RustPerformance.freeFloatBufferNative(this.buf);
                totalFrees.incrementAndGet();
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("Native library not available for buffer free: " + e.getMessage());
            }
            catch (Exception e) {
                System.err.println("Error freeing native buffer: " + e.getMessage());
            }
        }

        @Override
        public void run() {
            try {
                if (this.buf != null) {
                    if (this.isPooled && this.bucketIndex >= 0) {
                        this.returnToPool();
                    } else {
                        this.freeBufferDirect();
                    }
                }
            }
            catch (Exception t) {
                System.err.println("Error during enhanced buffer cleanup: " + t.getMessage());
            }
        }
    }

    private static final class LockFreePool {
        private final ConcurrentLinkedQueue<PooledBuffer> queue = new ConcurrentLinkedQueue();
        private final AtomicInteger size = new AtomicInteger(0);
        private final AtomicInteger highWaterMark = new AtomicInteger(0);
        private final int bucketIndex;

        LockFreePool(int bucketIndex) {
            this.bucketIndex = bucketIndex;
        }

        boolean offer(PooledBuffer buffer) {
            if (this.size.get() < this.getCurrentMaxSize()) {
                this.queue.offer(buffer);
                int newSize = this.size.incrementAndGet();
                this.highWaterMark.updateAndGet(current -> Math.max(current, newSize));
                return true;
            }
            return false;
        }

        PooledBuffer poll() {
            PooledBuffer buffer = this.queue.poll();
            if (buffer != null) {
                this.size.decrementAndGet();
            }
            return buffer;
        }

        int getSize() {
            return this.size.get();
        }

        int getHighWaterMark() {
            return this.highWaterMark.get();
        }

        void clearExcess(int targetSize) {
            PooledBuffer buffer;
            while (this.size.get() > targetSize && (buffer = this.queue.poll()) != null) {
                this.size.decrementAndGet();
                try {
                    RustPerformance.freeFloatBufferNative(buffer.buffer);
                    totalFrees.incrementAndGet();
                }
                catch (Exception e) {
                    System.err.println("Error freeing buffer in clearExcess: " + e.getMessage());
                }
            }
        }

        private int getCurrentMaxSize() {
            MemoryPressureLevel pressure = currentPressure.get();
            AdaptivePoolConfig config = adaptiveConfig.get();
            return switch (pressure.level) {
                case 0 -> config.maxPoolSize;
                case 1 -> (int)((double)config.maxPoolSize * config.pressureFactor);
                case 2 -> (int)((double)config.maxPoolSize * config.pressureFactor * 0.5);
                case 3 -> config.minPoolSize;
                default -> config.maxPoolSize;
            };
        }
    }

    private static final class PooledBuffer {
        final ByteBuffer buffer;
        final int bucketIndex;
        final long creationTime;
        final int reuseCount;

        PooledBuffer(ByteBuffer buffer, int bucketIndex, long creationTime, int reuseCount) {
            this.buffer = buffer;
            this.bucketIndex = bucketIndex;
            this.creationTime = creationTime;
            this.reuseCount = reuseCount;
        }
    }

    private static final class MemoryPressureLevel {
        final int level;
        final long timestamp;

        MemoryPressureLevel(int level, long timestamp) {
            this.level = level;
            this.timestamp = timestamp;
        }
    }

    private static final class AdaptivePoolConfig {
        final int minPoolSize;
        final int maxPoolSize;
        final double pressureFactor;

        AdaptivePoolConfig(int minPoolSize, int maxPoolSize, double pressureFactor) {
            this.minPoolSize = minPoolSize;
            this.maxPoolSize = maxPoolSize;
            this.pressureFactor = pressureFactor;
        }
    }
}

