/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import com.kneaf.core.performance.PerformanceConfig;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Deflater;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.slf4j.Logger;

@EventBusSubscriber(modid="kneafcore")
public class NetworkOptimizer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicReference<ScheduledExecutorService> networkExecutor = new AtomicReference();
    private static final List<Packet<?>> packetBatch = new ArrayList();
    private static final int BATCH_SIZE = 25;
    private static final ThreadLocal<Deflater> DEFLATER_LOCAL = ThreadLocal.withInitial(() -> new Deflater(1));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ScheduledExecutorService getNetworkExecutor() {
        ScheduledExecutorService exec = networkExecutor.get();
        if (exec != null) return exec;
        Class<NetworkOptimizer> clazz = NetworkOptimizer.class;
        synchronized (NetworkOptimizer.class) {
            exec = networkExecutor.get();
            if (exec != null) return exec;
            int pool = PerformanceConfig.load().getNetworkExecutorPoolSize();
            exec = Executors.newScheduledThreadPool(Math.max(1, pool));
            networkExecutor.set(exec);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    ScheduledExecutorService e = networkExecutor.get();
                    if (e != null) {
                        e.shutdownNow();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return exec;
        }
    }

    private NetworkOptimizer() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onServerTick(ServerTickEvent.Post event) {
        if (!packetBatch.isEmpty()) {
            NetworkOptimizer.getNetworkExecutor().submit(() -> NetworkOptimizer.sendBatchedPackets());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            LOGGER.info("Optimizing network for player: {}", (Object)player2.getName().getString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPacketToBatch(Packet<?> packet) {
        List<Packet<?>> list = packetBatch;
        synchronized (list) {
            packetBatch.add(packet);
            if (packetBatch.size() >= 25) {
                NetworkOptimizer.getNetworkExecutor().execute(NetworkOptimizer::sendBatchedPackets);
            } else if (packetBatch.size() >= 12) {
                NetworkOptimizer.getNetworkExecutor().schedule(NetworkOptimizer::sendBatchedPackets, 10L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressPacketData(byte[] data) {
        Deflater deflater = DEFLATER_LOCAL.get();
        deflater.reset();
        deflater.setInput(data);
        deflater.finish();
        try {
            ByteArrayOutputStream baos;
            block13: {
                byte[] byArray;
                baos = new ByteArrayOutputStream(data.length);
                try {
                    byte[] buffer = new byte[1024];
                    while (!deflater.finished()) {
                        int len = deflater.deflate(buffer);
                        if (len <= 0) continue;
                        baos.write(buffer, 0, len);
                    }
                    byte[] compressed = baos.toByteArray();
                    if (compressed.length >= data.length) break block13;
                    byArray = compressed;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            baos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to compress packet data: {}", (Object)e.getMessage());
                        byte[] byArray2 = data;
                        return byArray2;
                    }
                }
                baos.close();
                return byArray;
            }
            byte[] byArray = data;
            baos.close();
            return byArray;
        }
        finally {
            deflater.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendBatchedPackets() {
        ArrayList batch;
        List<Packet<?>> list = packetBatch;
        synchronized (list) {
            batch = new ArrayList(packetBatch);
            packetBatch.clear();
        }
        for (Packet packet : batch) {
            int rateLimitDelay;
            int estSize = 0;
            try {
                Method m = packet.getClass().getMethod("getPacketSize", new Class[0]);
                Object res = m.invoke((Object)packet, new Object[0]);
                if (res instanceof Integer) {
                    Integer integer = (Integer)res;
                    estSize = integer;
                }
            }
            catch (Exception ex) {
                estSize = packet.getClass().getSimpleName().length() * 10;
            }
            if (estSize > 1000) {
                byte[] raw = packet.toString().getBytes(StandardCharsets.UTF_8);
                byte[] compressed = NetworkOptimizer.compressPacketData(raw);
                LOGGER.debug("Compressed packet {} est {} -> {} bytes", new Object[]{packet.getClass().getSimpleName(), raw.length, compressed.length});
            }
            if ((rateLimitDelay = NetworkOptimizer.calculateRateLimitDelayByEstimate(packet, estSize)) > 0) {
                NetworkOptimizer.getNetworkExecutor().schedule(() -> LOGGER.debug("Rate-limited packet send: {} delayed {}ms", (Object)packet.getClass().getSimpleName(), (Object)rateLimitDelay), (long)rateLimitDelay, TimeUnit.MILLISECONDS);
                continue;
            }
            LOGGER.debug("Processed packet immediately: {}", (Object)packet.getClass().getSimpleName());
        }
        LOGGER.debug("Processed batched packets: {}", (Object)batch.size());
    }

    private static int calculateRateLimitDelayByEstimate(Packet<?> packet, int estSize) {
        String packetType = packet.getClass().getSimpleName();
        int size = estSize;
        if (size <= 0) {
            size = packetType.length() * 10;
        }
        int baseDelay = 2;
        if (packetType.contains("Chunk")) {
            baseDelay = 5;
        } else if (packetType.contains("Move") || packetType.contains("Entity")) {
            baseDelay = 1;
        }
        int sizeDelay = 0;
        if (size > 5000) {
            sizeDelay = 10;
        } else if (size > 1000) {
            sizeDelay = 5;
        }
        return baseDelay + sizeDelay;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                DEFLATER_LOCAL.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }
}

