/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PerformanceConfig {
    private static final String DEFAULT_CONFIG_PATH = "config/kneaf-performance.properties";
    private static final Logger LOGGER = Logger.getLogger(PerformanceConfig.class.getName());
    private final boolean enabled;
    private final int threadPoolSize;
    private final int logIntervalTicks;
    private final int scanIntervalTicks;
    private final double tpsThresholdForAsync;
    private final int maxEntitiesToCollect;
    private final double entityDistanceCutoff;
    private final long maxLogBytes;
    private final boolean adaptiveThreadPool;
    private final int maxThreadPoolSize;
    private final String[] excludedEntityTypes;
    private final int networkExecutorPoolSize;
    private final boolean profilingEnabled;
    private final long slowTickThresholdMs;
    private final int profilingSampleRate;
    private final int minThreadPoolSize;
    private final boolean dynamicThreadScaling;
    private final double threadScaleUpThreshold;
    private final double threadScaleDownThreshold;
    private final int threadScaleUpDelayTicks;
    private final int threadScaleDownDelayTicks;
    private final boolean workStealingEnabled;
    private final int workStealingQueueSize;
    private final boolean cpuAwareThreadSizing;
    private final double cpuLoadThreshold;
    private final int threadPoolKeepAliveSeconds;
    private final int distanceCalculationInterval;
    private final boolean distanceApproximationEnabled;
    private final int distanceCacheSize;
    private final int itemProcessingIntervalMultiplier;
    private final int spatialGridUpdateInterval;
    private final boolean incrementalSpatialUpdates;

    private PerformanceConfig(Builder b) {
        this.enabled = b.enabled;
        this.threadPoolSize = b.threadPoolSize;
        this.logIntervalTicks = b.logIntervalTicks;
        this.scanIntervalTicks = b.scanIntervalTicks;
        this.tpsThresholdForAsync = b.tpsThresholdForAsync;
        this.maxEntitiesToCollect = b.maxEntitiesToCollect;
        this.entityDistanceCutoff = b.entityDistanceCutoff;
        this.maxLogBytes = b.maxLogBytes;
        this.adaptiveThreadPool = b.adaptiveThreadPool;
        this.maxThreadPoolSize = b.maxThreadPoolSize;
        this.excludedEntityTypes = b.excludedEntityTypes == null ? new String[]{} : (String[])b.excludedEntityTypes.clone();
        this.networkExecutorPoolSize = b.networkExecutorPoolSize;
        this.profilingEnabled = b.profilingEnabled;
        this.slowTickThresholdMs = b.slowTickThresholdMs;
        this.profilingSampleRate = b.profilingSampleRate;
        this.minThreadPoolSize = b.minThreadPoolSize;
        this.dynamicThreadScaling = b.dynamicThreadScaling;
        this.threadScaleUpThreshold = b.threadScaleUpThreshold;
        this.threadScaleDownThreshold = b.threadScaleDownThreshold;
        this.threadScaleUpDelayTicks = b.threadScaleUpDelayTicks;
        this.threadScaleDownDelayTicks = b.threadScaleDownDelayTicks;
        this.workStealingEnabled = b.workStealingEnabled;
        this.workStealingQueueSize = b.workStealingQueueSize;
        this.cpuAwareThreadSizing = b.cpuAwareThreadSizing;
        this.cpuLoadThreshold = b.cpuLoadThreshold;
        this.threadPoolKeepAliveSeconds = b.threadPoolKeepAliveSeconds;
        this.distanceCalculationInterval = b.distanceCalculationInterval;
        this.distanceApproximationEnabled = b.distanceApproximationEnabled;
        this.distanceCacheSize = b.distanceCacheSize;
        this.itemProcessingIntervalMultiplier = b.itemProcessingIntervalMultiplier;
        this.spatialGridUpdateInterval = b.spatialGridUpdateInterval;
        this.incrementalSpatialUpdates = b.incrementalSpatialUpdates;
        this.validateConfiguration();
    }

    private void validateConfiguration() {
        if (this.minThreadPoolSize > this.maxThreadPoolSize) {
            throw new IllegalArgumentException("minThreadPoolSize (" + this.minThreadPoolSize + ") cannot be greater than maxThreadPoolSize (" + this.maxThreadPoolSize + ")");
        }
        if (this.threadScaleUpThreshold <= this.threadScaleDownThreshold) {
            throw new IllegalArgumentException("threadScaleUpThreshold (" + this.threadScaleUpThreshold + ") must be greater than threadScaleDownThreshold (" + this.threadScaleDownThreshold + ")");
        }
        if (this.scanIntervalTicks < 1 || this.scanIntervalTicks > 100) {
            throw new IllegalArgumentException("scanIntervalTicks must be between 1 and 100, got: " + this.scanIntervalTicks);
        }
        if (this.tpsThresholdForAsync < 10.0 || this.tpsThresholdForAsync > 20.0) {
            throw new IllegalArgumentException("tpsThresholdForAsync must be between 10.0 and 20.0, got: " + this.tpsThresholdForAsync);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getLogIntervalTicks() {
        return this.logIntervalTicks;
    }

    public int getScanIntervalTicks() {
        return this.scanIntervalTicks;
    }

    public double getTpsThresholdForAsync() {
        return this.tpsThresholdForAsync;
    }

    public int getMaxEntitiesToCollect() {
        return this.maxEntitiesToCollect;
    }

    public double getEntityDistanceCutoff() {
        return this.entityDistanceCutoff;
    }

    public long getMaxLogBytes() {
        return this.maxLogBytes;
    }

    public boolean isAdaptiveThreadPool() {
        return this.adaptiveThreadPool;
    }

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public String[] getExcludedEntityTypes() {
        return (String[])this.excludedEntityTypes.clone();
    }

    public int getNetworkExecutorPoolSize() {
        return this.networkExecutorPoolSize;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public long getSlowTickThresholdMs() {
        return this.slowTickThresholdMs;
    }

    public int getProfilingSampleRate() {
        return this.profilingSampleRate;
    }

    public int getMinThreadPoolSize() {
        return this.minThreadPoolSize;
    }

    public boolean isDynamicThreadScaling() {
        return this.dynamicThreadScaling;
    }

    public double getThreadScaleUpThreshold() {
        return this.threadScaleUpThreshold;
    }

    public double getThreadScaleDownThreshold() {
        return this.threadScaleDownThreshold;
    }

    public int getThreadScaleUpDelayTicks() {
        return this.threadScaleUpDelayTicks;
    }

    public int getThreadScaleDownDelayTicks() {
        return this.threadScaleDownDelayTicks;
    }

    public boolean isWorkStealingEnabled() {
        return this.workStealingEnabled;
    }

    public int getWorkStealingQueueSize() {
        return this.workStealingQueueSize;
    }

    public boolean isCpuAwareThreadSizing() {
        return this.cpuAwareThreadSizing;
    }

    public double getCpuLoadThreshold() {
        return this.cpuLoadThreshold;
    }

    public int getThreadPoolKeepAliveSeconds() {
        return this.threadPoolKeepAliveSeconds;
    }

    public int getDistanceCalculationInterval() {
        return this.distanceCalculationInterval;
    }

    public boolean isDistanceApproximationEnabled() {
        return this.distanceApproximationEnabled;
    }

    public int getDistanceCacheSize() {
        return this.distanceCacheSize;
    }

    public int getItemProcessingIntervalMultiplier() {
        return this.itemProcessingIntervalMultiplier;
    }

    public int getSpatialGridUpdateInterval() {
        return this.spatialGridUpdateInterval;
    }

    public boolean isIncrementalSpatialUpdates() {
        return this.incrementalSpatialUpdates;
    }

    public static PerformanceConfig load() {
        Properties props;
        block9: {
            props = new Properties();
            Path path = Paths.get(DEFAULT_CONFIG_PATH, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                    props.load(in);
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block9;
                    LOGGER.log(Level.WARNING, "Failed to read performance config at {0}, using defaults", path);
                    LOGGER.log(Level.FINE, "Exception reading performance config", e);
                }
            }
        }
        boolean enabled = Boolean.parseBoolean(props.getProperty("enabled", "true"));
        int threadPoolSize = PerformanceConfig.parseIntOrDefault(props.getProperty("threadPoolSize"), 4);
        int logIntervalTicks = PerformanceConfig.parseIntOrDefault(props.getProperty("logIntervalTicks"), 100);
        int scanIntervalTicks = PerformanceConfig.parseIntOrDefault(props.getProperty("scanIntervalTicks"), 1);
        double tpsThresholdForAsync = PerformanceConfig.parseDoubleOrDefault(props.getProperty("tpsThresholdForAsync"), 19.0);
        int maxEntitiesToCollect = PerformanceConfig.parseIntOrDefault(props.getProperty("maxEntitiesToCollect"), 20000);
        double entityDistanceCutoff = PerformanceConfig.parseDoubleOrDefault(props.getProperty("entityDistanceCutoff"), 256.0);
        boolean adaptiveThreadPool = Boolean.parseBoolean(props.getProperty("adaptiveThreadPool", "false"));
        int maxThreadPoolSize = PerformanceConfig.parseIntOrDefault(props.getProperty("maxThreadPoolSize"), Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
        String excluded = props.getProperty("excludedEntityTypes", "");
        String[] excludedEntityTypes = excluded.isBlank() ? new String[]{} : excluded.split("\\s*,\\s*");
        int networkExecutorPoolSize = PerformanceConfig.parseIntOrDefault(props.getProperty("networkExecutorPoolSize"), Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
        boolean profilingEnabled = Boolean.parseBoolean(props.getProperty("profilingEnabled", "true"));
        long slowTickThresholdMs = PerformanceConfig.parseLongOrDefault(props.getProperty("slowTickThresholdMs"), 50L);
        int profilingSampleRate = PerformanceConfig.parseIntOrDefault(props.getProperty("profilingSampleRate"), 1);
        long maxLogBytes = PerformanceConfig.parseLongOrDefault(props.getProperty("maxLogBytes"), 0xA00000L);
        Builder b = new Builder().enabled(enabled).threadPoolSize(threadPoolSize).logIntervalTicks(logIntervalTicks).scanIntervalTicks(scanIntervalTicks).tpsThresholdForAsync(tpsThresholdForAsync).maxEntitiesToCollect(maxEntitiesToCollect).entityDistanceCutoff(entityDistanceCutoff).maxLogBytes(maxLogBytes).adaptiveThreadPool(adaptiveThreadPool).maxThreadPoolSize(maxThreadPoolSize).excludedEntityTypes(excludedEntityTypes).networkExecutorPoolSize(networkExecutorPoolSize).profilingEnabled(profilingEnabled).slowTickThresholdMs(slowTickThresholdMs).profilingSampleRate(profilingSampleRate);
        return b.build();
    }

    private static long parseLongOrDefault(String v, long def) {
        if (v == null) {
            return def;
        }
        try {
            return Long.parseLong(v.trim());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private static int parseIntOrDefault(String v, int def) {
        if (v == null) {
            return def;
        }
        try {
            return Integer.parseInt(v.trim());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private static double parseDoubleOrDefault(String v, double def) {
        if (v == null) {
            return def;
        }
        try {
            return Double.parseDouble(v.trim());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public String toString() {
        return "PerformanceConfig{enabled=" + this.enabled + ", threadPoolSize=" + this.threadPoolSize + ", logIntervalTicks=" + this.logIntervalTicks + ", scanIntervalTicks=" + this.scanIntervalTicks + ", tpsThresholdForAsync=" + this.tpsThresholdForAsync + ", maxEntitiesToCollect=" + this.maxEntitiesToCollect + ", entityDistanceCutoff=" + this.entityDistanceCutoff + ", maxLogBytes=" + this.maxLogBytes + ", adaptiveThreadPool=" + this.adaptiveThreadPool + ", maxThreadPoolSize=" + this.maxThreadPoolSize + ", excludedEntityTypes=" + Arrays.toString(this.excludedEntityTypes) + ", profilingEnabled=" + this.profilingEnabled + ", slowTickThresholdMs=" + this.slowTickThresholdMs + ", profilingSampleRate=" + this.profilingSampleRate + "}";
    }

    public static final class Builder {
        private boolean enabled = true;
        private int threadPoolSize = 4;
        private int logIntervalTicks = 100;
        private int scanIntervalTicks = 1;
        private double tpsThresholdForAsync = 19.0;
        private int maxEntitiesToCollect = 20000;
        private double entityDistanceCutoff = 256.0;
        private long maxLogBytes = 0xA00000L;
        private boolean adaptiveThreadPool = false;
        private int maxThreadPoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        private String[] excludedEntityTypes = new String[0];
        private int networkExecutorPoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        private boolean profilingEnabled = true;
        private long slowTickThresholdMs = 50L;
        private int profilingSampleRate = 100;
        private int minThreadPoolSize = 2;
        private boolean dynamicThreadScaling = true;
        private double threadScaleUpThreshold = 0.8;
        private double threadScaleDownThreshold = 0.3;
        private int threadScaleUpDelayTicks = 100;
        private int threadScaleDownDelayTicks = 200;
        private boolean workStealingEnabled = true;
        private int workStealingQueueSize = 100;
        private boolean cpuAwareThreadSizing;
        private double cpuLoadThreshold;
        private int threadPoolKeepAliveSeconds;
        private int distanceCalculationInterval = 1;
        private boolean distanceApproximationEnabled = true;
        private int distanceCacheSize = 100;
        private int itemProcessingIntervalMultiplier = 1;
        private int spatialGridUpdateInterval = 1;
        private boolean incrementalSpatialUpdates = true;

        public Builder enabled(boolean v) {
            this.enabled = v;
            return this;
        }

        public Builder threadPoolSize(int v) {
            this.threadPoolSize = v;
            return this;
        }

        public Builder logIntervalTicks(int v) {
            this.logIntervalTicks = v;
            return this;
        }

        public Builder scanIntervalTicks(int v) {
            this.scanIntervalTicks = v;
            return this;
        }

        public Builder tpsThresholdForAsync(double v) {
            this.tpsThresholdForAsync = v;
            return this;
        }

        public Builder maxEntitiesToCollect(int v) {
            this.maxEntitiesToCollect = v;
            return this;
        }

        public Builder entityDistanceCutoff(double v) {
            this.entityDistanceCutoff = v;
            return this;
        }

        public Builder maxLogBytes(long v) {
            this.maxLogBytes = v;
            return this;
        }

        public Builder adaptiveThreadPool(boolean v) {
            this.adaptiveThreadPool = v;
            return this;
        }

        public Builder maxThreadPoolSize(int v) {
            this.maxThreadPoolSize = v;
            return this;
        }

        public Builder excludedEntityTypes(String[] v) {
            this.excludedEntityTypes = v == null ? new String[]{} : (String[])v.clone();
            return this;
        }

        public Builder networkExecutorPoolSize(int v) {
            this.networkExecutorPoolSize = v;
            return this;
        }

        public Builder profilingEnabled(boolean v) {
            this.profilingEnabled = v;
            return this;
        }

        public Builder slowTickThresholdMs(long v) {
            this.slowTickThresholdMs = v;
            return this;
        }

        public Builder profilingSampleRate(int v) {
            this.profilingSampleRate = v;
            return this;
        }

        public Builder minThreadPoolSize(int v) {
            this.minThreadPoolSize = v;
            return this;
        }

        public Builder dynamicThreadScaling(boolean v) {
            this.dynamicThreadScaling = v;
            return this;
        }

        public Builder threadScaleUpThreshold(double v) {
            this.threadScaleUpThreshold = v;
            return this;
        }

        public Builder threadScaleDownThreshold(double v) {
            this.threadScaleDownThreshold = v;
            return this;
        }

        public Builder threadScaleUpDelayTicks(int v) {
            this.threadScaleUpDelayTicks = v;
            return this;
        }

        public Builder threadScaleDownDelayTicks(int v) {
            this.threadScaleDownDelayTicks = v;
            return this;
        }

        public Builder workStealingEnabled(boolean v) {
            this.workStealingEnabled = v;
            return this;
        }

        public Builder workStealingQueueSize(int v) {
            this.workStealingQueueSize = v;
            return this;
        }

        public Builder cpuAwareThreadSizing(boolean v) {
            this.cpuAwareThreadSizing = v;
            return this;
        }

        public Builder cpuLoadThreshold(double v) {
            this.cpuLoadThreshold = v;
            return this;
        }

        public Builder threadPoolKeepAliveSeconds(int v) {
            this.threadPoolKeepAliveSeconds = v;
            return this;
        }

        public Builder distanceCalculationInterval(int v) {
            this.distanceCalculationInterval = v;
            return this;
        }

        public Builder distanceApproximationEnabled(boolean v) {
            this.distanceApproximationEnabled = v;
            return this;
        }

        public Builder distanceCacheSize(int v) {
            this.distanceCacheSize = v;
            return this;
        }

        public Builder itemProcessingIntervalMultiplier(int v) {
            this.itemProcessingIntervalMultiplier = v;
            return this;
        }

        public Builder spatialGridUpdateInterval(int v) {
            this.spatialGridUpdateInterval = v;
            return this;
        }

        public Builder incrementalSpatialUpdates(boolean v) {
            this.incrementalSpatialUpdates = v;
            return this;
        }

        public PerformanceConfig build() {
            boolean vEnabled = this.enabled;
            int vThreadPoolSize = Math.max(1, this.threadPoolSize);
            int vLogIntervalTicks = Math.max(1, this.logIntervalTicks);
            int vScanIntervalTicks = Math.max(1, this.scanIntervalTicks);
            double vTpsThresholdForAsync = this.tpsThresholdForAsync;
            int vMaxEntitiesToCollect = Math.max(1, this.maxEntitiesToCollect);
            double vEntityDistanceCutoff = Math.max(0.0, this.entityDistanceCutoff);
            long vMaxLogBytes = Math.max(0L, this.maxLogBytes);
            boolean vAdaptiveThreadPool = this.adaptiveThreadPool;
            int vMaxThreadPoolSize = Math.max(1, this.maxThreadPoolSize);
            String[] vExcludedEntityTypes = this.excludedEntityTypes == null ? new String[]{} : this.excludedEntityTypes;
            int vNetworkExecutorPoolSize = Math.max(1, this.networkExecutorPoolSize);
            boolean vProfilingEnabled = this.profilingEnabled;
            long vSlowTickThresholdMs = Math.max(1L, this.slowTickThresholdMs);
            int vProfilingSampleRate = Math.max(1, this.profilingSampleRate);
            int vDistanceCalculationInterval = Math.max(1, this.distanceCalculationInterval);
            boolean vDistanceApproximationEnabled = this.distanceApproximationEnabled;
            int vDistanceCacheSize = Math.max(100, this.distanceCacheSize);
            int vItemProcessingIntervalMultiplier = Math.max(1, this.itemProcessingIntervalMultiplier);
            int vSpatialGridUpdateInterval = Math.max(1, this.spatialGridUpdateInterval);
            boolean vIncrementalSpatialUpdates = this.incrementalSpatialUpdates;
            Builder validated = new Builder();
            validated.enabled(vEnabled).threadPoolSize(vThreadPoolSize).logIntervalTicks(vLogIntervalTicks).scanIntervalTicks(vScanIntervalTicks).tpsThresholdForAsync(vTpsThresholdForAsync).maxEntitiesToCollect(vMaxEntitiesToCollect).entityDistanceCutoff(vEntityDistanceCutoff).maxLogBytes(vMaxLogBytes).adaptiveThreadPool(vAdaptiveThreadPool).maxThreadPoolSize(vMaxThreadPoolSize).excludedEntityTypes(vExcludedEntityTypes).networkExecutorPoolSize(vNetworkExecutorPoolSize).profilingEnabled(vProfilingEnabled).slowTickThresholdMs(vSlowTickThresholdMs).profilingSampleRate(vProfilingSampleRate);
            validated.distanceCalculationInterval(vDistanceCalculationInterval).distanceApproximationEnabled(vDistanceApproximationEnabled).distanceCacheSize(vDistanceCacheSize).itemProcessingIntervalMultiplier(vItemProcessingIntervalMultiplier).spatialGridUpdateInterval(vSpatialGridUpdateInterval).incrementalSpatialUpdates(vIncrementalSpatialUpdates);
            int vMinThreadPoolSize = Math.max(1, this.minThreadPoolSize);
            boolean vDynamicThreadScaling = this.dynamicThreadScaling;
            double vThreadScaleUpThreshold = Math.clamp(0.1, this.threadScaleUpThreshold, 1.0);
            double vThreadScaleDownThreshold = Math.clamp(0.1, this.threadScaleDownThreshold, 1.0);
            int vThreadScaleUpDelayTicks = Math.max(1, this.threadScaleUpDelayTicks);
            int vThreadScaleDownDelayTicks = Math.max(1, this.threadScaleDownDelayTicks);
            boolean vWorkStealingEnabled = this.workStealingEnabled;
            int vWorkStealingQueueSize = Math.max(1, this.workStealingQueueSize);
            boolean vCpuAwareThreadSizing = this.cpuAwareThreadSizing;
            double vCpuLoadThreshold = Math.clamp(0.1, this.cpuLoadThreshold, 1.0);
            int vThreadPoolKeepAliveSeconds = Math.max(1, this.threadPoolKeepAliveSeconds);
            validated.minThreadPoolSize(vMinThreadPoolSize).dynamicThreadScaling(vDynamicThreadScaling).threadScaleUpThreshold(vThreadScaleUpThreshold).threadScaleDownThreshold(vThreadScaleDownThreshold).threadScaleUpDelayTicks(vThreadScaleUpDelayTicks).threadScaleDownDelayTicks(vThreadScaleDownDelayTicks).workStealingEnabled(vWorkStealingEnabled).workStealingQueueSize(vWorkStealingQueueSize).cpuAwareThreadSizing(vCpuAwareThreadSizing).cpuLoadThreshold(vCpuLoadThreshold).threadPoolKeepAliveSeconds(vThreadPoolKeepAliveSeconds);
            return new PerformanceConfig(validated);
        }
    }
}

