/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import com.kneaf.core.performance.PerformanceConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;

public final class PerformanceMetricsLogger {
    private static final Path LOG_PATH = Paths.get("run", "logs", "kneaf-performance.log");
    private static final Path LOG_ARCHIVE_DIR = Paths.get("run", "logs", "archive");
    private static final PerformanceConfig CONFIG = PerformanceConfig.load();

    private PerformanceMetricsLogger() {
    }

    private static synchronized void ensureLogDir() throws IOException {
        Path dir = LOG_PATH.getParent();
        if (dir != null && !Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        if (!Files.exists(LOG_PATH, new LinkOption[0])) {
            Files.createFile(LOG_PATH, new FileAttribute[0]);
        }
    }

    public static synchronized void logLine(String line) {
        try {
            PerformanceMetricsLogger.rotateLogIfNeeded();
            PerformanceMetricsLogger.ensureLogDir();
            try (PrintWriter out = new PrintWriter(Files.newBufferedWriter(LOG_PATH, StandardCharsets.UTF_8, StandardOpenOption.APPEND));){
                out.println(Instant.now().toString() + " " + line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void logOptimizations(String summary) {
        PerformanceMetricsLogger.logLine(summary);
    }

    public static synchronized void rotateLogIfNeeded() {
        try {
            PerformanceMetricsLogger.ensureLogDir();
            if (!Files.exists(LOG_PATH, new LinkOption[0])) {
                return;
            }
            long maxBytes = CONFIG.getMaxLogBytes();
            long size = Files.size(LOG_PATH);
            if (size > maxBytes && maxBytes > 0L) {
                PerformanceMetricsLogger.rotateNow();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void rotateNow() {
        try {
            PerformanceMetricsLogger.ensureLogDir();
            if (!Files.exists(LOG_PATH, new LinkOption[0])) {
                return;
            }
            if (!Files.exists(LOG_ARCHIVE_DIR, new LinkOption[0])) {
                Files.createDirectories(LOG_ARCHIVE_DIR, new FileAttribute[0]);
            }
            String name = "kneaf-performance-" + Instant.now().toString().replace(':', '-') + ".log";
            Path target = LOG_ARCHIVE_DIR.resolve(name);
            Files.move(LOG_PATH, target, new CopyOption[0]);
            Files.createFile(LOG_PATH, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

