/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class ResultEnvelope {
    public long taskId;
    public int status;
    public byte[] payload;
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = 1;

    public ResultEnvelope() {
    }

    public ResultEnvelope(long taskId, int status, byte[] payload) {
        this.taskId = taskId;
        this.status = status;
        this.payload = payload;
    }

    public static ResultEnvelope fromBytes(byte[] b) {
        if (b == null || b.length < 13) {
            throw new IllegalArgumentException("invalid result envelope");
        }
        ByteBuffer bb = ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN);
        long id = bb.getLong();
        int status = bb.get() & 0xFF;
        int len = bb.getInt();
        if (len < 0 || bb.remaining() < len) {
            throw new IllegalArgumentException("invalid payload length");
        }
        byte[] p = new byte[len];
        if (len > 0) {
            bb.get(p);
        }
        return new ResultEnvelope(id, status, p);
    }

    public boolean isError() {
        return this.status == 1;
    }

    public String payloadAsString() {
        return this.payload == null ? "" : new String(this.payload, StandardCharsets.UTF_8);
    }
}

