/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kneaf.core.KneafCore;
import com.kneaf.core.async.AsyncProcessor;
import com.kneaf.core.binary.ManualSerializers;
import com.kneaf.core.data.BlockEntityData;
import com.kneaf.core.data.EntityData;
import com.kneaf.core.data.ItemEntityData;
import com.kneaf.core.data.MobData;
import com.kneaf.core.data.PlayerData;
import com.kneaf.core.exceptions.AsyncProcessingException;
import com.kneaf.core.performance.NativeFloatBufferAllocation;
import com.kneaf.core.performance.NativeLibraryLoader;
import com.kneaf.core.performance.RustPerformanceException;
import com.kneaf.core.protocol.ProtocolProcessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class RustPerformance {
    private static final String ENTITIES_KEY = "entities";
    private static final String ITEMS_KEY = "items";
    private static final String MOBS_KEY = "mobs";
    private static final String BLOCKS_KEY = "blocks";
    private static final String PLAYERS_KEY = "players";
    private static final String BINARY_FALLBACK_MESSAGE = "Binary protocol failed, falling back to JSON: {}";
    private static final AsyncProcessor asyncProcessor;
    private static final int BATCH_SIZE = 50;
    private static final long BATCH_TIMEOUT_MS = 35L;
    private static final ConcurrentLinkedQueue<BatchRequest> pendingRequests;
    private static volatile boolean batchProcessorRunning;
    private static final Object batchLock;
    private static final ConcurrentLinkedQueue<Connection> connectionPool;
    private static final int MAX_CONNECTIONS = 10;
    private static volatile boolean connectionPoolInitialized;
    private static long tickCount;
    private static double currentTPS;
    private static long totalEntitiesProcessed;
    private static long totalMobsProcessed;
    private static long totalBlocksProcessed;
    private static long totalMerged;
    private static long totalDespawned;
    private static final String TICK_COUNT_KEY = "tickCount";
    private static final Gson gson;
    private static volatile boolean nativeAvailable;
    private static volatile boolean nativeErrRedirectInstalled;
    private static final ProtocolProcessor protocolProcessor;

    private RustPerformance() {
    }

    public static Connection acquireConnection() throws SQLException {
        Connection conn;
        if (!connectionPoolInitialized) {
            RustPerformance.initializeConnectionPool();
        }
        if ((conn = connectionPool.poll()) != null) {
            try {
                if (!conn.isClosed()) {
                    return conn;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return RustPerformance.createNewConnection();
    }

    public static void releaseConnection(Connection conn) {
        if (conn != null && connectionPool.size() < 10) {
            try {
                if (!conn.isClosed()) {
                    if (!conn.getAutoCommit()) {
                        conn.rollback();
                    }
                    connectionPool.offer(conn);
                    return;
                }
            }
            catch (SQLException e) {
                KneafCore.LOGGER.warn("Failed to release connection: {}", (Object)e.getMessage());
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static synchronized void initializeConnectionPool() {
        if (connectionPoolInitialized) {
            return;
        }
        try {
            for (int i = 0; i < 5; ++i) {
                connectionPool.offer(RustPerformance.createNewConnection());
            }
            connectionPoolInitialized = true;
            KneafCore.LOGGER.info("Database connection pool initialized");
        }
        catch (Exception e) {
            KneafCore.LOGGER.warn("Failed to initialize connection pool: {}", (Object)e.getMessage());
        }
    }

    private static Connection createNewConnection() throws SQLException {
        throw new SQLException("Database connection not configured. Configure DB or remove DB usage.");
    }

    public static void setCurrentTPS(double currentTPS) {
        RustPerformance.currentTPS = currentTPS;
    }

    private static void ensureNativeAvailable() {
        if (!nativeAvailable) {
            throw new RustPerformanceException("Rust native library is not available");
        }
    }

    private static void tryLoadNative(Path tempFile) {
        try {
            System.load(tempFile.toAbsolutePath().toString());
            nativeAvailable = true;
            KneafCore.LOGGER.info("Successfully loaded native library");
        }
        catch (Exception e) {
            KneafCore.LOGGER.warn("Failed to load native library binary: {}. Native optimizations disabled.", (Object)e.getMessage());
            nativeAvailable = false;
        }
    }

    public static void logFromNative(String level, String msg) {
        if (level == null) {
            level = "INFO";
        }
        if (msg == null) {
            msg = "";
        }
        switch (level.toUpperCase()) {
            case "TRACE": {
                KneafCore.LOGGER.trace(msg);
                break;
            }
            case "DEBUG": {
                KneafCore.LOGGER.debug(msg);
                break;
            }
            case "WARN": {
                KneafCore.LOGGER.warn(msg);
                break;
            }
            case "ERROR": {
                KneafCore.LOGGER.error(msg);
                break;
            }
            default: {
                KneafCore.LOGGER.info(msg);
            }
        }
    }

    private static void installNativeErrRedirector() {
        if (nativeErrRedirectInstalled) {
            return;
        }
        try {
            OutputStream os = new OutputStream(){
                private final ByteArrayOutputStream buf = new ByteArrayOutputStream();

                @Override
                public synchronized void write(int b) throws IOException {
                    this.buf.write(b);
                    if (b == 10) {
                        this.flush();
                    }
                }

                @Override
                public synchronized void flush() throws IOException {
                    String s = this.buf.toString("UTF-8");
                    if (s.endsWith("\n")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    if (!s.isEmpty()) {
                        KneafCore.LOGGER.error("[rust] {}", (Object)s);
                    }
                    this.buf.reset();
                }
            };
            PrintStream ps = new PrintStream(os, true, "UTF-8");
            System.setErr(ps);
            nativeErrRedirectInstalled = true;
            KneafCore.LOGGER.info("Installed native stderr redirector to KneafCore.LOGGER");
        }
        catch (Throwable t) {
            KneafCore.LOGGER.warn("Failed to install native stderr redirector: {}", (Object)t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startBatchProcessor() {
        Object object = batchLock;
        synchronized (object) {
            if (batchProcessorRunning) {
                return;
            }
            batchProcessorRunning = true;
            CompletableFuture.runAsync(() -> {
                while (batchProcessorRunning) {
                    try {
                        RustPerformance.processBatch();
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    catch (Exception e) {
                        KneafCore.LOGGER.error("Error in batch processor", (Throwable)e);
                    }
                }
            });
        }
    }

    private static List<BatchRequest> collectBatch() {
        ArrayList<BatchRequest> batch = new ArrayList<BatchRequest>();
        long startTime = System.currentTimeMillis();
        boolean continueCollecting = true;
        while (continueCollecting && batch.size() < 50 && System.currentTimeMillis() - startTime < 35L) {
            BatchRequest request = pendingRequests.poll();
            if (request != null) {
                batch.add(request);
                continue;
            }
            if (!batch.isEmpty()) {
                continueCollecting = false;
                continue;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continueCollecting = false;
            }
        }
        return batch;
    }

    private static void processBatch() {
        List<BatchRequest> batch = RustPerformance.collectBatch();
        if (batch.isEmpty()) {
            return;
        }
        HashMap<String, List<BatchRequest>> batchedByType = new HashMap<String, List<BatchRequest>>();
        for (BatchRequest req : batch) {
            batchedByType.computeIfAbsent(req.type, k -> new ArrayList()).add(req);
        }
        RustPerformance.processBatchedRequests(batchedByType);
    }

    private static void processBatchedRequests(Map<String, List<BatchRequest>> batchedByType) {
        block14: for (Map.Entry<String, List<BatchRequest>> entry : batchedByType.entrySet()) {
            String type = entry.getKey();
            List<BatchRequest> typeBatch = entry.getValue();
            try {
                switch (type) {
                    case "entities": {
                        RustPerformance.processEntityBatch(typeBatch);
                        break;
                    }
                    case "items": {
                        RustPerformance.processItemBatch(typeBatch);
                        break;
                    }
                    case "mobs": {
                        RustPerformance.processMobBatch(typeBatch);
                        break;
                    }
                    case "blocks": {
                        RustPerformance.processBlockBatch(typeBatch);
                        break;
                    }
                    default: {
                        for (BatchRequest req : typeBatch) {
                            req.future.complete(RustPerformance.processIndividualRequest());
                        }
                        continue block14;
                    }
                }
            }
            catch (Exception e) {
                KneafCore.LOGGER.error("Error processing {} batch of size {}", new Object[]{type, typeBatch.size(), e});
                for (BatchRequest req : typeBatch) {
                    req.future.completeExceptionally(e);
                }
            }
        }
    }

    private static void processEntityBatch(List<BatchRequest> batch) {
        if (batch.isEmpty()) {
            return;
        }
        int totalEntities = 0;
        int totalPlayers = 0;
        for (BatchRequest req : batch) {
            Map data = (Map)req.data;
            List entities = (List)data.get(ENTITIES_KEY);
            List players = (List)data.get(PLAYERS_KEY);
            totalEntities += entities.size();
            totalPlayers += players.size();
        }
        ArrayList<EntityData> allEntities = new ArrayList<EntityData>(totalEntities);
        ArrayList<PlayerData> allPlayers = new ArrayList<PlayerData>(totalPlayers);
        HashMap<Integer, List> resultMapping = HashMap.newHashMap(totalEntities);
        for (int i = 0; i < batch.size(); ++i) {
            BatchRequest req = batch.get(i);
            Map data = (Map)req.data;
            List entities = (List)data.get(ENTITIES_KEY);
            List players = (List)data.get(PLAYERS_KEY);
            allEntities.addAll(entities);
            allPlayers.addAll(players);
            int startIdx = allEntities.size() - entities.size();
            int endIdx = allEntities.size();
            for (int j = startIdx; j < endIdx; ++j) {
                resultMapping.computeIfAbsent(j, k -> new ArrayList(2)).add(req.future);
            }
        }
        List<Long> results = RustPerformance.processEntitiesDirect(allEntities, allPlayers);
        HashSet<Long> resultSet = new HashSet<Long>(results);
        for (int i = 0; i < batch.size(); ++i) {
            BatchRequest req = batch.get(i);
            Map data = (Map)req.data;
            List entities = (List)data.get(ENTITIES_KEY);
            ArrayList<Long> requestResults = new ArrayList<Long>();
            for (EntityData entity : entities) {
                if (!resultSet.contains(entity.id())) continue;
                requestResults.add(entity.id());
            }
            req.future.complete(requestResults);
        }
    }

    private static void processItemBatch(List<BatchRequest> batch) {
        if (batch.isEmpty()) {
            return;
        }
        ArrayList<ItemEntityData> allItems = new ArrayList<ItemEntityData>();
        for (BatchRequest req : batch) {
            List items = (List)req.data;
            allItems.addAll(items);
        }
        ItemProcessResult result = RustPerformance.processItemEntitiesDirect(allItems);
        for (BatchRequest req : batch) {
            req.future.complete(result);
        }
    }

    private static void processMobBatch(List<BatchRequest> batch) {
        if (batch.isEmpty()) {
            return;
        }
        ArrayList<MobData> allMobs = new ArrayList<MobData>();
        for (BatchRequest req : batch) {
            List mobs = (List)req.data;
            allMobs.addAll(mobs);
        }
        MobProcessResult result = RustPerformance.processMobAIDirect(allMobs);
        for (BatchRequest req : batch) {
            req.future.complete(result);
        }
    }

    private static void processBlockBatch(List<BatchRequest> batch) {
        if (batch.isEmpty()) {
            return;
        }
        ArrayList<BlockEntityData> allBlocks = new ArrayList<BlockEntityData>();
        for (BatchRequest req : batch) {
            List blocks = (List)req.data;
            allBlocks.addAll(blocks);
        }
        List<Long> results = RustPerformance.getBlockEntitiesToTickDirect(allBlocks);
        for (BatchRequest req : batch) {
            req.future.complete(results);
        }
    }

    private static Object processIndividualRequest() {
        return null;
    }

    private static <T> T submitBatchRequest(String type, Object data) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        BatchRequest request = new BatchRequest(type, data, future);
        pendingRequests.offer(request);
        if (!batchProcessorRunning) {
            RustPerformance.startBatchProcessor();
        }
        try {
            Object result = future.get(5L, TimeUnit.SECONDS);
            return (T)result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw AsyncProcessingException.batchRequestInterrupted(type, e);
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Batch request timeout or error for type: {}", (Object)type, (Object)e);
            return RustPerformance.processRequestDirect(type, data);
        }
    }

    private static <T, R> R processWithBinaryFallback(T input, final BinarySerializer<T, R> binarySerializer, final BinaryNativeCaller binaryNativeCaller, final BinaryDeserializer<R> binaryDeserializer, final JsonInputPreparer<T> jsonInputPreparer, final JsonNativeCaller jsonNativeCaller, final JsonResultParser<R> jsonResultParser, final R fallbackResult, String operationName) {
        ProtocolProcessor.ProtocolResult<R> result = protocolProcessor.processWithFallback(input, operationName, new ProtocolProcessor.BinarySerializer<T>(){

            @Override
            public ByteBuffer serialize(T binaryInput) throws Exception {
                return binarySerializer.serialize(binaryInput);
            }
        }, new ProtocolProcessor.BinaryNativeCaller<byte[]>(){

            @Override
            public byte[] callNative(ByteBuffer inputBuffer) throws Exception {
                return binaryNativeCaller.callNative(inputBuffer);
            }
        }, new ProtocolProcessor.BinaryDeserializer<R>(){

            @Override
            public R deserialize(byte[] resultBytes) throws Exception {
                if (resultBytes != null) {
                    return binaryDeserializer.deserialize(resultBytes);
                }
                return fallbackResult;
            }
        }, new ProtocolProcessor.JsonInputPreparer<T>(){

            @Override
            public Map<String, Object> prepareInput(T jsonInput) {
                return jsonInputPreparer.prepareInput(jsonInput);
            }
        }, new ProtocolProcessor.JsonNativeCaller<String>(){

            @Override
            public String callNative(String jsonInput) throws Exception {
                return jsonNativeCaller.callNative(jsonInput);
            }
        }, new ProtocolProcessor.JsonResultParser<R>(){

            @Override
            public R parseResult(String jsonResult) throws Exception {
                return jsonResultParser.parseResult(jsonResult);
            }
        }, fallbackResult);
        return result.getDataOrThrow();
    }

    private static List<Long> processEntitiesDirect(List<EntityData> entities, List<PlayerData> players) {
        return RustPerformance.processWithBinaryFallback(new EntityInput(entities, players), input -> ManualSerializers.serializeEntityInput(tickCount++, input.entities, input.players), inputBuffer -> RustPerformance.processEntitiesBinaryNative(inputBuffer), resultBytes -> {
            try {
                ByteBuffer resultBuffer = ByteBuffer.wrap(resultBytes).order(ByteOrder.LITTLE_ENDIAN);
                List<Long> resultList = ManualSerializers.deserializeEntityProcessResult(resultBuffer);
                totalEntitiesProcessed += (long)resultList.size();
                return resultList;
            }
            catch (Throwable primaryEx) {
                try {
                    if (resultBytes == null) {
                        throw primaryEx;
                    }
                    int len = resultBytes.length;
                    ByteBuffer altBuf = ByteBuffer.wrap(resultBytes).order(ByteOrder.LITTLE_ENDIAN);
                    if (len >= 12) {
                        long maybeTick = altBuf.getLong(0);
                        int numItems = altBuf.getInt(8);
                        if (numItems >= 0 && numItems <= 1000000 && 12 + numItems * 8 <= len) {
                            ArrayList<Long> altList = new ArrayList<Long>(numItems);
                            for (int i = 0; i < numItems; ++i) {
                                long id = altBuf.getLong(12 + i * 8);
                                altList.add(id);
                            }
                            KneafCore.LOGGER.warn("Entity binary parser primary format failed ({}); used tickCount-prefixed fallback: tick={} numItems={} result_len={}", new Object[]{primaryEx.getMessage(), maybeTick, numItems, len});
                            totalEntitiesProcessed += (long)altList.size();
                            return altList;
                        }
                    }
                }
                catch (Throwable altEx) {
                    try {
                        String prefix = RustPerformance.bytesPrefixHex(resultBytes, 128);
                        KneafCore.LOGGER.error("Entity binary deserialization failed (primary: {}; fallback: {}); result_len={} ; prefix={}", new Object[]{primaryEx.getMessage(), altEx.getMessage(), resultBytes == null ? 0 : resultBytes.length, prefix, primaryEx});
                    }
                    catch (Throwable t2) {
                        KneafCore.LOGGER.error("Entity binary deserialization failed and prefix computation also failed: {}", (Object)t2.getMessage(), (Object)t2);
                    }
                }
                throw primaryEx;
            }
        }, input -> {
            HashMap<String, Object> jsonInput = new HashMap<String, Object>();
            jsonInput.put(TICK_COUNT_KEY, tickCount++);
            jsonInput.put(ENTITIES_KEY, input.entities);
            jsonInput.put(PLAYERS_KEY, input.players);
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("closeRadius", Float.valueOf(16.0f));
            config.put("mediumRadius", Float.valueOf(32.0f));
            config.put("closeRate", Float.valueOf(1.0f));
            config.put("mediumRate", Float.valueOf(0.5f));
            config.put("farRate", Float.valueOf(0.1f));
            config.put("useSpatialPartitioning", true);
            HashMap<String, Double> worldBounds = new HashMap<String, Double>();
            worldBounds.put("minX", -1000.0);
            worldBounds.put("minY", 0.0);
            worldBounds.put("minZ", -1000.0);
            worldBounds.put("maxX", 1000.0);
            worldBounds.put("maxY", 256.0);
            worldBounds.put("maxZ", 1000.0);
            config.put("worldBounds", worldBounds);
            config.put("quadtreeMaxEntities", 1000);
            config.put("quadtreeMaxDepth", 10);
            jsonInput.put("entityConfig", config);
            return jsonInput;
        }, jsonInput -> {
            try {
                String result = RustPerformance.processEntitiesNative(jsonInput);
                if (result == null) {
                    KneafCore.LOGGER.error("processEntitiesNative returned null for JSON input");
                    return "{\"error\":\"Native method returned null\"}";
                }
                if (result.isEmpty()) {
                    KneafCore.LOGGER.error("processEntitiesNative returned empty string");
                    return "{\"error\":\"Native method returned empty string\"}";
                }
                if (!result.trim().startsWith("{") || !result.trim().endsWith("}")) {
                    KneafCore.LOGGER.error("processEntitiesNative returned invalid JSON format: {}", (Object)result.substring(0, Math.min(result.length(), 100)));
                    return "{\"error\":\"Native method returned invalid JSON format\"}";
                }
                return result;
            }
            catch (Exception e) {
                KneafCore.LOGGER.error("Exception in processEntitiesNative: {}", (Object)e.getMessage(), (Object)e);
                return "{\"error\":\"" + e.getMessage() + "\"}";
            }
        }, jsonResult -> {
            try {
                JsonObject result = (JsonObject)gson.fromJson(jsonResult, JsonObject.class);
                if (result == null) {
                    KneafCore.LOGGER.error("Failed to parse JSON result: null result object");
                    return new ArrayList();
                }
                if (result.has("error")) {
                    String error = result.get("error").getAsString();
                    KneafCore.LOGGER.error("Rust processing returned error: {}", (Object)error);
                    return new ArrayList();
                }
                if (!result.has("entitiesToTick")) {
                    KneafCore.LOGGER.error("JSON result missing 'entitiesToTick' field");
                    return new ArrayList();
                }
                JsonElement entitiesElement = result.get("entitiesToTick");
                if (entitiesElement == null || !entitiesElement.isJsonArray()) {
                    KneafCore.LOGGER.error("entitiesToTick is null or not an array");
                    return new ArrayList();
                }
                JsonArray entitiesToTick = entitiesElement.getAsJsonArray();
                ArrayList<Long> resultList = new ArrayList<Long>();
                for (JsonElement e : entitiesToTick) {
                    if (e == null || !e.isJsonPrimitive()) continue;
                    try {
                        resultList.add(e.getAsLong());
                    }
                    catch (NumberFormatException nfe) {
                        KneafCore.LOGGER.error("Invalid entity ID in result: {}", (Object)e);
                    }
                }
                totalEntitiesProcessed += (long)resultList.size();
                return resultList;
            }
            catch (Exception e) {
                KneafCore.LOGGER.error("Error parsing JSON result: {}", (Object)jsonResult, (Object)e);
                return new ArrayList();
            }
        }, new ArrayList(), "Entity processing");
    }

    private static ItemProcessResult processItemEntitiesDirect(List<ItemEntityData> items) {
        return RustPerformance.processWithBinaryFallback(items, input -> ManualSerializers.serializeItemInput(tickCount, input), inputBuffer -> RustPerformance.processItemEntitiesBinaryNative(inputBuffer), resultBytes -> {
            ByteBuffer resultBuffer = ByteBuffer.wrap(resultBytes);
            List<ItemEntityData> updatedItems = ManualSerializers.deserializeItemProcessResult(resultBuffer);
            ArrayList<Long> removeList = new ArrayList<Long>();
            ArrayList<ItemUpdate> updates = new ArrayList<ItemUpdate>();
            for (ItemEntityData item : updatedItems) {
                if (item.count() == 0) {
                    removeList.add(item.id());
                    continue;
                }
                updates.add(new ItemUpdate(item.id(), item.count()));
            }
            totalMerged += (long)updates.size();
            totalDespawned += (long)removeList.size();
            return new ItemProcessResult(removeList, updates.size(), removeList.size(), updates);
        }, input -> {
            HashMap<String, List> jsonInput = new HashMap<String, List>();
            jsonInput.put(ITEMS_KEY, (List)input);
            return jsonInput;
        }, jsonInput -> {
            try {
                return RustPerformance.processItemEntitiesNative(jsonInput);
            }
            catch (Exception e) {
                return null;
            }
        }, jsonResult -> {
            JsonObject result = (JsonObject)gson.fromJson(jsonResult, JsonObject.class);
            JsonArray itemsToRemove = result.getAsJsonArray("items_to_remove");
            ArrayList<Long> removeList = new ArrayList<Long>();
            for (JsonElement e : itemsToRemove) {
                removeList.add(e.getAsLong());
            }
            long merged = result.get("merged_count").getAsLong();
            long despawned = result.get("despawned_count").getAsLong();
            JsonArray itemUpdatesArray = result.getAsJsonArray("item_updates");
            ArrayList<ItemUpdate> updates = new ArrayList<ItemUpdate>();
            for (JsonElement e : itemUpdatesArray) {
                JsonObject obj = e.getAsJsonObject();
                long id = obj.get("id").getAsLong();
                int newCount = obj.get("new_count").getAsInt();
                updates.add(new ItemUpdate(id, newCount));
            }
            totalMerged += merged;
            totalDespawned += despawned;
            return new ItemProcessResult(removeList, merged, despawned, updates);
        }, new ItemProcessResult(new ArrayList<Long>(), 0L, 0L, new ArrayList<ItemUpdate>()), "Item entity processing");
    }

    private static ItemProcessResult processItemEntitiesBinary(List<ItemEntityData> items) {
        try {
            ByteBuffer inputBuffer = ManualSerializers.serializeItemInput(tickCount, items);
            byte[] resultBytes = RustPerformance.processItemEntitiesBinaryNative(inputBuffer);
            if (resultBytes != null) {
                ByteBuffer resultBuffer = ByteBuffer.wrap(resultBytes);
                List<ItemEntityData> updatedItems = ManualSerializers.deserializeItemProcessResult(resultBuffer);
                ArrayList<Long> removeList = new ArrayList<Long>();
                ArrayList<ItemUpdate> updates = new ArrayList<ItemUpdate>();
                for (ItemEntityData item : updatedItems) {
                    if (item.count() == 0) {
                        removeList.add(item.id());
                        continue;
                    }
                    updates.add(new ItemUpdate(item.id(), item.count()));
                }
                totalMerged += (long)updates.size();
                totalDespawned += (long)removeList.size();
                return new ItemProcessResult(removeList, updates.size(), removeList.size(), updates);
            }
        }
        catch (Exception binaryEx) {
            KneafCore.LOGGER.debug(BINARY_FALLBACK_MESSAGE, (Object)binaryEx.getMessage());
        }
        return null;
    }

    private static ItemProcessResult processItemEntitiesJson(List<ItemEntityData> items) {
        HashMap<String, List<ItemEntityData>> input = new HashMap<String, List<ItemEntityData>>();
        input.put(ITEMS_KEY, items);
        String jsonInput = gson.toJson(input);
        String jsonResult = null;
        if (jsonResult != null) {
            JsonObject result = (JsonObject)gson.fromJson(jsonResult, JsonObject.class);
            JsonArray itemsToRemove = result.getAsJsonArray("items_to_remove");
            ArrayList<Long> removeList = new ArrayList<Long>();
            for (JsonElement e : itemsToRemove) {
                removeList.add(e.getAsLong());
            }
            long merged = result.get("merged_count").getAsLong();
            long despawned = result.get("despawned_count").getAsLong();
            JsonArray itemUpdatesArray = result.getAsJsonArray("item_updates");
            ArrayList<ItemUpdate> updates = new ArrayList<ItemUpdate>();
            for (JsonElement e : itemUpdatesArray) {
                JsonObject obj = e.getAsJsonObject();
                long id = obj.get("id").getAsLong();
                int newCount = obj.get("new_count").getAsInt();
                updates.add(new ItemUpdate(id, newCount));
            }
            totalMerged += merged;
            totalDespawned += despawned;
            return new ItemProcessResult(removeList, merged, despawned, updates);
        }
        return null;
    }

    private static MobProcessResult processMobAIDirect(List<MobData> mobs) {
        return RustPerformance.processWithBinaryFallback(mobs, input -> ManualSerializers.serializeMobInput(tickCount, input), inputBuffer -> RustPerformance.processMobAiBinaryNative(inputBuffer), resultBytes -> {
            ByteBuffer resultBuffer = ByteBuffer.wrap(resultBytes);
            List<MobData> updatedMobs = ManualSerializers.deserializeMobProcessResult(resultBuffer);
            ArrayList<Long> simplifyList = new ArrayList<Long>();
            for (MobData mob : updatedMobs) {
                simplifyList.add(mob.id());
            }
            totalMobsProcessed += (long)mobs.size();
            return new MobProcessResult(new ArrayList<Long>(), simplifyList);
        }, input -> {
            HashMap<String, Object> jsonInput = new HashMap<String, Object>();
            jsonInput.put(TICK_COUNT_KEY, tickCount);
            jsonInput.put(MOBS_KEY, input);
            return jsonInput;
        }, jsonInput -> {
            try {
                return RustPerformance.processMobAiNative(jsonInput);
            }
            catch (Exception e) {
                return null;
            }
        }, jsonResult -> {
            JsonObject result = (JsonObject)gson.fromJson(jsonResult, JsonObject.class);
            JsonArray disableAi = result.getAsJsonArray("mobs_to_disable_ai");
            JsonArray simplifyAi = result.getAsJsonArray("mobs_to_simplify_ai");
            ArrayList<Long> disableList = new ArrayList<Long>();
            ArrayList<Long> simplifyList = new ArrayList<Long>();
            for (JsonElement e : disableAi) {
                disableList.add(e.getAsLong());
            }
            for (JsonElement e : simplifyAi) {
                simplifyList.add(e.getAsLong());
            }
            totalMobsProcessed += (long)mobs.size();
            return new MobProcessResult(disableList, simplifyList);
        }, new MobProcessResult(new ArrayList<Long>(), new ArrayList<Long>()), "Mob AI processing");
    }

    private static List<Long> getBlockEntitiesToTickDirect(List<BlockEntityData> blockEntities) {
        String jsonResult;
        if (nativeAvailable) {
            try {
                ByteBuffer inputBuffer = ManualSerializers.serializeBlockInput(tickCount++, blockEntities);
                byte[] resultBytes = RustPerformance.processBlockEntitiesBinaryNative(inputBuffer);
                if (resultBytes != null) {
                    ArrayList<Long> resultList = new ArrayList<Long>();
                    for (BlockEntityData block : blockEntities) {
                        resultList.add(block.id());
                    }
                    totalBlocksProcessed += (long)resultList.size();
                    return resultList;
                }
            }
            catch (Exception binaryEx) {
                KneafCore.LOGGER.debug(BINARY_FALLBACK_MESSAGE, (Object)binaryEx.getMessage());
            }
        }
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put(TICK_COUNT_KEY, tickCount++);
        input.put("block_entities", blockEntities);
        String jsonInput = gson.toJson(input);
        try {
            jsonResult = RustPerformance.processBlockEntitiesNative(jsonInput);
        }
        catch (Exception e) {
            jsonResult = null;
        }
        if (jsonResult != null) {
            JsonObject result = (JsonObject)gson.fromJson(jsonResult, JsonObject.class);
            JsonArray entitiesToTick = result.getAsJsonArray("block_entities_to_tick");
            ArrayList<Long> resultList = new ArrayList<Long>();
            for (JsonElement e : entitiesToTick) {
                resultList.add(e.getAsLong());
            }
            totalBlocksProcessed += (long)resultList.size();
            return resultList;
        }
        ArrayList<Long> all = new ArrayList<Long>();
        for (BlockEntityData e : blockEntities) {
            all.add(e.id());
        }
        return all;
    }

    private static <T> T processRequestDirect(String type, Object data) {
        switch (type) {
            case "entities": {
                Map entityData = (Map)data;
                return (T)RustPerformance.processEntitiesDirect((List)entityData.get(ENTITIES_KEY), (List)entityData.get(PLAYERS_KEY));
            }
            case "items": {
                return (T)RustPerformance.processItemEntitiesDirect((List)data);
            }
            case "mobs": {
                return (T)RustPerformance.processMobAIDirect((List)data);
            }
            case "blocks": {
                return (T)RustPerformance.getBlockEntitiesToTickDirect((List)data);
            }
        }
        return null;
    }

    private static native String processEntitiesNative(String var0);

    private static native String processItemEntitiesNative(String var0);

    private static native String processMobAiNative(String var0);

    private static native String processBlockEntitiesNative(String var0);

    private static native byte[] processEntitiesBinaryNative(ByteBuffer var0);

    private static native byte[] processItemEntitiesBinaryNative(ByteBuffer var0);

    private static native byte[] processMobAiBinaryNative(ByteBuffer var0);

    private static native byte[] processBlockEntitiesBinaryNative(ByteBuffer var0);

    public static native String parallelSumNative(String var0);

    public static native String matrixMultiplyNative(String var0, String var1);

    public static native String getMemoryStatsNative();

    public static native String getCpuStatsNative();

    private static native int preGenerateNearbyChunksNative(int var0, int var1, int var2);

    private static native boolean isChunkGeneratedNative(int var0, int var1);

    private static native long getGeneratedChunkCountNative();

    public static native String blake3FromByteBuffer(ByteBuffer var0);

    public static native ByteBuffer generateFloatBufferNative(long var0, long var2);

    public static native void freeFloatBufferNative(ByteBuffer var0);

    public static native NativeFloatBufferAllocation generateFloatBufferWithShapeNative(long var0, long var2);

    public static native int nativeGetWorkerQueueDepth();

    public static native double nativeGetWorkerAvgProcessingMs();

    private static String bytesPrefixHex(byte[] data, int maxBytes) {
        if (data == null) {
            return "";
        }
        int len = Math.min(data.length, Math.max(0, maxBytes));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(String.format("%02x", data[i] & 0xFF));
            if (i >= len - 1) continue;
            sb.append(',');
        }
        if (data.length > len) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static List<Long> getEntitiesToTick(List<EntityData> entities, List<PlayerData> players) {
        return (List)RustPerformance.submitBatchRequest(ENTITIES_KEY, Map.of(ENTITIES_KEY, entities, PLAYERS_KEY, players, TICK_COUNT_KEY, tickCount++));
    }

    public static ItemProcessResult processItemEntities(List<ItemEntityData> items) {
        try {
            ItemProcessResult binaryResult;
            if (nativeAvailable && (binaryResult = RustPerformance.processItemEntitiesBinary(items)) != null) {
                return binaryResult;
            }
            ItemProcessResult jsonResult = RustPerformance.processItemEntitiesJson(items);
            if (jsonResult != null) {
                return jsonResult;
            }
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error calling Rust for item processing: {}", (Object)e.getMessage(), (Object)e);
        }
        return new ItemProcessResult(new ArrayList<Long>(), 0L, 0L, new ArrayList<ItemUpdate>());
    }

    public static MobProcessResult processMobAI(List<MobData> mobs) {
        try {
            MobProcessResult binaryResult;
            if (nativeAvailable && (binaryResult = RustPerformance.processMobAIBinary(mobs)) != null) {
                return binaryResult;
            }
            MobProcessResult jsonResult = RustPerformance.processMobAIJson(mobs);
            if (jsonResult != null) {
                return jsonResult;
            }
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error calling Rust for mob AI processing: {}", (Object)e.getMessage(), (Object)e);
        }
        return new MobProcessResult(new ArrayList<Long>(), new ArrayList<Long>());
    }

    private static MobProcessResult processMobAIBinary(List<MobData> mobs) {
        try {
            ByteBuffer inputBuffer = ManualSerializers.serializeMobInput(tickCount, mobs);
            byte[] resultBytes = RustPerformance.processMobAiBinaryNative(inputBuffer);
            if (resultBytes != null) {
                ByteBuffer resultBuffer = ByteBuffer.wrap(resultBytes).order(ByteOrder.LITTLE_ENDIAN);
                List<MobData> updatedMobs = ManualSerializers.deserializeMobProcessResult(resultBuffer);
                ArrayList<Long> simplifyList = new ArrayList<Long>();
                for (MobData mob : updatedMobs) {
                    simplifyList.add(mob.id());
                }
                totalMobsProcessed += (long)mobs.size();
                return new MobProcessResult(new ArrayList<Long>(), simplifyList);
            }
        }
        catch (Exception binaryEx) {
            KneafCore.LOGGER.debug(BINARY_FALLBACK_MESSAGE, (Object)binaryEx.getMessage());
        }
        return null;
    }

    private static MobProcessResult processMobAIJson(List<MobData> mobs) {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put(TICK_COUNT_KEY, tickCount);
        input.put(MOBS_KEY, mobs);
        String jsonInput = gson.toJson(input);
        String jsonResult = null;
        if (jsonResult != null) {
            JsonObject result = (JsonObject)gson.fromJson(jsonResult, JsonObject.class);
            JsonArray disableAi = result.getAsJsonArray("mobs_to_disable_ai");
            JsonArray simplifyAi = result.getAsJsonArray("mobs_to_simplify_ai");
            ArrayList<Long> disableList = new ArrayList<Long>();
            ArrayList<Long> simplifyList = new ArrayList<Long>();
            for (JsonElement e : disableAi) {
                disableList.add(e.getAsLong());
            }
            for (JsonElement e : simplifyAi) {
                simplifyList.add(e.getAsLong());
            }
            totalMobsProcessed += (long)mobs.size();
            return new MobProcessResult(disableList, simplifyList);
        }
        return null;
    }

    public static List<Long> getBlockEntitiesToTick(List<BlockEntityData> blockEntities) {
        try {
            List<Long> binaryResult;
            if (nativeAvailable && !(binaryResult = RustPerformance.getBlockEntitiesToTickBinary(blockEntities)).isEmpty()) {
                return binaryResult;
            }
            List<Long> jsonResult = RustPerformance.getBlockEntitiesToTickJson(blockEntities);
            if (!jsonResult.isEmpty()) {
                return jsonResult;
            }
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error calling Rust for block entity processing: {}", (Object)e.getMessage(), (Object)e);
        }
        ArrayList<Long> all = new ArrayList<Long>();
        for (BlockEntityData e : blockEntities) {
            all.add(e.id());
        }
        return all;
    }

    private static List<Long> getBlockEntitiesToTickBinary(List<BlockEntityData> blockEntities) {
        try {
            ByteBuffer inputBuffer = ManualSerializers.serializeBlockInput(tickCount++, blockEntities);
            byte[] resultBytes = RustPerformance.processBlockEntitiesBinaryNative(inputBuffer);
            if (resultBytes != null) {
                ByteBuffer resultBuffer = ByteBuffer.wrap(resultBytes);
                ArrayList<Long> resultList = new ArrayList<Long>();
                for (BlockEntityData block : blockEntities) {
                    resultList.add(block.id());
                }
                totalBlocksProcessed += (long)resultList.size();
                return resultList;
            }
        }
        catch (Exception binaryEx) {
            KneafCore.LOGGER.debug(BINARY_FALLBACK_MESSAGE, (Object)binaryEx.getMessage());
        }
        return new ArrayList<Long>();
    }

    private static List<Long> getBlockEntitiesToTickJson(List<BlockEntityData> blockEntities) {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put(TICK_COUNT_KEY, tickCount++);
        input.put("block_entities", blockEntities);
        String jsonInput = gson.toJson(input);
        String jsonResult = null;
        if (jsonResult != null) {
            JsonObject result = (JsonObject)gson.fromJson(jsonResult, JsonObject.class);
            JsonArray entitiesToTick = result.getAsJsonArray("block_entities_to_tick");
            ArrayList<Long> resultList = new ArrayList<Long>();
            for (JsonElement e : entitiesToTick) {
                resultList.add(e.getAsLong());
            }
            totalBlocksProcessed += (long)resultList.size();
            return resultList;
        }
        return new ArrayList<Long>();
    }

    public static String getMemoryStats() {
        try {
            RustPerformance.ensureNativeAvailable();
            return RustPerformance.getMemoryStatsNative();
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error getting memory stats from Rust: {}", (Object)e.getMessage(), (Object)e);
            return "{\"error\": \"Failed to get memory stats\"}";
        }
    }

    public static String getCpuStats() {
        try {
            RustPerformance.ensureNativeAvailable();
            return RustPerformance.getCpuStatsNative();
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error getting CPU stats from Rust: {}", (Object)e.getMessage(), (Object)e);
            return "{\"error\": \"Failed to get CPU stats\"}";
        }
    }

    public static CompletableFuture<Integer> preGenerateNearbyChunksAsync(int centerX, int centerZ, int radius) {
        return asyncProcessor.supplyAsync(() -> RustPerformance.preGenerateNearbyChunks(centerX, centerZ, radius), 30000L, "preGenerateNearbyChunks");
    }

    public static void startValenceServer() {
        KneafCore.LOGGER.info("Valence integration has been removed");
    }

    public static int preGenerateNearbyChunks(int centerX, int centerZ, int radius) {
        try {
            return RustPerformance.preGenerateNearbyChunksNative(centerX, centerZ, radius);
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error calling Rust for chunk generation: {}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }

    public static boolean isChunkGenerated(int x, int z) {
        try {
            return RustPerformance.isChunkGeneratedNative(x, z);
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error calling Rust for chunk check: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public static long getGeneratedChunkCount() {
        try {
            return RustPerformance.getGeneratedChunkCountNative();
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error calling Rust for chunk count: {}", (Object)e.getMessage(), (Object)e);
            return 0L;
        }
    }

    public static double getCurrentTPS() {
        return currentTPS;
    }

    public static long getTotalEntitiesProcessed() {
        return totalEntitiesProcessed;
    }

    public static long getTotalMobsProcessed() {
        return totalMobsProcessed;
    }

    public static long getTotalBlocksProcessed() {
        return totalBlocksProcessed;
    }

    public static long getTotalMerged() {
        return totalMerged;
    }

    public static long getTotalDespawned() {
        return totalDespawned;
    }

    static {
        block11: {
            AsyncProcessor.AsyncConfig config = new AsyncProcessor.AsyncConfig();
            config.processorName("RustPerformance").enableLogging(true).enableMetrics(true);
            asyncProcessor = AsyncProcessor.create(config);
            pendingRequests = new ConcurrentLinkedQueue();
            batchProcessorRunning = false;
            batchLock = new Object();
            connectionPool = new ConcurrentLinkedQueue();
            connectionPoolInitialized = false;
            tickCount = 0L;
            currentTPS = 20.0;
            totalEntitiesProcessed = 0L;
            totalMobsProcessed = 0L;
            totalBlocksProcessed = 0L;
            totalMerged = 0L;
            totalDespawned = 0L;
            gson = new Gson();
            nativeAvailable = false;
            try {
                if (NativeLibraryLoader.loadNativeLibrary()) {
                    nativeAvailable = true;
                    KneafCore.LOGGER.info("Successfully loaded rustperf native library");
                } else {
                    nativeAvailable = false;
                    KneafCore.LOGGER.info("rustperf native library not loaded via NativeLibraryLoader");
                }
            }
            catch (Exception e) {
                KneafCore.LOGGER.warn("Unexpected error loading rustperf native library: {}", (Object)e.getMessage());
                nativeAvailable = false;
            }
            catch (Throwable t) {
                KneafCore.LOGGER.warn("Critical error loading rustperf native library: {}", (Object)t.getMessage());
                nativeAvailable = false;
            }
            KneafCore.LOGGER.info("Initializing RustPerformance native library - secondary initializer");
            if (!nativeAvailable) {
                try {
                    if (NativeLibraryLoader.loadNativeLibrary()) {
                        nativeAvailable = true;
                        KneafCore.LOGGER.info("Successfully loaded rustperf native library via secondary initializer");
                        break block11;
                    }
                    KneafCore.LOGGER.warn("Native library not available via secondary initializer");
                    nativeAvailable = false;
                }
                catch (Exception e) {
                    KneafCore.LOGGER.warn("Failed to initialize Rust native library in secondary initializer: {}. Native optimizations disabled.", (Object)e.getMessage());
                    nativeAvailable = false;
                }
                catch (Throwable t) {
                    KneafCore.LOGGER.warn("Critical error in secondary initializer: {}. Native optimizations disabled.", (Object)t.getMessage());
                    nativeAvailable = false;
                }
            } else {
                KneafCore.LOGGER.info("Native library already loaded, skipping secondary initialization");
            }
        }
        nativeErrRedirectInstalled = false;
        protocolProcessor = ProtocolProcessor.createAuto(nativeAvailable);
    }

    private static class BatchRequest {
        final String type;
        final Object data;
        final CompletableFuture<Object> future;

        BatchRequest(String type, Object data, CompletableFuture<Object> future) {
            this.type = type;
            this.data = data;
            this.future = future;
        }
    }

    public static class ItemProcessResult {
        private List<Long> itemsToRemove;
        private long mergedCount;
        private long despawnedCount;
        private List<ItemUpdate> itemUpdates;

        public ItemProcessResult(List<Long> itemsToRemove, long mergedCount, long despawnedCount, List<ItemUpdate> itemUpdates) {
            this.itemsToRemove = itemsToRemove;
            this.mergedCount = mergedCount;
            this.despawnedCount = despawnedCount;
            this.itemUpdates = itemUpdates;
        }

        public List<Long> getItemsToRemove() {
            return this.itemsToRemove;
        }

        public long getMergedCount() {
            return this.mergedCount;
        }

        public long getDespawnedCount() {
            return this.despawnedCount;
        }

        public List<ItemUpdate> getItemUpdates() {
            return this.itemUpdates;
        }
    }

    public static class MobProcessResult {
        private List<Long> mobsToDisableAI;
        private List<Long> mobsToSimplifyAI;

        public MobProcessResult(List<Long> mobsToDisableAI, List<Long> mobsToSimplifyAI) {
            this.mobsToDisableAI = mobsToDisableAI;
            this.mobsToSimplifyAI = mobsToSimplifyAI;
        }

        public List<Long> getMobsToDisableAI() {
            return this.mobsToDisableAI;
        }

        public List<Long> getMobsToSimplifyAI() {
            return this.mobsToSimplifyAI;
        }
    }

    @FunctionalInterface
    private static interface BinarySerializer<T, R> {
        public ByteBuffer serialize(T var1) throws Exception;
    }

    @FunctionalInterface
    private static interface BinaryNativeCaller {
        public byte[] callNative(ByteBuffer var1) throws Exception;
    }

    @FunctionalInterface
    private static interface BinaryDeserializer<R> {
        public R deserialize(byte[] var1) throws Exception;
    }

    @FunctionalInterface
    private static interface JsonInputPreparer<T> {
        public Map<String, Object> prepareInput(T var1);
    }

    @FunctionalInterface
    private static interface JsonNativeCaller {
        public String callNative(String var1);
    }

    @FunctionalInterface
    private static interface JsonResultParser<R> {
        public R parseResult(String var1);
    }

    private static class EntityInput {
        final List<EntityData> entities;
        final List<PlayerData> players;

        EntityInput(List<EntityData> entities, List<PlayerData> players) {
            this.entities = entities;
            this.players = players;
        }
    }

    public static class ItemUpdate {
        private long id;
        private int newCount;

        public ItemUpdate(long id, int newCount) {
            this.id = id;
            this.newCount = newCount;
        }

        public long getId() {
            return this.id;
        }

        public int getNewCount() {
            return this.newCount;
        }
    }
}

