/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class TaskEnvelope {
    public long taskId;
    public byte taskType;
    public byte[] payload;
    public static final byte TYPE_ECHO = 1;
    public static final byte TYPE_HEAVY = 2;
    public static final byte TYPE_ITEM_OPTIMIZE = 3;
    public static final byte TYPE_PANIC_TEST = -1;

    public TaskEnvelope() {
    }

    public TaskEnvelope(long taskId, byte taskType, byte[] payload) {
        this.taskId = taskId;
        this.taskType = taskType;
        this.payload = payload;
    }

    public byte[] toBytes() {
        int payloadLen = this.payload == null ? 0 : this.payload.length;
        ByteBuffer bb = ByteBuffer.allocate(13 + payloadLen).order(ByteOrder.LITTLE_ENDIAN);
        bb.putLong(this.taskId);
        bb.put(this.taskType);
        bb.putInt(payloadLen);
        if (payloadLen > 0) {
            bb.put(this.payload);
        }
        return bb.array();
    }

    public static TaskEnvelope fromBytes(byte[] b) {
        if (b == null || b.length < 13) {
            throw new IllegalArgumentException("invalid envelope");
        }
        ByteBuffer bb = ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN);
        long id = bb.getLong();
        byte t = bb.get();
        int len = bb.getInt();
        if (len < 0 || bb.remaining() < len) {
            throw new IllegalArgumentException("invalid payload length");
        }
        byte[] p = new byte[len];
        if (len > 0) {
            bb.get(p);
        }
        return new TaskEnvelope(id, t, p);
    }
}

