/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core;

import com.kneaf.core.Config;
import com.kneaf.core.client.PerformanceOverlayClient;
import com.kneaf.core.command.PerformanceCommand;
import com.kneaf.core.compatibility.ModCompatibility;
import com.kneaf.core.performance.RustPerformance;
import com.kneaf.core.performance.integration.NeoForgeEventIntegration;
import com.kneaf.core.performance.monitoring.PerformanceManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="kneafcore")
public class KneafCore {
    public static final String MODID = "kneafcore";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"kneafcore");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"kneafcore");

    public KneafCore(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register(NeoForgeEventIntegration.class);
        LOGGER.info("Commands listener will be registered via @SubscribeEvent on class registration");
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        LOGGER.info("{ }{ }", Config.MAGIC_NUMBER_INTRODUCTION.get(), (Object)Config.MAGIC_NUMBER.getAsInt());
        ((List)Config.ITEM_STRINGS.get()).forEach(item -> LOGGER.info("ITEM >> { }", item));
        ModCompatibility.checkForConflicts();
        this.initializeRustPerformanceSystem();
    }

    private void initializeRustPerformanceSystem() {
        try {
            boolean useUltraPerformance = Files.exists(Paths.get("config/kneaf-performance-ultra.properties", new String[0]), new LinkOption[0]);
            if (useUltraPerformance) {
                RustPerformance.initializeUltraPerformance();
                String optimizationsActive = "Ultra-performance mode: Dynamic entity ticking, Item stack merging, Mob AI optimization, Chunk generation optimization, Aggressive SIMD, Lock-free pooling";
                String cpuInfo = "Ultra-performance: SIMD-optimized processing with AVX2/AVX-512 support, Aggressive inlining, Loop unrolling";
                String configApplied = "Ultra-performance optimizations enabled with safety checks disabled for maximum speed";
                RustPerformance.logStartupInfo(optimizationsActive, cpuInfo, configApplied);
                LOGGER.info("Rust performance system initialized with ULTRA-PERFORMANCE configuration");
            } else {
                RustPerformance.initialize();
                String optimizationsActive = "Dynamic entity ticking, Item stack merging, Mob AI optimization, Chunk generation optimization";
                String cpuInfo = "SIMD-optimized processing with AVX2/AVX-512 support";
                String configApplied = "Performance optimizations enabled with safety checks";
                RustPerformance.logStartupInfo(optimizationsActive, cpuInfo, configApplied);
                LOGGER.info("Rust performance system initialized with enhanced logging");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize Rust performance system", (Throwable)e);
        }
    }

    @SubscribeEvent
    private void registerCommands(RegisterCommandsEvent event) {
        PerformanceCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        PerformanceManager.onServerTick(event.getServer());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("Server stopping - shutting down PerformanceManager");
        try {
            PerformanceManager.shutdown();
        }
        catch (Exception e) {
            LOGGER.warn("Error while shutting down PerformanceManager", (Throwable)e);
        }
    }

    @EventBusSubscriber(modid="kneafcore", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    static class ClientModEvents {
        private ClientModEvents() {
        }

        @SubscribeEvent
        static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> { }", (Object)Minecraft.getInstance().getUser().getName());
            try {
                PerformanceOverlayClient.registerClient(event);
            }
            catch (Throwable t) {
                LOGGER.debug("Performance overlay registration failed: { }", (Object)t.getMessage());
            }
        }
    }
}

