/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.binary.item;

import com.kneaf.core.binary.core.BaseBinarySerializer;
import com.kneaf.core.binary.core.SerializationUtils;
import com.kneaf.core.binary.item.ItemInput;
import com.kneaf.core.binary.utils.BufferPool;
import com.kneaf.core.binary.utils.SchemaValidator;
import com.kneaf.core.binary.utils.SerializationException;
import com.kneaf.core.data.item.ItemEntityData;
import com.kneaf.core.performance.core.ItemProcessResult;
import com.kneaf.core.performance.core.PerformanceProcessor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ItemSerializer
extends BaseBinarySerializer<ItemInput, ItemProcessResult> {
    public ItemSerializer() {
        super("item", "1.0.0");
    }

    public ItemSerializer(BufferPool bufferPool) {
        super("item", "1.0.0", bufferPool);
    }

    public ItemSerializer(BufferPool bufferPool, SchemaValidator<ItemInput> validator) {
        super("item", "1.0.0", bufferPool, validator);
    }

    @Override
    protected void serializeToBufferInternal(ItemInput input, ByteBuffer buffer) throws SerializationException {
        if (input == null) {
            throw new SerializationException("Item input cannot be null", this.getSerializerType(), "serializeToBufferInternal");
        }
        try {
            buffer.putLong(input.tickCount);
            List<ItemEntityData> items = input.items;
            buffer.putInt(items.size());
            for (ItemEntityData item : items) {
                this.writeItemData(buffer, item);
            }
        }
        catch (Exception e) {
            throw new SerializationException("Failed to serialize item input", e, this.getSerializerType(), "serializeToBufferInternal", buffer.array());
        }
    }

    @Override
    protected ItemProcessResult deserializeFromBufferInternal(ByteBuffer buffer) throws SerializationException {
        try {
            buffer.getLong();
            int itemCount = buffer.getInt();
            if (itemCount < 0) {
                throw new SerializationException("Invalid item count: " + itemCount, this.getSerializerType(), "deserializeFromBufferInternal");
            }
            ArrayList<ItemEntityData> resultItems = new ArrayList<ItemEntityData>(itemCount);
            for (int i = 0; i < itemCount; ++i) {
                resultItems.add(this.readItemData(buffer));
            }
            ArrayList<Long> itemsToRemove = new ArrayList<Long>();
            ArrayList<PerformanceProcessor.ItemUpdate> itemUpdates = new ArrayList<PerformanceProcessor.ItemUpdate>();
            for (ItemEntityData item : resultItems) {
                if (item.getCount() == 0) {
                    itemsToRemove.add(item.getId());
                    continue;
                }
                itemUpdates.add(new PerformanceProcessor.ItemUpdate(item.getId(), item.getCount()));
            }
            long mergedCount = buffer.getLong();
            long despawnedCount = buffer.getLong();
            return new ItemProcessResult(itemsToRemove, (int)mergedCount, (int)despawnedCount, itemUpdates);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("Failed to deserialize item result", e, this.getSerializerType(), "deserializeFromBufferInternal", null);
        }
    }

    private void writeItemData(ByteBuffer buffer, ItemEntityData item) {
        buffer.putLong(item.getId());
        buffer.putInt(item.getChunkX());
        buffer.putInt(item.getChunkZ());
        SerializationUtils.writeString(buffer, item.getItemType());
        buffer.putInt(item.getCount());
        buffer.putInt(item.getAgeSeconds());
    }

    private ItemEntityData readItemData(ByteBuffer buffer) {
        long id = buffer.getLong();
        int chunkX = buffer.getInt();
        int chunkZ = buffer.getInt();
        String itemType = SerializationUtils.readString(buffer);
        int count = buffer.getInt();
        int ageSeconds = buffer.getInt();
        return new ItemEntityData(id, chunkX, chunkZ, itemType, count, ageSeconds);
    }
}

