/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage.core;

import com.kneaf.core.chunkstorage.common.ChunkStorageExceptionHandler;
import com.kneaf.core.chunkstorage.common.StorageStatisticsProvider;
import com.kneaf.core.chunkstorage.core.ChunkStorageCore;
import com.kneaf.core.chunkstorage.core.ChunkStorageManager;
import com.kneaf.core.chunkstorage.swap.SwapManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkStorageCoordinator
implements StorageStatisticsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkStorageCoordinator.class);
    private final ChunkStorageCore core;
    private final SwapManager swapManager;
    private final String worldName;
    private final boolean enabled;

    public ChunkStorageCoordinator(String worldName, ChunkStorageCore core, SwapManager swapManager, boolean enabled) {
        this.worldName = worldName;
        this.core = core;
        this.swapManager = swapManager;
        this.enabled = enabled;
    }

    public void initialize() {
        if (!this.enabled) {
            return;
        }
        try {
            if (this.swapManager != null && this.core.getCache() != null && this.core.getDatabase() != null) {
                LOGGER.info("ChunkStorageCoordinator initialized for world '{ }'", (Object)this.worldName);
            }
        }
        catch (Exception e) {
            ChunkStorageExceptionHandler.handleInitializationException("ChunkStorageCoordinator", e, "Failed to initialize coordinator");
        }
    }

    public CompletableFuture<Boolean> swapOutChunk(String chunkKey) {
        if (!this.enabled || this.swapManager == null) {
            return CompletableFuture.completedFuture(false);
        }
        return this.swapManager.swapOutChunk(chunkKey);
    }

    public CompletableFuture<Boolean> swapInChunk(String chunkKey) {
        if (!this.enabled || this.swapManager == null) {
            return CompletableFuture.completedFuture(false);
        }
        return this.swapManager.swapInChunk(chunkKey);
    }

    public Object getMemoryPressureLevel() {
        if (!this.enabled || this.swapManager == null) {
            return SwapManager.MemoryPressureLevel.NORMAL;
        }
        return this.swapManager.getMemoryPressureLevel();
    }

    public Object getMemoryUsage() {
        if (!this.enabled || this.swapManager == null) {
            return new SwapManager.MemoryUsageInfo(0L, 0L, 0L, 0L, 0.0);
        }
        return this.swapManager.getMemoryUsage();
    }

    public Object getSwapStats() {
        if (!this.enabled || this.swapManager == null) {
            return new SwapManager.SwapManagerStats(false, SwapManager.MemoryPressureLevel.NORMAL, 0L, 0L, 0, 0, new SwapManager.MemoryUsageInfo(0L, 0L, 0L, 0L, 0.0), new SwapManager.SwapStatistics());
        }
        return this.swapManager.getStats();
    }

    public CompletableFuture<Integer> bulkSwapChunks(List<String> chunkKeys, Object operationType) {
        if (!this.enabled || this.swapManager == null) {
            return CompletableFuture.completedFuture(0);
        }
        if (operationType instanceof SwapManager.SwapOperationType) {
            return this.swapManager.bulkSwapChunks(chunkKeys, (SwapManager.SwapOperationType)((Object)operationType));
        }
        return CompletableFuture.completedFuture(0);
    }

    public boolean isAutomaticSwappingEnabled() {
        return this.enabled && this.swapManager != null;
    }

    public Object getActiveSwaps() {
        if (!this.enabled || this.swapManager == null) {
            return Collections.emptyMap();
        }
        return this.swapManager.getActiveSwaps();
    }

    public Object getSwapStatistics() {
        if (!this.enabled || this.swapManager == null) {
            return new SwapManager.SwapStatistics();
        }
        return this.swapManager.getSwapStatistics();
    }

    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        try {
            LOGGER.info("Shutting down ChunkStorageCoordinator for world '{ }'", (Object)this.worldName);
            if (this.swapManager != null) {
                this.swapManager.shutdown();
            }
            LOGGER.info("ChunkStorageCoordinator shutdown completed for world '{ }'", (Object)this.worldName);
        }
        catch (Exception e) {
            ChunkStorageExceptionHandler.handleShutdownException("ChunkStorageCoordinator", e);
        }
    }

    public boolean isHealthy() {
        if (!this.enabled) {
            return false;
        }
        try {
            boolean coreHealthy = this.core.isHealthy();
            boolean swapHealthy = this.swapManager != null;
            return coreHealthy && swapHealthy;
        }
        catch (Exception e) {
            ChunkStorageExceptionHandler.handleHealthCheckException("ChunkStorageCoordinator", e);
            return false;
        }
    }

    public ChunkStorageCore getCore() {
        return this.core;
    }

    public SwapManager getSwapManager() {
        return this.swapManager;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Object getStats() {
        return this.getStorageStats();
    }

    public ChunkStorageManager.StorageStats getStorageStats() {
        if (!this.enabled || this.core == null) {
            return this.createEmptyStorageStats();
        }
        try {
            Object swapStatsObj = this.core.getSwapStats();
            Object dbStatsObj = this.core.getDatabaseStats();
            Object cacheStatsObj = this.core.getCacheStats();
            long totalChunks = 0L;
            long readLatency = 0L;
            long writeLatency = 0L;
            int cachedChunks = 0;
            double cacheHitRate = 0.0;
            boolean swapEnabled = false;
            String memoryPressureLevel = "NORMAL";
            long swapOperationsTotal = 0L;
            long swapOperationsFailed = 0L;
            if (dbStatsObj != null) {
                try {
                    totalChunks = (Long)dbStatsObj.getClass().getMethod("getTotalChunks", new Class[0]).invoke(dbStatsObj, new Object[0]);
                    readLatency = (Long)dbStatsObj.getClass().getMethod("getReadLatencyMs", new Class[0]).invoke(dbStatsObj, new Object[0]);
                    writeLatency = (Long)dbStatsObj.getClass().getMethod("getWriteLatencyMs", new Class[0]).invoke(dbStatsObj, new Object[0]);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to extract database statistics", (Throwable)e);
                }
            }
            if (cacheStatsObj != null) {
                try {
                    cachedChunks = (Integer)cacheStatsObj.getClass().getMethod("getCacheSize", new Class[0]).invoke(cacheStatsObj, new Object[0]);
                    cacheHitRate = (Double)cacheStatsObj.getClass().getMethod("getHitRate", new Class[0]).invoke(cacheStatsObj, new Object[0]);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to extract cache statistics", (Throwable)e);
                }
            }
            if (swapStatsObj != null) {
                try {
                    swapEnabled = (Boolean)swapStatsObj.getClass().getMethod("isEnabled", new Class[0]).invoke(swapStatsObj, new Object[0]);
                    Object pressureLevelObj = swapStatsObj.getClass().getMethod("getPressureLevel", new Class[0]).invoke(swapStatsObj, new Object[0]);
                    memoryPressureLevel = pressureLevelObj.toString();
                    swapOperationsTotal = (Long)swapStatsObj.getClass().getMethod("getTotalOperations", new Class[0]).invoke(swapStatsObj, new Object[0]);
                    swapOperationsFailed = (Long)swapStatsObj.getClass().getMethod("getFailedOperations", new Class[0]).invoke(swapStatsObj, new Object[0]);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to extract swap statistics", (Throwable)e);
                }
            }
            return ChunkStorageManager.StorageStats.builder().enabled(true).totalChunksInDb(totalChunks).cachedChunks(cachedChunks).avgReadLatencyMs(readLatency).avgWriteLatencyMs(writeLatency).cacheHitRate(cacheHitRate).overallHitRate(cacheHitRate).status("storage-manager").swapEnabled(swapEnabled).memoryPressureLevel(memoryPressureLevel).swapOperationsTotal(swapOperationsTotal).swapOperationsFailed(swapOperationsFailed).build();
        }
        catch (Exception e) {
            LOGGER.error("ChunkStorageCoordinator: Failed to get storage Stats", (Throwable)e);
            return this.createEmptyStorageStats();
        }
    }

    private ChunkStorageManager.StorageStats createEmptyStorageStats() {
        return ChunkStorageManager.StorageStats.builder().enabled(false).totalChunksInDb(0L).cachedChunks(0).avgReadLatencyMs(0L).avgWriteLatencyMs(0L).cacheHitRate(0.0).overallHitRate(0.0).status("error").swapEnabled(false).memoryPressureLevel("NORMAL").swapOperationsTotal(0L).swapOperationsFailed(0L).build();
    }
}

