/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage.database;

import com.kneaf.core.chunkstorage.common.ChunkStorageUtils;
import com.kneaf.core.chunkstorage.database.AbstractDatabaseAdapter;
import com.kneaf.core.chunkstorage.database.InMemoryDatabaseAdapter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RustDatabaseAdapter
extends AbstractDatabaseAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RustDatabaseAdapter.class);
    private final long nativePointer;
    private final String databaseType;
    private final boolean checksumEnabled;
    private final AbstractDatabaseAdapter fallbackAdapter;
    private static volatile boolean nativeLibraryAvailable = false;
    private volatile Boolean hasPutChunkAsync = null;
    private volatile Boolean hasGetChunkAsync = null;
    private volatile Boolean hasDeleteChunkAsync = null;
    private volatile Boolean hasSwapOutChunkAsync = null;
    private volatile Boolean hasSwapInChunkAsync = null;
    private final ConcurrentHashMap<String, CacheEntry> readCache = new ConcurrentHashMap();
    private final int MAX_CACHE_SIZE = 4096;
    private final AtomicInteger cacheSize = new AtomicInteger(0);
    private final ReentrantLock cacheLock = new ReentrantLock();
    private final ConcurrentLinkedDeque<String> accessOrder = new ConcurrentLinkedDeque();
    private static final int BATCH_SIZE_THRESHOLD = 32;
    private final Queue<DatabaseOperation> batchQueue = new ConcurrentLinkedQueue<DatabaseOperation>();
    private final ScheduledExecutorService batchExecutor = Executors.newSingleThreadScheduledExecutor();
    private final ReentrantLock batchLock = new ReentrantLock();
    private volatile boolean batchProcessingScheduled = false;

    public static boolean isNativeLibraryAvailable() {
        return nativeLibraryAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RustDatabaseAdapter(String databaseType, boolean checksumEnabled) {
        super(databaseType);
        if (!nativeLibraryAvailable) {
            throw new RustDatabaseException("Rust native library is not available. Cannot initialize RustDatabaseAdapter.");
        }
        this.databaseType = databaseType;
        this.checksumEnabled = checksumEnabled;
        long ptr = 0L;
        int attempts = 0;
        Class<RustDatabaseAdapter> clazz = RustDatabaseAdapter.class;
        synchronized (RustDatabaseAdapter.class) {
            while (ptr == 0L && attempts < 5) {
                ++attempts;
                try {
                    ptr = this.nativeInit(databaseType, checksumEnabled);
                }
                catch (UnsatisfiedLinkError ule) {
                    LOGGER.debug("nativeInit threw UnsatisfiedLinkError on attempt {}: {}", (Object)attempts, (Object)ule.getMessage());
                    ptr = 0L;
                }
                if (ptr != 0L) continue;
                try {
                    Thread.sleep(100 * attempts);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            this.nativePointer = ptr;
            if (this.nativePointer == 0L) {
                LOGGER.warn("Native Rust adapter failed to initialize; falling back to InMemoryDatabaseAdapter for databaseType={}", (Object)databaseType);
                this.fallbackAdapter = new InMemoryDatabaseAdapter(databaseType);
            } else {
                this.fallbackAdapter = null;
                try {
                    this.nativeGetChunkCount(this.nativePointer);
                }
                catch (Throwable t) {
                    LOGGER.debug("Native warm-up call failed (non-fatal): {}", (Object)t.getMessage());
                }
            }
            LOGGER.info("RustDatabaseAdapter initialized with type: {}, checksum: {}, cache size: {}", new Object[]{databaseType, checksumEnabled, 4096});
            return;
        }
    }

    @Override
    public void putChunk(String key, byte[] data) throws IOException {
        ChunkStorageUtils.validateKey(key);
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Chunk data cannot be null or empty");
        }
        if (this.hasPutChunkAsync == null) {
            this.hasPutChunkAsync = this.checkForAsyncOverride("putChunkAsync", String.class, byte[].class);
        }
        if (this.hasPutChunkAsync.booleanValue()) {
            try {
                this.putChunkAsync(key, data).get();
                return;
            }
            catch (Exception e) {
                throw new IOException("Async putChunk override failed", e);
            }
        }
        if (this.nativePointer == 0L) {
            this.fallbackAdapter.putChunk(key, data);
            return;
        }
        try {
            boolean success = this.nativePutChunk(this.nativePointer, key, data);
            if (!success) {
                throw new IOException("Failed to store chunk in Rust database");
            }
            this.cacheChunk(key, data);
        }
        catch (Exception e) {
            throw new IOException("Rust database operation failed", e);
        }
    }

    private boolean checkForAsyncOverride(String methodName, Class<?> ... parameterTypes) {
        try {
            Method m = this.getClass().getMethod(methodName, parameterTypes);
            return m.getDeclaringClass() != RustDatabaseAdapter.class;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private void updateCacheAccess(String key) {
        this.cacheLock.lock();
        try {
            this.accessOrder.remove(key);
            this.accessOrder.addFirst(key);
            CacheEntry entry = this.readCache.get(key);
            if (entry != null) {
                entry.lastAccessTime = System.currentTimeMillis();
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    private void cacheChunk(String key, byte[] data) {
        this.evictIfNeeded();
        this.cacheLock.lock();
        try {
            this.readCache.put(key, new CacheEntry(data));
            this.accessOrder.addFirst(key);
            this.cacheSize.incrementAndGet();
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    private void evictIfNeeded() {
        if (this.cacheSize.get() >= 4096) {
            this.cacheLock.lock();
            try {
                String oldestKey = this.accessOrder.pollLast();
                if (oldestKey != null) {
                    this.readCache.remove(oldestKey);
                    this.cacheSize.decrementAndGet();
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        }
    }

    @Override
    public Optional<byte[]> getChunk(String key) throws IOException {
        ChunkStorageUtils.validateKey(key);
        CacheEntry cached = this.readCache.get(key);
        if (cached != null) {
            this.updateCacheAccess(key);
            return Optional.of(cached.data);
        }
        if (this.hasGetChunkAsync == null) {
            this.hasGetChunkAsync = this.checkForAsyncOverride("getChunkAsync", String.class);
        }
        if (this.hasGetChunkAsync.booleanValue()) {
            try {
                return this.getChunkAsync(key).get();
            }
            catch (Exception e) {
                throw new IOException("Async getChunk override failed", e);
            }
        }
        if (this.nativePointer == 0L) {
            return this.fallbackAdapter.getChunk(key);
        }
        try {
            byte[] data = this.nativeGetChunk(this.nativePointer, key);
            if (data != null) {
                this.cacheChunk(key, data);
            }
            return Optional.ofNullable(data);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to get chunk for key: {}", (Object)key, (Object)e);
            }
            throw new IOException("Rust database operation failed for key: " + key, e);
        }
    }

    @Override
    public boolean deleteChunk(String key) throws IOException {
        ChunkStorageUtils.validateKey(key);
        if (this.hasDeleteChunkAsync == null) {
            this.hasDeleteChunkAsync = this.checkForAsyncOverride("deleteChunkAsync", String.class);
        }
        if (this.hasDeleteChunkAsync.booleanValue()) {
            try {
                return this.deleteChunkAsync(key).get();
            }
            catch (Exception e) {
                throw new IOException("Async deleteChunk override failed", e);
            }
        }
        if (this.nativePointer == 0L) {
            return this.fallbackAdapter.deleteChunk(key);
        }
        try {
            boolean result = this.nativeDeleteChunk(this.nativePointer, key);
            if (result) {
                this.cacheLock.lock();
                try {
                    this.readCache.remove(key);
                    this.cacheSize.decrementAndGet();
                }
                finally {
                    this.cacheLock.unlock();
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException("Rust database operation failed", e);
        }
    }

    @Override
    public CompletableFuture<Boolean> deleteChunkAsync(String key) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.deleteChunk(key);
            }
            catch (IOException e) {
                throw new RustDatabaseException("Async delete operation failed for key: " + key, e);
            }
        });
    }

    @Override
    public boolean hasChunk(String key) throws IOException {
        ChunkStorageUtils.validateKey(key);
        if (this.readCache.containsKey(key)) {
            return true;
        }
        if (this.nativePointer == 0L) {
            return this.fallbackAdapter.hasChunk(key);
        }
        try {
            return this.nativeHasChunk(this.nativePointer, key);
        }
        catch (Exception e) {
            throw new IOException("Rust database operation failed", e);
        }
    }

    @Override
    public long getChunkCount() throws IOException {
        if (this.nativePointer == 0L) {
            return this.fallbackAdapter.getChunkCount();
        }
        try {
            return this.nativeGetChunkCount(this.nativePointer);
        }
        catch (Exception e) {
            throw new IOException("Failed to get chunk count: " + e.getMessage(), e);
        }
    }

    @Override
    public Object getStats() {
        if (this.nativePointer == 0L) {
            return this.fallbackAdapter.getStats();
        }
        try {
            return this.nativeGetStats(this.nativePointer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get database statistics", e);
        }
    }

    @Override
    public void performMaintenance() throws IOException {
        if (this.nativePointer == 0L) {
            this.fallbackAdapter.performMaintenance();
            return;
        }
        try {
            boolean success = this.nativePerformMaintenance(this.nativePointer);
            if (!success) {
                throw new IOException("Failed to perform maintenance on Rust database");
            }
        }
        catch (Exception e) {
            throw new IOException("Rust database maintenance failed", e);
        }
    }

    @Override
    public void createBackup(String backupPath) throws IOException {
        if (backupPath == null || backupPath.trim().isEmpty()) {
            throw new IllegalArgumentException("Backup path cannot be null or empty");
        }
        if (this.nativePointer == 0L) {
            this.fallbackAdapter.createBackup(backupPath);
            return;
        }
        try {
            boolean success = this.nativeCreateBackup(this.nativePointer, backupPath);
            if (!success) {
                throw new IOException("Failed to create backup of Rust database");
            }
        }
        catch (Exception e) {
            throw new IOException("Rust database backup failed", e);
        }
    }

    @Override
    public String getDatabaseType() {
        if (this.nativePointer == 0L) {
            return this.fallbackAdapter.getDatabaseType();
        }
        try {
            return this.nativeGetDatabaseType(this.nativePointer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get database type from Rust", (Throwable)e);
            return "unknown";
        }
    }

    @Override
    public boolean isHealthy() {
        if (this.nativePointer == 0L) {
            return this.fallbackAdapter.isHealthy();
        }
        try {
            return this.nativeIsHealthy(this.nativePointer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to check health status of Rust database", (Throwable)e);
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.nativePointer == 0L) {
            this.fallbackAdapter.close();
            return;
        }
        this.nativeDestroy(this.nativePointer);
        LOGGER.info("RustDatabaseAdapter closed");
    }

    @Override
    public CompletableFuture<Void> putChunkAsync(String key, byte[] data) {
        if (this.nativePointer == 0L) {
            return this.fallbackAdapter.putChunkAsync(key, data);
        }
        return CompletableFuture.runAsync(() -> {
            try {
                this.putChunk(key, data);
            }
            catch (IOException e) {
                throw new RustDatabaseException("Async put operation failed for key: " + key, e);
            }
        });
    }

    @Override
    public CompletableFuture<Optional<byte[]>> getChunkAsync(String key) {
        if (this.nativePointer == 0L) {
            return this.fallbackAdapter.getChunkAsync(key);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.getChunk(key);
            }
            catch (IOException e) {
                throw new RustDatabaseException("Async get operation failed for key: " + key, e);
            }
        });
    }

    public boolean isChecksumEnabled() {
        return this.checksumEnabled;
    }

    @Override
    public boolean swapOutChunk(String key) throws IOException {
        ChunkStorageUtils.validateKey(key);
        if (this.nativePointer == 0L) {
            try {
                if (!this.isHealthy()) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            return this.fallbackAdapter.hasChunk(key);
        }
        if (this.hasSwapOutChunkAsync == null) {
            this.hasSwapOutChunkAsync = this.checkForAsyncOverride("swapOutChunkAsync", String.class);
        }
        if (this.hasSwapOutChunkAsync.booleanValue()) {
            try {
                return this.swapOutChunkAsync(key).get();
            }
            catch (Exception e) {
                throw new IOException("Async swapOutChunk override failed", e);
            }
        }
        try {
            boolean result = this.nativeSwapOutChunk(this.nativePointer, key);
            if (result) {
                this.cacheLock.lock();
                try {
                    this.readCache.remove(key);
                    this.cacheSize.decrementAndGet();
                }
                finally {
                    this.cacheLock.unlock();
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException("Rust swap out operation failed", e);
        }
    }

    @Override
    public Optional<byte[]> swapInChunk(String key) throws IOException {
        ChunkStorageUtils.validateKey(key);
        CacheEntry cached = this.readCache.get(key);
        if (cached != null) {
            cached.lastAccessTime = System.currentTimeMillis();
            return Optional.of(cached.data);
        }
        if (this.nativePointer == 0L) {
            return this.fallbackAdapter.getChunk(key);
        }
        if (this.hasSwapInChunkAsync == null) {
            this.hasSwapInChunkAsync = this.checkForAsyncOverride("swapInChunkAsync", String.class);
        }
        if (this.hasSwapInChunkAsync.booleanValue()) {
            try {
                return this.swapInChunkAsync(key).get();
            }
            catch (Exception e) {
                throw new IOException("Async swapInChunk override failed", e);
            }
        }
        try {
            byte[] data = this.nativeSwapInChunk(this.nativePointer, key);
            if (data != null) {
                this.evictIfNeeded();
                this.readCache.put(key, new CacheEntry(data));
                this.cacheSize.incrementAndGet();
                return Optional.of(data);
            }
            byte[] direct = this.nativeGetChunk(this.nativePointer, key);
            if (direct != null) {
                this.evictIfNeeded();
                this.readCache.put(key, new CacheEntry(direct));
                this.cacheSize.incrementAndGet();
            }
            return Optional.ofNullable(direct);
        }
        catch (Exception e) {
            throw new IOException("Rust swap in operation failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSwapCandidates(int limit) throws IOException {
        if (this.nativePointer == 0L) {
            return new ArrayList<String>();
        }
        ArrayList<String> candidates = new ArrayList<String>();
        this.cacheLock.lock();
        try {
            ArrayList<Map.Entry<String, CacheEntry>> sortedEntries = new ArrayList<Map.Entry<String, CacheEntry>>(this.readCache.entrySet());
            sortedEntries.sort((a, b) -> Long.compare(((CacheEntry)a.getValue()).lastAccessTime, ((CacheEntry)b.getValue()).lastAccessTime));
            int toAdd = Math.min(limit, sortedEntries.size());
            for (int i = 0; i < toAdd; ++i) {
                candidates.add((String)((Map.Entry)sortedEntries.get(i)).getKey());
            }
        }
        finally {
            this.cacheLock.unlock();
        }
        if (candidates.size() < limit) {
            try {
                List<String> nativeCandidates = this.nativeGetSwapCandidates(this.nativePointer, limit - candidates.size());
                candidates.addAll(nativeCandidates);
            }
            catch (Exception e) {
                throw new IOException("Failed to get native swap candidates", e);
            }
        }
        return candidates.subList(0, Math.min(limit, candidates.size()));
    }

    @Override
    public int bulkSwapOut(List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("Keys list cannot be null or empty");
        }
        if (this.nativePointer == 0L) {
            int count = 0;
            for (String k : keys) {
                try {
                    if (!this.fallbackAdapter.hasChunk(k)) continue;
                    ++count;
                }
                catch (IOException e) {
                    LOGGER.debug("Failed to check chunk existence during bulk swap out: {}", (Object)k, (Object)e);
                }
            }
            return count;
        }
        try {
            return this.nativeBulkSwapOut(this.nativePointer, keys);
        }
        catch (Exception e) {
            throw new RuntimeException("Rust bulk swap out operation failed", e);
        }
    }

    @Override
    public List<byte[]> bulkSwapIn(List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("Keys list cannot be null or empty");
        }
        if (this.nativePointer == 0L) {
            ArrayList<byte[]> results = new ArrayList<byte[]>();
            for (String k : keys) {
                try {
                    Optional<byte[]> data = this.fallbackAdapter.getChunk(k);
                    if (!data.isPresent()) continue;
                    results.add(data.get());
                }
                catch (IOException e) {
                    LOGGER.debug("Failed to get chunk during bulk swap in: {}", (Object)k, (Object)e);
                }
            }
            return results;
        }
        try {
            return this.nativeBulkSwapIn(this.nativePointer, keys);
        }
        catch (Exception e) {
            throw new RuntimeException("Rust bulk swap in operation failed", e);
        }
    }

    public CompletableFuture<Boolean> swapOutChunkAsync(String key) {
        if (this.nativePointer == 0L) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return this.swapOutChunk(key);
                }
                catch (IOException e) {
                    throw new RustDatabaseException("Async swap out operation failed for key: " + key, e);
                }
            });
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.swapOutChunk(key);
            }
            catch (IOException e) {
                throw new RustDatabaseException("Async swap out operation failed for key: " + key, e);
            }
        });
    }

    public CompletableFuture<Optional<byte[]>> swapInChunkAsync(String key) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.swapInChunk(key);
            }
            catch (IOException e) {
                throw new RustDatabaseException("Async swap in operation failed for key: " + key, e);
            }
        });
    }

    private native long nativeInit(String var1, boolean var2);

    private native boolean nativePutChunk(long var1, String var3, byte[] var4);

    private native byte[] nativeGetChunk(long var1, String var3);

    private native boolean nativeDeleteChunk(long var1, String var3);

    private native boolean nativeHasChunk(long var1, String var3);

    private native long nativeGetChunkCount(long var1);

    private native Object nativeGetStats(long var1);

    private native boolean nativePerformMaintenance(long var1);

    private native boolean nativeCreateBackup(long var1, String var3);

    private native String nativeGetDatabaseType(long var1);

    private native boolean nativeIsHealthy(long var1);

    private native void nativeDestroy(long var1);

    private native boolean nativeSwapOutChunk(long var1, String var3);

    private native byte[] nativeSwapInChunk(long var1, String var3);

    private native List<String> nativeGetSwapCandidates(long var1, int var3);

    private native int nativeBulkSwapOut(long var1, List<String> var3);

    private native List<byte[]> nativeBulkSwapIn(long var1, List<String> var3);

    @Override
    public String toString() {
        return String.format("RustDatabaseAdapter[type=%s, checksum=%s, healthy=%s]", this.databaseType, this.checksumEnabled, this.isHealthy());
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {}));
        try {
            System.loadLibrary("rustperf");
            nativeLibraryAvailable = true;
            LOGGER.info("Rust database library loaded successfully");
        }
        catch (UnsatisfiedLinkError e) {
            String[] fallbackPaths;
            boolean loaded = false;
            for (String path : fallbackPaths = new String[]{"run/rustperf.dll", "run/librustperf.dll", "rust/target/release/librustperf.dll", "target/release/librustperf.dll", "./rust/target/release/librustperf.dll", "./run/rustperf.dll"}) {
                try {
                    File f = new File(path);
                    if (!f.exists()) continue;
                    System.load(f.getAbsolutePath());
                    loaded = true;
                    LOGGER.info("Loaded Rust native library from fallback path: {}", (Object)f.getAbsolutePath());
                    break;
                }
                catch (UnsatisfiedLinkError ule) {
                    LOGGER.debug("Fallback load failed for {}: {}", (Object)path, (Object)ule.getMessage());
                }
            }
            if (!loaded) {
                nativeLibraryAvailable = false;
                LOGGER.warn("Failed to load Rust database library: {}. Native operations will be disabled.", (Object)e.getMessage());
            }
            nativeLibraryAvailable = true;
        }
    }

    public static class RustDatabaseException
    extends RuntimeException {
        public RustDatabaseException(String message) {
            super(message);
        }

        public RustDatabaseException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class CacheEntry {
        byte[] data;
        long lastAccessTime;

        CacheEntry(byte[] data) {
            this.data = data;
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    private static class DatabaseOperation {
        final String key;
        final byte[] data;
        final OperationType type;
        final CompletableFuture<?> future;

        DatabaseOperation(String key, byte[] data, OperationType type, CompletableFuture<?> future) {
            this.key = key;
            this.data = data;
            this.type = type;
            this.future = future;
        }
    }

    private static enum OperationType {
        PUT,
        GET,
        DELETE,
        HAS,
        SWAP_OUT,
        SWAP_IN;

    }
}

