/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.config.core;

import com.kneaf.core.config.core.ConfigurationConstants;
import com.kneaf.core.config.core.ConfigurationUtils;
import com.kneaf.core.config.performance.PerformanceConfiguration;
import com.kneaf.core.config.resource.ResourceConfiguration;
import com.kneaf.core.config.storage.ChunkStorageConfiguration;
import com.kneaf.core.config.storage.SwapConfiguration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationManager.class);
    private static final String DEFAULT_CONFIG_PATH = "config/kneaf-core.properties";
    private static volatile ConfigurationManager instance;
    private final ConcurrentMap<Class<?>, Object> configurations = new ConcurrentHashMap();
    private final Properties properties = ConfigurationUtils.loadProperties("config/kneaf-core.properties");

    private ConfigurationManager() {
        this.initializeDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigurationManager getInstance() {
        if (instance != null) return instance;
        Class<ConfigurationManager> clazz = ConfigurationManager.class;
        synchronized (ConfigurationManager.class) {
            if (instance != null) return instance;
            instance = new ConfigurationManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public <T> T getConfiguration(Class<T> configType) {
        return (T)this.configurations.computeIfAbsent(configType, this::createConfiguration);
    }

    public <T> void registerConfiguration(Class<T> configType, Function<Properties, T> factory) {
        this.configurations.put(configType, factory.apply(this.properties));
        LOGGER.info("Registered custom configuration type: { }", (Object)configType.getSimpleName());
    }

    public void reload() {
        Properties newProperties = ConfigurationUtils.loadProperties(DEFAULT_CONFIG_PATH);
        this.configurations.clear();
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)newProperties);
        this.initializeDefaults();
        LOGGER.info("Configuration reloaded from: { }", (Object)DEFAULT_CONFIG_PATH);
    }

    public String getProperty(String key, String defaultValue) {
        return ConfigurationUtils.getProperty(this.properties, key, defaultValue);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        return ConfigurationUtils.getBooleanProperty(this.properties, key, defaultValue);
    }

    public int getIntProperty(String key, int defaultValue) {
        return ConfigurationUtils.getIntProperty(this.properties, key, defaultValue);
    }

    public long getLongProperty(String key, long defaultValue) {
        return ConfigurationUtils.getLongProperty(this.properties, key, defaultValue);
    }

    public double getDoubleProperty(String key, double defaultValue) {
        return ConfigurationUtils.getDoubleProperty(this.properties, key, defaultValue);
    }

    public String[] getStringArrayProperty(String key, String[] defaultValue) {
        return ConfigurationUtils.getStringArrayProperty(this.properties, key, defaultValue);
    }

    private void initializeDefaults() {
        this.registerConfiguration(PerformanceConfiguration.class, this::createPerformanceConfig);
        this.registerConfiguration(ChunkStorageConfiguration.class, this::createChunkStorageConfig);
        this.registerConfiguration(SwapConfiguration.class, this::createSwapConfig);
        this.registerConfiguration(ResourceConfiguration.class, this::createResourceConfig);
    }

    private PerformanceConfiguration createPerformanceConfig(Properties props) {
        return PerformanceConfiguration.builder().enabled(ConfigurationUtils.getBooleanProperty(props, "performance.enabled", true)).threadpoolSize(ConfigurationUtils.getIntProperty(props, "performance.threadpoolSize", 4)).logIntervalTicks(ConfigurationUtils.getIntProperty(props, "performance.logIntervalTicks", 100)).scanIntervalTicks(ConfigurationUtils.getIntProperty(props, "performance.scanIntervalTicks", 1)).tpsThresholdForAsync(ConfigurationUtils.getDoubleProperty(props, "performance.tpsThresholdForAsync", 19.0)).maxEntitiesToCollect(ConfigurationUtils.getIntProperty(props, "performance.maxEntitiesToCollect", 20000)).entityDistanceCutoff(ConfigurationUtils.getDoubleProperty(props, "performance.entityDistanceCutoff", 256.0)).maxLogBytes(ConfigurationUtils.getLongProperty(props, "performance.maxLogBytes", 0xA00000L)).adaptiveThreadPool(ConfigurationUtils.getBooleanProperty(props, "performance.adaptiveThreadPool", false)).maxThreadpoolSize(ConfigurationUtils.getIntProperty(props, "performance.maxThreadpoolSize", ConfigurationConstants.DEFAULT_MAX_THREAD_POOL_SIZE)).excludedEntityTypes(ConfigurationUtils.getStringArrayProperty(props, "performance.excludedEntityTypes", new String[0])).networkExecutorpoolSize(ConfigurationUtils.getIntProperty(props, "performance.networkExecutorpoolSize", ConfigurationConstants.DEFAULT_NETWORK_EXECUTOR_POOL_SIZE)).profilingEnabled(ConfigurationUtils.getBooleanProperty(props, "performance.profilingEnabled", true)).slowTickThresholdMs(ConfigurationUtils.getLongProperty(props, "performance.slowTickThresholdMs", 50L)).profilingSampleRate(ConfigurationUtils.getIntProperty(props, "performance.profilingSampleRate", 100)).minThreadpoolSize(ConfigurationUtils.getIntProperty(props, "performance.minThreadpoolSize", 2)).dynamicThreadScaling(ConfigurationUtils.getBooleanProperty(props, "performance.dynamicThreadScaling", true)).threadScaleUpThreshold(ConfigurationUtils.getDoubleProperty(props, "performance.threadScaleUpThreshold", 0.8)).threadScaleDownThreshold(ConfigurationUtils.getDoubleProperty(props, "performance.threadScaleDownThreshold", 0.3)).threadScaleUpDelayTicks(ConfigurationUtils.getIntProperty(props, "performance.threadScaleUpDelayTicks", 100)).threadScaleDownDelayTicks(ConfigurationUtils.getIntProperty(props, "performance.threadScaleDownDelayTicks", 200)).workStealingEnabled(ConfigurationUtils.getBooleanProperty(props, "performance.workStealingEnabled", true)).workStealingQueueSize(ConfigurationUtils.getIntProperty(props, "performance.workStealingQueueSize", 100)).cpuAwareThreadSizing(ConfigurationUtils.getBooleanProperty(props, "performance.cpuAwareThreadSizing", false)).cpuLoadThreshold(ConfigurationUtils.getDoubleProperty(props, "performance.cpuLoadThreshold", 0.7)).threadPoolKeepAliveSeconds(ConfigurationUtils.getIntProperty(props, "performance.threadPoolKeepAliveSeconds", 60)).distanceCalculationInterval(ConfigurationUtils.getIntProperty(props, "performance.distanceCalculationInterval", 1)).distanceApproximationEnabled(ConfigurationUtils.getBooleanProperty(props, "performance.distanceApproximationEnabled", true)).distanceCacheSize(ConfigurationUtils.getIntProperty(props, "performance.distanceCacheSize", 100)).itemProcessingIntervalMultiplier(ConfigurationUtils.getIntProperty(props, "performance.itemProcessingIntervalMultiplier", 1)).spatialGridUpdateInterval(ConfigurationUtils.getIntProperty(props, "performance.spatialGridUpdateInterval", 1)).incrementalSpatialUpdates(ConfigurationUtils.getBooleanProperty(props, "performance.incrementalSpatialUpdates", true)).build();
    }

    private ChunkStorageConfiguration createChunkStorageConfig(Properties props) {
        return ChunkStorageConfiguration.builder().enabled(ConfigurationUtils.getBooleanProperty(props, "chunkstorage.enabled", true)).cacheCapacity(ConfigurationUtils.getIntProperty(props, "chunkstorage.cacheCapacity", 1000)).evictionPolicy(ConfigurationUtils.getProperty(props, "chunkstorage.evictionPolicy", "LRU")).asyncThreadpoolSize(ConfigurationUtils.getIntProperty(props, "chunkstorage.asyncThreadpoolSize", 4)).enableAsyncOperations(ConfigurationUtils.getBooleanProperty(props, "chunkstorage.enableAsyncOperations", true)).maintenanceIntervalMinutes(ConfigurationUtils.getLongProperty(props, "chunkstorage.maintenanceIntervalMinutes", 60L)).enableBackups(ConfigurationUtils.getBooleanProperty(props, "chunkstorage.enableBackups", true)).backupPath(ConfigurationUtils.getProperty(props, "chunkstorage.backupPath", "backups/chunkstorage")).enableChecksums(ConfigurationUtils.getBooleanProperty(props, "chunkstorage.enableChecksums", true)).enableCompression(ConfigurationUtils.getBooleanProperty(props, "chunkstorage.enableCompression", false)).maxBackupFiles(ConfigurationUtils.getIntProperty(props, "chunkstorage.maxBackupFiles", 10)).backupRetentionDays(ConfigurationUtils.getLongProperty(props, "chunkstorage.backupRetentionDays", 7L)).databaseType(ConfigurationUtils.getProperty(props, "chunkstorage.databaseType", "rust")).useRustDatabase(ConfigurationUtils.getBooleanProperty(props, "chunkstorage.useRustDatabase", true)).build();
    }

    private SwapConfiguration createSwapConfig(Properties props) {
        return SwapConfiguration.builder().enabled(ConfigurationUtils.getBooleanProperty(props, "swap.enabled", true)).memoryCheckIntervalMs(ConfigurationUtils.getLongProperty(props, "swap.memoryCheckIntervalMs", 5000L)).maxConcurrentSwaps(ConfigurationUtils.getIntProperty(props, "swap.maxConcurrentSwaps", 10)).swapBatchSize(ConfigurationUtils.getIntProperty(props, "swap.swapBatchSize", 50)).swapTimeoutMs(ConfigurationUtils.getLongProperty(props, "swap.swapTimeoutMs", 30000L)).enableAutomaticSwapping(ConfigurationUtils.getBooleanProperty(props, "swap.enableAutomaticSwapping", true)).criticalMemoryThreshold(ConfigurationUtils.getDoubleProperty(props, "swap.criticalMemoryThreshold", 0.95)).highMemoryThreshold(ConfigurationUtils.getDoubleProperty(props, "swap.highMemoryThreshold", 0.85)).elevatedMemoryThreshold(ConfigurationUtils.getDoubleProperty(props, "swap.elevatedMemoryThreshold", 0.75)).minSwapChunkAgeMs(ConfigurationUtils.getIntProperty(props, "swap.minSwapChunkAgeMs", 60000)).enableSwapStatistics(ConfigurationUtils.getBooleanProperty(props, "swap.enableSwapStatistics", true)).enablePerformanceMonitoring(ConfigurationUtils.getBooleanProperty(props, "swap.enablePerformanceMonitoring", true)).build();
    }

    private ResourceConfiguration createResourceConfig(Properties props) {
        return ResourceConfiguration.builder().resourceCleanupIntervalSeconds(ConfigurationUtils.getIntProperty(props, "resource.cleanupIntervalSeconds", 300)).resourceHealthCheckIntervalSeconds(ConfigurationUtils.getIntProperty(props, "resource.healthCheckIntervalSeconds", 60)).maxResourceAgeMinutes(ConfigurationUtils.getIntProperty(props, "resource.maxResourceAgeMinutes", 30)).resourcePoolEnabled(ConfigurationUtils.getBooleanProperty(props, "resource.poolEnabled", true)).resourcePoolMaxSize(ConfigurationUtils.getIntProperty(props, "resource.poolMaxSize", 100)).resourcePoolInitialSize(ConfigurationUtils.getIntProperty(props, "resource.poolInitialSize", 10)).build();
    }

    private <T> Object createConfiguration(Class<T> configType) {
        throw new IllegalArgumentException("Unknown configuration type: " + configType.getSimpleName());
    }
}

