/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.logging;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RustLogger {
    private static final Logger LOGGER = LogManager.getLogger((String)"KneafMod");

    public static void logFromRust(String level, String message) {
        if (level == null || message == null) {
            return;
        }
        String formattedMessage = "[KneafMod] " + message;
        switch (level.toUpperCase()) {
            case "DEBUG": {
                LOGGER.debug(formattedMessage);
                break;
            }
            case "INFO": {
                LOGGER.info(formattedMessage);
                break;
            }
            case "WARN": {
                LOGGER.warn(formattedMessage);
                break;
            }
            case "ERROR": {
                LOGGER.error(formattedMessage);
                break;
            }
            case "TRACE": {
                LOGGER.trace(formattedMessage);
                break;
            }
            default: {
                LOGGER.info(formattedMessage);
            }
        }
    }

    public static void initNativeLogging() {
        LOGGER.info("[KneafMod] Rust logging system initialized");
    }

    public static void logSystemStatus(String cpuCapabilities, String simdLevel, double fallbackRate, double opsPerCycle) {
        LOGGER.info("[KneafMod] CPU Capabilities: {}", (Object)cpuCapabilities);
        LOGGER.info("[KneafMod] SIMD Level: {}", (Object)simdLevel);
        LOGGER.info("[KneafMod] Performance: {:.2f}% fallback rate, {:.2f} ops/cycle", (Object)(fallbackRate * 100.0), (Object)opsPerCycle);
    }

    public static void logMemoryPoolStatus(double usagePercentage, double hitRate, int contention) {
        LOGGER.info("[KneafMod] Memory Pool: {:.1f}% usage, {:.1f}% hit rate, {} contention", (Object)usagePercentage, (Object)hitRate, (Object)contention);
    }

    public static void logThreadPoolStatus(int activeThreads, int queueSize, double utilization) {
        LOGGER.info("[KneafMod] Thread Pool: {} active threads, {} queue size, {:.1f}% utilization", (Object)activeThreads, (Object)queueSize, (Object)utilization);
    }

    public static void logPerformanceMetrics(double tps, double latency, long gcEvents) {
        LOGGER.info("[KneafMod] Performance Metrics: {:.2f} TPS, {:.2f}ms latency, {} GC events", (Object)tps, (Object)latency, (Object)gcEvents);
    }

    public static void logConfigurationStatus(boolean extremeMode, boolean safetyChecks, double tpsThreshold) {
        LOGGER.info("[KneafMod] Extreme Performance Mode: {} (TPS threshold: {:.1f})", (Object)(extremeMode ? "ACTIVE" : "INACTIVE"), (Object)tpsThreshold);
        LOGGER.info("[KneafMod] Safety Checks: {}", (Object)(safetyChecks ? "ENABLED" : "DISABLED"));
    }

    public static void logStartupInfo(String optimizationsActive, String cpuInfo, String configApplied) {
        LOGGER.info("[KneafMod] === KNEAF MOD STARTUP ===");
        LOGGER.info("[KneafMod] Active Optimizations: {}", (Object)optimizationsActive);
        LOGGER.info("[KneafMod] CPU Info: {}", (Object)cpuInfo);
        LOGGER.info("[KneafMod] Configuration Applied: {}", (Object)configApplied);
        LOGGER.info("[KneafMod] =========================");
    }

    public static void logRealTimeStatus(String systemStatus, String importantEvents) {
        if (importantEvents != null && !importantEvents.isEmpty()) {
            LOGGER.info("[KneafMod] System Status: {} | Events: {}", (Object)systemStatus, (Object)importantEvents);
        } else {
            LOGGER.info("[KneafMod] System Status: {}", (Object)systemStatus);
        }
    }

    public static void logThresholdEvent(String eventType, String message, double thresholdValue, double actualValue) {
        LOGGER.warn("[KneafMod] THRESHOLD EVENT [{}]: {} ({} > {})", (Object)eventType, (Object)message, (Object)actualValue, (Object)thresholdValue);
    }
}

