/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompileTimeMethodResolver {
    private static final CompileTimeMethodResolver INSTANCE = new CompileTimeMethodResolver();
    private static final Logger LOGGER = LoggerFactory.getLogger(CompileTimeMethodResolver.class);
    private final ConcurrentHashMap<String, MethodHandle> methodHandleCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CallSite> callSiteCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Function<Object, Object>> lambdaCache = new ConcurrentHashMap();
    private final AtomicLong cacheHits = new AtomicLong(0L);
    private final AtomicLong cacheMisses = new AtomicLong(0L);
    private final AtomicLong reflectionFallbacks = new AtomicLong(0L);
    private final AtomicLong compilationErrors = new AtomicLong(0L);
    private final AtomicLong compilationFailures = new AtomicLong(0L);
    private static final int MAX_COMPILATION_RETRIES = 3;
    private static final int CIRCUIT_BREAKER_THRESHOLD = 5;
    private static final long COMPILATION_TIMEOUT_MS = 5000L;
    private static final MethodType VOID_METHOD = MethodType.methodType(Void.TYPE);
    private static final MethodType BOOLEAN_METHOD = MethodType.methodType(Boolean.TYPE);
    private static final MethodType INT_METHOD = MethodType.methodType(Integer.TYPE);
    private static final MethodType LONG_METHOD = MethodType.methodType(Long.TYPE);
    private static final MethodType FLOAT_METHOD = MethodType.methodType(Float.TYPE);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    private CompileTimeMethodResolver() {
        this.precompileCommonMethods();
    }

    public static CompileTimeMethodResolver getInstance() {
        return INSTANCE;
    }

    private void precompileCommonMethods() {
        try {
            boolean entityIdSuccess = this.compileMethod("com.kneaf.core.data.EntityData", MethodSignature.GET_ID);
            boolean entityPosSuccess = this.compileMethod("com.kneaf.core.data.EntityData", MethodSignature.GET_POSITION);
            boolean entityAliveSuccess = this.compileMethod("com.kneaf.core.data.EntityData", MethodSignature.IS_ALIVE);
            boolean blockIdSuccess = this.compileMethod("com.kneaf.core.data.BlockEntityData", MethodSignature.GET_BLOCK_ID);
            boolean blockStateSuccess = this.compileMethod("com.kneaf.core.data.BlockEntityData", MethodSignature.GET_BLOCK_STATE);
            boolean blockSolidSuccess = this.compileMethod("com.kneaf.core.data.BlockEntityData", MethodSignature.IS_BLOCK_SOLID);
            boolean playerNameSuccess = this.compileMethod("com.kneaf.core.data.PlayerData", MethodSignature.GET_PLAYER_NAME);
            boolean playerPosSuccess = this.compileMethod("com.kneaf.core.data.PlayerData", MethodSignature.GET_PLAYER_POSITION);
            boolean playerHealthSuccess = this.compileMethod("com.kneaf.core.data.PlayerData", MethodSignature.GET_PLAYER_HEALTH);
            boolean worldTimeSuccess = this.compileMethod("net.minecraft.world.level.Level", MethodSignature.GET_WORLD_TIME);
            boolean blockAtSuccess = this.compileMethod("net.minecraft.world.level.Level", MethodSignature.GET_BLOCK_AT);
            boolean setBlockSuccess = this.compileMethod("net.minecraft.world.level.Level", MethodSignature.SET_BLOCK_AT);
            LOGGER.info("Pre-compilation results:");
            LOGGER.info("Entity methods: ID={}, Position={}, Alive={}", new Object[]{entityIdSuccess, entityPosSuccess, entityAliveSuccess});
            LOGGER.info("Block methods: ID={}, State={}, Solid={}", new Object[]{blockIdSuccess, blockStateSuccess, blockSolidSuccess});
            LOGGER.info("Player methods: Name={}, Position={}, Health={}", new Object[]{playerNameSuccess, playerPosSuccess, playerHealthSuccess});
            LOGGER.info("World methods: Time={}, GetBlock={}, SetBlock={}", new Object[]{worldTimeSuccess, blockAtSuccess, setBlockSuccess});
        }
        catch (Exception e) {
            LOGGER.error("Error pre-compiling common methods: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public boolean compileMethod(String className, MethodSignature signature) {
        String cacheKey = className + "." + signature.getMethodName();
        try {
            Class<?> clazz = Class.forName(className);
            Method method = this.findMethod(clazz, signature);
            if (method == null) {
                LOGGER.warn("Method not found: {} in class {}", (Object)signature.getMethodName(), (Object)className);
                return false;
            }
            method.setAccessible(true);
            MethodHandle handle = LOOKUP.unreflect(method);
            this.methodHandleCache.put(cacheKey, handle);
            if (signature.getParameterTypes().length == 0) {
                this.createOptimizedLambda(cacheKey, handle, signature);
            }
            return true;
        }
        catch (Exception e) {
            this.compilationErrors.incrementAndGet();
            LOGGER.error("Error compiling method {}: {}", new Object[]{cacheKey, e.getMessage(), e});
            return false;
        }
        catch (Error e) {
            this.compilationErrors.incrementAndGet();
            LOGGER.error("Critical error compiling method {}: {}", new Object[]{cacheKey, e.getMessage(), e});
            return false;
        }
    }

    private Method findMethod(Class<?> clazz, MethodSignature signature) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                if (signature.getParameterTypes().length == 0) {
                    return currentClass.getDeclaredMethod(signature.getMethodName(), new Class[0]);
                }
                return currentClass.getDeclaredMethod(signature.getMethodName(), signature.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            try {
                if (signature.getParameterTypes().length == 0) {
                    return iface.getDeclaredMethod(signature.getMethodName(), new Class[0]);
                }
                return iface.getDeclaredMethod(signature.getMethodName(), signature.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    private void createOptimizedLambda(String cacheKey, MethodHandle handle, MethodSignature signature) {
        try {
            TypeDescriptor.OfField returnType = signature.getMethodType().returnType();
            if (returnType == Long.TYPE) {
                CallSite callSite = LambdaMetafactory.metafactory(LOOKUP, "applyAsLong", MethodType.methodType(ToLongFunction.class), MethodType.methodType(Long.TYPE, Object.class), handle, handle.type());
                ToLongFunction lambda = callSite.getTarget().invoke();
                this.lambdaCache.put(cacheKey, obj -> lambda.applyAsLong(obj));
                this.callSiteCache.put(cacheKey, callSite);
            } else if (returnType == Integer.TYPE) {
                CallSite callSite = LambdaMetafactory.metafactory(LOOKUP, "applyAsInt", MethodType.methodType(ToIntFunction.class), MethodType.methodType(Integer.TYPE, Object.class), handle, handle.type());
                ToIntFunction lambda = callSite.getTarget().invoke();
                this.lambdaCache.put(cacheKey, obj -> (long)lambda.applyAsInt(obj));
                this.callSiteCache.put(cacheKey, callSite);
            } else if (returnType == Boolean.TYPE) {
                CallSite callSite = LambdaMetafactory.metafactory(LOOKUP, "test", MethodType.methodType(Predicate.class), MethodType.methodType(Boolean.TYPE, Object.class), handle, handle.type());
                Predicate lambda = callSite.getTarget().invoke();
                this.lambdaCache.put(cacheKey, obj -> lambda.test(obj));
                this.callSiteCache.put(cacheKey, callSite);
            } else if (returnType == Float.TYPE) {
                CallSite callSite = LambdaMetafactory.metafactory(LOOKUP, "apply", MethodType.methodType(ToDoubleFunction.class), MethodType.methodType(Double.TYPE, Object.class), handle, handle.type());
                ToDoubleFunction lambda = callSite.getTarget().invoke();
                this.lambdaCache.put(cacheKey, obj -> Float.valueOf((float)lambda.applyAsDouble(obj)));
                this.callSiteCache.put(cacheKey, callSite);
            } else {
                CallSite callSite = LambdaMetafactory.metafactory(LOOKUP, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), handle, handle.type());
                Function lambda = callSite.getTarget().invoke();
                this.lambdaCache.put(cacheKey, lambda);
                this.callSiteCache.put(cacheKey, callSite);
            }
        }
        catch (Throwable e) {
            this.compilationErrors.incrementAndGet();
            LOGGER.error("Error creating optimized lambda for {}: {}", new Object[]{cacheKey, e.getMessage(), e});
        }
    }

    public <T, R> R invokeMethod(T target, String className, MethodSignature signature) throws Throwable {
        String cacheKey = className + "." + signature.getMethodName();
        Function<Object, Object> lambda = this.lambdaCache.get(cacheKey);
        if (lambda != null) {
            this.cacheHits.incrementAndGet();
            return (R)lambda.apply(target);
        }
        MethodHandle handle = this.methodHandleCache.get(cacheKey);
        if (handle != null) {
            this.cacheHits.incrementAndGet();
            return (R)handle.invoke(target);
        }
        this.cacheMisses.incrementAndGet();
        return this.invokeWithReflection(target, className, signature);
    }

    public <T, R> R invokeMethodWithParams(T target, String className, MethodSignature signature, Object ... params) throws Throwable {
        String cacheKey = className + "." + signature.getMethodName();
        MethodHandle handle = this.methodHandleCache.get(cacheKey);
        if (handle != null) {
            this.cacheHits.incrementAndGet();
            return (R)handle.invoke(target, params);
        }
        this.cacheMisses.incrementAndGet();
        return this.invokeWithReflectionAndParams(target, className, signature, params);
    }

    private <T, R> R invokeWithReflection(T target, String className, MethodSignature signature) throws Throwable {
        this.reflectionFallbacks.incrementAndGet();
        try {
            Class<?> clazz = Class.forName(className);
            Method method = this.findMethod(clazz, signature);
            if (method == null) {
                throw new NoSuchMethodException("Method not found: " + signature.getMethodName());
            }
            method.setAccessible(true);
            return (R)method.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Reflection fallback failed for " + className + "." + signature.getMethodName(), e);
        }
    }

    private <T, R> R invokeWithReflectionAndParams(T target, String className, MethodSignature signature, Object[] params) throws Throwable {
        this.reflectionFallbacks.incrementAndGet();
        try {
            Class<?> clazz = Class.forName(className);
            Method method = this.findMethod(clazz, signature);
            if (method == null) {
                throw new NoSuchMethodException("Method not found: " + signature.getMethodName());
            }
            method.setAccessible(true);
            return (R)method.invoke(target, params);
        }
        catch (Exception e) {
            throw new RuntimeException("Reflection fallback failed for " + className + "." + signature.getMethodName(), e);
        }
    }

    public <T, R> Map<T, R> batchInvokeMethod(Iterable<T> targets, String className, MethodSignature signature) {
        HashMap<T, Object> results = new HashMap<T, Object>();
        String cacheKey = className + "." + signature.getMethodName();
        Function<Object, Object> lambda = this.lambdaCache.get(cacheKey);
        MethodHandle handle = this.methodHandleCache.get(cacheKey);
        if (lambda != null) {
            for (T target : targets) {
                try {
                    Object result = lambda.apply(target);
                    results.put(target, result);
                }
                catch (Exception e) {
                    LOGGER.warn("Batch invocation failed for target: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        } else if (handle != null) {
            for (T target : targets) {
                try {
                    Object result = handle.invoke(target);
                    results.put(target, result);
                }
                catch (Throwable e) {
                    LOGGER.warn("Batch invocation failed for target: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        } else {
            for (T target : targets) {
                try {
                    R result = this.invokeWithReflection(target, className, signature);
                    results.put(target, result);
                }
                catch (Throwable e) {
                    LOGGER.warn("Batch reflection invocation failed for target: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return results;
    }

    public <T> MethodCall<T, Object> createMethodCaller(String className, MethodSignature signature) {
        String cacheKey = className + "." + signature.getMethodName();
        if (this.compilationFailures.get() >= 5L) {
            System.err.println("Circuit breaker activated: Too many compilation failures (" + this.compilationFailures.get() + ")");
            throw new RuntimeException("Circuit breaker activated: Method compilation disabled due to repeated failures");
        }
        Function<Object, Object> lambda = this.lambdaCache.get(cacheKey);
        MethodHandle handle = this.methodHandleCache.get(cacheKey);
        if (lambda != null) {
            return target -> lambda.apply(target);
        }
        if (handle != null) {
            return target -> {
                try {
                    return handle.invoke(target);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Method invocation failed", e);
                }
            };
        }
        int attempts = 0;
        boolean compiled = false;
        long startTime = System.currentTimeMillis();
        while (attempts < 3 && !compiled) {
            ++attempts;
            if (System.currentTimeMillis() - startTime > 5000L) {
                LOGGER.error("Method compilation timeout for {} after {} attempts", (Object)cacheKey, (Object)attempts);
                break;
            }
            if (attempts > 1) {
                long backoffMs = (long)(Math.pow(2.0, attempts - 1) * 100.0 + Math.random() * 100.0);
                try {
                    Thread.sleep(backoffMs);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    LOGGER.warn("Compilation retry interrupted for {}", (Object)cacheKey);
                    break;
                }
            }
            try {
                boolean compilationSuccess = this.compileMethod(className, signature);
                if (compilationSuccess && (this.lambdaCache.containsKey(cacheKey) || this.methodHandleCache.containsKey(cacheKey))) {
                    compiled = true;
                    LOGGER.info("Method compilation successful for {} (attempt {})", (Object)cacheKey, (Object)attempts);
                    continue;
                }
                this.compilationErrors.incrementAndGet();
                LOGGER.warn("Method compilation failed for {}: compilation returned {}, cache contains: lambda={}, handle={} (attempt {})", new Object[]{cacheKey, compilationSuccess, this.lambdaCache.containsKey(cacheKey), this.methodHandleCache.containsKey(cacheKey), attempts});
            }
            catch (Exception e) {
                this.compilationErrors.incrementAndGet();
                this.compilationFailures.incrementAndGet();
                LOGGER.error("Method compilation attempt {} failed for {}: {}", new Object[]{attempts, cacheKey, e.getMessage(), e});
            }
            catch (Error e) {
                this.compilationErrors.incrementAndGet();
                this.compilationFailures.incrementAndGet();
                LOGGER.error("Method compilation attempt {} failed with critical error for {}: {}", new Object[]{attempts, cacheKey, e.getMessage(), e});
                if (!(e instanceof NoClassDefFoundError) && !(e instanceof LinkageError)) continue;
                LOGGER.error("Breaking retry loop due to unrecoverable error: {}", (Object)e.getClass().getSimpleName());
                break;
            }
        }
        if (!compiled) {
            this.compilationFailures.incrementAndGet();
            throw new RuntimeException("Failed to compile method after " + attempts + " attempts: " + cacheKey);
        }
        Function<Object, Object> finalLambda = this.lambdaCache.get(cacheKey);
        MethodHandle finalHandle = this.methodHandleCache.get(cacheKey);
        if (finalLambda != null) {
            return target -> finalLambda.apply(target);
        }
        if (finalHandle != null) {
            return target -> {
                try {
                    return finalHandle.invoke(target);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Method invocation failed", e);
                }
            };
        }
        throw new RuntimeException("Unexpected error: method compiled but not cached: " + cacheKey);
    }

    public String getPerformanceStats() {
        long total = this.cacheHits.get() + this.cacheMisses.get();
        double hitRate = total > 0L ? (double)this.cacheHits.get() / (double)total * 100.0 : 0.0;
        return String.format("CompileTimeMethodResolver Stats:\nCache Hits: %d\nCache Misses: %d\nHit Rate: %.2f%%\nReflection Fallbacks: %d\nCompilation Errors: %d\nCompilation Failures: %d\nCached Methods: %d\nCached Lambdas: %d\n", this.cacheHits.get(), this.cacheMisses.get(), hitRate, this.reflectionFallbacks.get(), this.compilationErrors.get(), this.compilationFailures.get(), this.methodHandleCache.size(), this.lambdaCache.size());
    }

    public void clearCaches() {
        this.methodHandleCache.clear();
        this.callSiteCache.clear();
        this.lambdaCache.clear();
        this.cacheHits.set(0L);
        this.cacheMisses.set(0L);
        this.reflectionFallbacks.set(0L);
        this.compilationErrors.set(0L);
        this.compilationFailures.set(0L);
    }

    public <T> void benchmarkMethod(T target, String className, MethodSignature signature, int iterations) {
        LOGGER.info("Benchmarking method: {}.{}", (Object)className, (Object)signature.getMethodName());
        for (int i = 0; i < 1000; ++i) {
            try {
                this.invokeMethod(target, className, signature);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        long startTime = System.nanoTime();
        for (int i = 0; i < iterations; ++i) {
            try {
                this.invokeMethod(target, className, signature);
                continue;
            }
            catch (Throwable e) {
                LOGGER.warn("Benchmark invocation failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        long compiledTime = System.nanoTime() - startTime;
        startTime = System.nanoTime();
        for (int i = 0; i < iterations; ++i) {
            try {
                this.invokeWithReflection(target, className, signature);
                continue;
            }
            catch (Throwable e) {
                LOGGER.warn("Reflection benchmark failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        long reflectionTime = System.nanoTime() - startTime;
        LOGGER.info("Results for {} invocations:", (Object)iterations);
        LOGGER.info("Compiled method time: {} ms", (Object)(compiledTime / 1000000L));
        LOGGER.info("Reflection time: {} ms", (Object)(reflectionTime / 1000000L));
        LOGGER.info("Speedup: {}x", (Object)String.format("%.2f", (double)reflectionTime / (double)compiledTime));
    }

    public static enum MethodSignature {
        GET_ID("getId", LONG_METHOD, new Class[0]),
        GET_POSITION("getPosition", MethodType.methodType(float[].class), new Class[0]),
        GET_BOUNDS("getBounds", MethodType.methodType(float[].class), new Class[0]),
        IS_ALIVE("isAlive", BOOLEAN_METHOD, new Class[0]),
        GET_TYPE("getType", MethodType.methodType(String.class), new Class[0]),
        GET_BLOCK_ID("getBlockId", INT_METHOD, new Class[0]),
        GET_BLOCK_STATE("getBlockState", INT_METHOD, new Class[0]),
        GET_BLOCK_METADATA("getBlockMetadata", INT_METHOD, new Class[0]),
        IS_BLOCK_SOLID("isSolid", BOOLEAN_METHOD, new Class[0]),
        GET_BLOCK_HARDNESS("getHardness", FLOAT_METHOD, new Class[0]),
        GET_WORLD_TIME("getWorldTime", LONG_METHOD, new Class[0]),
        GET_CHUNK_AT("getChunkAt", MethodType.methodType(Object.class, Integer.TYPE, Integer.TYPE), new Class[0]),
        GET_BLOCK_AT("getBlockAt", MethodType.methodType(Object.class, Integer.TYPE, Integer.TYPE, Integer.TYPE), new Class[0]),
        SET_BLOCK_AT("setBlockAt", VOID_METHOD, Integer.TYPE, Integer.TYPE, Integer.TYPE, Object.class),
        GET_PLAYER_NAME("getName", MethodType.methodType(String.class), new Class[0]),
        GET_PLAYER_UUID("getUniqueId", MethodType.methodType(String.class), new Class[0]),
        GET_PLAYER_POSITION("getPosition", MethodType.methodType(double[].class), new Class[0]),
        GET_PLAYER_HEALTH("getHealth", FLOAT_METHOD, new Class[0]),
        SET_PLAYER_HEALTH("setHealth", VOID_METHOD, Float.TYPE),
        GET_ITEM_ID("getItemId", INT_METHOD, new Class[0]),
        GET_ITEM_COUNT("getCount", INT_METHOD, new Class[0]),
        GET_ITEM_DAMAGE("getDamage", INT_METHOD, new Class[0]),
        GET_ITEM_NBT("getNbt", MethodType.methodType(Object.class), new Class[0]),
        TO_STRING("toString", MethodType.methodType(String.class), new Class[0]),
        HASH_CODE("hashCode", INT_METHOD, new Class[0]),
        EQUALS("equals", BOOLEAN_METHOD, Object.class),
        GET_CLASS("getClass", MethodType.methodType(Class.class), new Class[0]);

        private final String methodName;
        private final MethodType methodType;
        private final Class<?>[] parameterTypes;

        private MethodSignature(String methodName, MethodType methodType, Class<?> ... parameterTypes) {
            this.methodName = methodName;
            this.methodType = methodType;
            this.parameterTypes = parameterTypes;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public MethodType getMethodType() {
            return this.methodType;
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }
    }

    public static interface MethodCall<T, R> {
        public R invoke(T var1) throws Throwable;
    }

    public static interface MethodCallWithParams<T, R> {
        public R invoke(T var1, Object ... var2) throws Throwable;
    }
}

