/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.core;

import com.kneaf.core.KneafCore;
import com.kneaf.core.binary.ManualSerializers;
import com.kneaf.core.data.block.BlockEntityData;
import com.kneaf.core.data.entity.EntityData;
import com.kneaf.core.data.entity.MobData;
import com.kneaf.core.data.entity.PlayerData;
import com.kneaf.core.data.entity.VillagerData;
import com.kneaf.core.data.item.ItemEntityData;
import com.kneaf.core.performance.bridge.NativeBridge;
import com.kneaf.core.performance.core.ArrayListPool;
import com.kneaf.core.performance.core.EntityFlyweightFactory;
import com.kneaf.core.performance.core.HashMapPool;
import com.kneaf.core.performance.core.ItemProcessResult;
import com.kneaf.core.performance.core.MobProcessResult;
import com.kneaf.core.performance.core.NativeBridgeProvider;
import com.kneaf.core.performance.core.PerformanceMonitor;
import com.kneaf.core.performance.core.PerformanceProcessor;
import com.kneaf.core.performance.core.PerformanceUtils;
import com.kneaf.core.performance.monitoring.PerformanceManager;
import com.kneaf.core.protocol.core.EnhancedProtocolProcessor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class EntityProcessor {
    private final EnhancedProtocolProcessor protocolProcessor;
    private final PerformanceMonitor monitor;
    private final NativeBridgeProvider bridgeProvider;
    private long tickCount = 0L;
    private final ArrayListPool<Long> longListPool = new ArrayListPool();
    private final ArrayListPool<PerformanceProcessor.ItemUpdate> itemUpdatePool = new ArrayListPool();
    private final ArrayListPool<List<?>> listPool = new ArrayListPool();
    private final HashMapPool<String, Object> mapPool = new HashMapPool();
    private final EntityFlyweightFactory flyweightFactory = new EntityFlyweightFactory();
    private static final int STANDARD_ENTITY_LIST_SIZE = 256;
    private static final int STANDARD_PLAYER_LIST_SIZE = 64;
    private static final int STANDARD_CONFIG_MAP_SIZE = 32;
    private static final int STANDARD_WORLD_BOUNDS_SIZE = 16;
    private static final int STANDARD_PROCESSING_PARAMS_SIZE = 16;
    private static final int MAX_POOL_SIZE = 100;

    public EntityProcessor(NativeBridgeProvider bridgeProvider, PerformanceMonitor monitor) {
        this.bridgeProvider = bridgeProvider;
        this.monitor = monitor;
        this.protocolProcessor = EnhancedProtocolProcessor.createDefault();
    }

    public List<Long> processEntities(List<EntityData> entities, List<PlayerData> players) {
        long startTime = System.currentTimeMillis();
        try {
            EnhancedProtocolProcessor.ProtocolResult<ArrayList<Long>> result = this.protocolProcessor.processWithFallback(new EntityInput(entities, players), "Entity processing", new EnhancedProtocolProcessor.BinarySerializer<EntityInput>(){

                @Override
                public ByteBuffer serialize(EntityInput input) throws Exception {
                    return ManualSerializers.serializeEntityInput(EntityProcessor.this.tickCount++, input.entities, input.players);
                }
            }, new EnhancedProtocolProcessor.BinaryNativeCaller<byte[]>(){

                @Override
                public byte[] callNative(ByteBuffer inputBuffer) throws Exception {
                    return EntityProcessor.this.bridgeProvider.processEntitiesBinary(inputBuffer);
                }
            }, new EnhancedProtocolProcessor.BinaryDeserializer<List<Long>>(){

                @Override
                public List<Long> deserialize(byte[] resultBytes) throws Exception {
                    if (resultBytes != null) {
                        return PerformanceUtils.parseEntityResultWithFallback(resultBytes);
                    }
                    return EntityProcessor.this.longListPool.acquire();
                }
            }, new EnhancedProtocolProcessor.JsonInputPreparer<EntityInput>(){

                @Override
                public Map<String, Object> prepareInput(EntityInput jsonInput) {
                    return EntityProcessor.this.prepareEntityJsonInput(jsonInput);
                }
            }, new EnhancedProtocolProcessor.JsonNativeCaller<String>(){

                @Override
                public String callNative(String jsonInput) throws Exception {
                    return EntityProcessor.this.bridgeProvider.processEntitiesJson(jsonInput);
                }
            }, new EnhancedProtocolProcessor.JsonResultParser<List<Long>>(this){

                @Override
                public List<Long> parseResult(String jsonResult) throws Exception {
                    return PerformanceUtils.parseEntityResultFromJson(jsonResult);
                }
            }, this.longListPool.acquire());
            List processedEntities = result.getDataOrThrow();
            this.monitor.recordEntityProcessing(processedEntities.size(), System.currentTimeMillis() - startTime);
            return processedEntities;
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error processing entities", (Throwable)e);
            return this.longListPool.acquire();
        }
    }

    public List<Long> processEntitiesBatched(List<EntityData> entities, List<PlayerData> players) {
        long startTime = System.currentTimeMillis();
        try {
            ByteBuffer inputBuffer = ManualSerializers.serializeEntityInput(this.tickCount++, entities, players);
            byte[] payload = new byte[inputBuffer.remaining()];
            inputBuffer.get(payload);
            NativeBridge.bufferEntityOperation(payload);
            ArrayList<Long> result = this.longListPool.acquire();
            for (EntityData entity : entities) {
                result.add(entity.getId());
            }
            this.monitor.recordEntityProcessing(result.size(), System.currentTimeMillis() - startTime);
            return result;
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error in batched entity processing", (Throwable)e);
            return this.processEntities(entities, players);
        }
    }

    public void flushEntityBatch() {
        long startTime = System.currentTimeMillis();
        try {
            NativeBridge.forceFlushEntityBatch();
            int batchSize = NativeBridge.getEntityBatchBufferSize();
            if (batchSize > 0) {
                this.monitor.recordEntityProcessing(batchSize, System.currentTimeMillis() - startTime);
                KneafCore.LOGGER.debug("Flushed entity batch of {} operations", (Object)batchSize);
            }
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error flushing entity batch", (Throwable)e);
        }
    }

    public int getEntityBatchBufferSize() {
        return NativeBridge.getEntityBatchBufferSize();
    }

    private Map<String, Object> prepareEntityJsonInput(EntityInput input) {
        HashMap<String, Object> jsonInput = this.mapPool.acquire();
        jsonInput.put("tickCount", this.tickCount++);
        jsonInput.put("entities", input.entities);
        jsonInput.put("players", input.players);
        Map<String, Object> config = this.flyweightFactory.getEntityConfig();
        config.clear();
        config.put("closeRadius", this.getCloseRadius());
        config.put("mediumRadius", this.getMediumRadius());
        config.put("closeRate", this.getCloseRate());
        config.put("mediumRate", this.getMediumRate());
        config.put("farRate", this.getFarRate());
        config.put("useSpatialPartitioning", this.isSpatialPartitioningEnabled());
        Map<String, Object> worldBounds = this.flyweightFactory.getWorldBounds();
        worldBounds.clear();
        worldBounds.put("minX", -1000.0);
        worldBounds.put("minY", 0.0);
        worldBounds.put("minZ", -1000.0);
        worldBounds.put("maxX", 1000.0);
        worldBounds.put("maxY", 256.0);
        worldBounds.put("maxZ", 1000.0);
        config.put("worldBounds", worldBounds);
        Map<String, Object> defaultProps = this.flyweightFactory.getDefaultEntityProperties();
        defaultProps.clear();
        defaultProps.put("gravity", 0.08);
        defaultProps.put("friction", 0.2);
        defaultProps.put("collisionRadius", 0.5);
        config.put("defaultProperties", defaultProps);
        config.put("quadtreeMaxEntities", this.getQuadtreeMaxEntities());
        config.put("quadtreeMaxDepth", this.getQuadtreeMaxDepth());
        jsonInput.put("entityConfig", config);
        return jsonInput;
    }

    private double getCloseRadius() {
        double tps = PerformanceManager.getAverageTPS();
        return Math.max(8.0, 16.0 * (tps / 20.0));
    }

    private double getMediumRadius() {
        double tps = PerformanceManager.getAverageTPS();
        return Math.max(16.0, 32.0 * (tps / 20.0));
    }

    private double getCloseRate() {
        double tps = PerformanceManager.getAverageTPS();
        return Math.max(0.2, Math.min(1.0, tps / 20.0));
    }

    private double getMediumRate() {
        double tps = PerformanceManager.getAverageTPS();
        return Math.max(0.1, Math.min(0.8, tps / 20.0 * 0.5));
    }

    private double getFarRate() {
        double tps = PerformanceManager.getAverageTPS();
        return Math.max(0.05, Math.min(0.5, (20.0 - tps) / 20.0 * 0.2 + 0.1));
    }

    private boolean isSpatialPartitioningEnabled() {
        double tps = PerformanceManager.getAverageTPS();
        return tps >= 12.0;
    }

    private int getQuadtreeMaxEntities() {
        double tps = PerformanceManager.getAverageTPS();
        int base = 1000;
        double factor = Math.max(0.5, Math.min(1.5, tps / 20.0));
        return Math.max(100, (int)((double)base * factor));
    }

    private int getQuadtreeMaxDepth() {
        double tps = PerformanceManager.getAverageTPS();
        return tps > 18.0 ? 10 : (tps > 14.0 ? 8 : 6);
    }

    public void processEntityBatchOptimized(List<BatchRequest> batch) throws Exception {
        if (batch.isEmpty()) {
            return;
        }
        int totalEntities = 0;
        int totalPlayers = 0;
        for (BatchRequest req : batch) {
            EntityInput input = (EntityInput)req.data;
            totalEntities += input.entities.size();
            totalPlayers += input.players.size();
        }
        ArrayList<EntityData> allEntities = new ArrayList<EntityData>(totalEntities);
        ArrayList<PlayerData> allPlayers = new ArrayList<PlayerData>(totalPlayers);
        for (BatchRequest req : batch) {
            EntityInput input = (EntityInput)req.data;
            allEntities.addAll(input.entities);
            allPlayers.addAll(input.players);
        }
        List<Long> results = this.processEntities(allEntities, allPlayers);
        HashSet<Long> resultSet = new HashSet<Long>(results);
        for (BatchRequest req : batch) {
            EntityInput input = (EntityInput)req.data;
            ArrayList<Long> requestResults = this.longListPool.acquire();
            for (EntityData entity : input.entities) {
                if (!resultSet.contains(entity.getId())) continue;
                requestResults.add(entity.getId());
            }
            req.future.complete(requestResults);
        }
    }

    public ItemProcessResult processItemEntities(List<ItemEntityData> items) {
        long startTime = System.currentTimeMillis();
        try {
            EnhancedProtocolProcessor.ProtocolResult<ItemProcessResult> result = this.protocolProcessor.processWithFallback(items, "Item processing", new EnhancedProtocolProcessor.BinarySerializer<List<ItemEntityData>>(){

                @Override
                public ByteBuffer serialize(List<ItemEntityData> input) throws Exception {
                    return ManualSerializers.serializeItemInput(EntityProcessor.this.tickCount, input);
                }
            }, new EnhancedProtocolProcessor.BinaryNativeCaller<byte[]>(){

                @Override
                public byte[] callNative(ByteBuffer inputBuffer) throws Exception {
                    return EntityProcessor.this.bridgeProvider.processItemEntitiesBinary(inputBuffer);
                }
            }, new EnhancedProtocolProcessor.BinaryDeserializer<ItemProcessResult>(){

                @Override
                public ItemProcessResult deserialize(byte[] resultBytes) throws Exception {
                    if (resultBytes != null) {
                        ByteBuffer resultBuffer = ByteBuffer.wrap(resultBytes);
                        List<ItemEntityData> updatedItems = ManualSerializers.deserializeItemProcessResult(resultBuffer);
                        ArrayList<Long> removeList = EntityProcessor.this.longListPool.acquire();
                        ArrayList<PerformanceProcessor.ItemUpdate> updates = EntityProcessor.this.itemUpdatePool.acquire();
                        for (ItemEntityData item : updatedItems) {
                            if (item.getCount() == 0) {
                                removeList.add(item.getId());
                                continue;
                            }
                            updates.add(new PerformanceProcessor.ItemUpdate(item.getId(), item.getCount()));
                        }
                        return new ItemProcessResult(removeList, updates.size(), removeList.size(), updates);
                    }
                    return new ItemProcessResult(new ArrayList<Long>(), 0L, 0L, new ArrayList<PerformanceProcessor.ItemUpdate>());
                }
            }, new EnhancedProtocolProcessor.JsonInputPreparer<List<ItemEntityData>>(){

                @Override
                public Map<String, Object> prepareInput(List<ItemEntityData> jsonInput) {
                    HashMap<String, Object> input = new HashMap<String, Object>();
                    input.put("items", jsonInput);
                    input.put("tickCount", EntityProcessor.this.tickCount++);
                    return input;
                }
            }, new EnhancedProtocolProcessor.JsonNativeCaller<String>(){

                @Override
                public String callNative(String jsonInput) throws Exception {
                    return EntityProcessor.this.bridgeProvider.processItemEntitiesJson(jsonInput);
                }
            }, new EnhancedProtocolProcessor.JsonResultParser<ItemProcessResult>(){

                @Override
                public ItemProcessResult parseResult(String jsonResult) throws Exception {
                    PerformanceUtils.ItemParseResult parseResult = PerformanceUtils.parseItemResultFromJson(jsonResult);
                    ArrayList<PerformanceProcessor.ItemUpdate> updates = EntityProcessor.this.itemUpdatePool.acquire();
                    for (PerformanceUtils.ItemUpdateParseResult update : parseResult.getItemUpdates()) {
                        updates.add(new PerformanceProcessor.ItemUpdate(update.getId(), update.getNewCount()));
                    }
                    return new ItemProcessResult(parseResult.getItemsToRemove(), parseResult.getMergedCount(), parseResult.getDespawnedCount(), updates);
                }
            }, new ItemProcessResult(new ArrayList<Long>(), 0L, 0L, new ArrayList<PerformanceProcessor.ItemUpdate>()));
            ItemProcessResult processedItems = result.getDataOrThrow();
            this.monitor.recordItemProcessing(items.size(), processedItems.getMergedCount(), processedItems.getDespawnedCount(), System.currentTimeMillis() - startTime);
            return processedItems;
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error processing item entities", (Throwable)e);
            this.monitor.recordItemProcessing(items.size(), 0L, 0L, System.currentTimeMillis() - startTime);
            return new ItemProcessResult(new ArrayList<Long>(), 0L, 0L, new ArrayList<PerformanceProcessor.ItemUpdate>());
        }
    }

    public MobProcessResult processMobAI(List<MobData> mobs) {
        long startTime = System.currentTimeMillis();
        try {
            EnhancedProtocolProcessor.ProtocolResult<MobProcessResult> result = this.protocolProcessor.processWithFallback(mobs, "Mob processing", new EnhancedProtocolProcessor.BinarySerializer<List<MobData>>(){

                @Override
                public ByteBuffer serialize(List<MobData> input) throws Exception {
                    return ManualSerializers.serializeMobInput(EntityProcessor.this.tickCount, input);
                }
            }, new EnhancedProtocolProcessor.BinaryNativeCaller<byte[]>(){

                @Override
                public byte[] callNative(ByteBuffer inputBuffer) throws Exception {
                    return EntityProcessor.this.bridgeProvider.processMobAiBinary(inputBuffer);
                }
            }, new EnhancedProtocolProcessor.BinaryDeserializer<MobProcessResult>(){

                @Override
                public MobProcessResult deserialize(byte[] resultBytes) throws Exception {
                    if (resultBytes != null) {
                        ByteBuffer resultBuffer = ByteBuffer.wrap(resultBytes).order(ByteOrder.LITTLE_ENDIAN);
                        List<MobData> updatedMobs = ManualSerializers.deserializeMobProcessResult(resultBuffer);
                        ArrayList<Long> simplifyList = EntityProcessor.this.longListPool.acquire();
                        for (MobData mob : updatedMobs) {
                            simplifyList.add(mob.getId());
                        }
                        return new MobProcessResult(new ArrayList<Long>(), simplifyList);
                    }
                    return new MobProcessResult(new ArrayList<Long>(), new ArrayList<Long>());
                }
            }, new EnhancedProtocolProcessor.JsonInputPreparer<List<MobData>>(){

                @Override
                public Map<String, Object> prepareInput(List<MobData> jsonInput) {
                    HashMap<String, Object> input = new HashMap<String, Object>();
                    input.put("mobs", jsonInput);
                    input.put("tickCount", EntityProcessor.this.tickCount++);
                    return input;
                }
            }, new EnhancedProtocolProcessor.JsonNativeCaller<String>(){

                @Override
                public String callNative(String jsonInput) throws Exception {
                    return EntityProcessor.this.bridgeProvider.processMobAiJson(jsonInput);
                }
            }, new EnhancedProtocolProcessor.JsonResultParser<MobProcessResult>(this){

                @Override
                public MobProcessResult parseResult(String jsonResult) throws Exception {
                    PerformanceUtils.MobParseResult parseResult = PerformanceUtils.parseMobResultFromJson(jsonResult);
                    return new MobProcessResult(parseResult.getDisableList(), parseResult.getSimplifyList());
                }
            }, new MobProcessResult(new ArrayList<Long>(), new ArrayList<Long>()));
            MobProcessResult processedMobs = result.getDataOrThrow();
            this.monitor.recordMobProcessing(mobs.size(), processedMobs.getDisableList().size(), processedMobs.getSimplifyList().size(), System.currentTimeMillis() - startTime);
            return processedMobs;
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error processing mob AI", (Throwable)e);
            this.monitor.recordMobProcessing(mobs.size(), 0, 0, System.currentTimeMillis() - startTime);
            return new MobProcessResult(new ArrayList<Long>(), new ArrayList<Long>());
        }
    }

    public List<Long> processVillagerAI(final List<VillagerData> villagers) {
        long startTime = System.currentTimeMillis();
        try {
            EnhancedProtocolProcessor.ProtocolResult result = this.protocolProcessor.processWithFallback(villagers, "Villager processing", new EnhancedProtocolProcessor.BinarySerializer<List<VillagerData>>(){

                @Override
                public ByteBuffer serialize(List<VillagerData> input) throws Exception {
                    return ManualSerializers.serializeVillagerInput(EntityProcessor.this.tickCount, input);
                }
            }, new EnhancedProtocolProcessor.BinaryNativeCaller<byte[]>(){

                @Override
                public byte[] callNative(ByteBuffer inputBuffer) throws Exception {
                    return EntityProcessor.this.bridgeProvider.processVillagerAiBinary(inputBuffer);
                }
            }, new EnhancedProtocolProcessor.BinaryDeserializer<List<Long>>(){

                @Override
                public List<Long> deserialize(byte[] resultBytes) throws Exception {
                    if (resultBytes != null) {
                        ArrayList<Long> simplifyList = new ArrayList<Long>();
                        for (VillagerData villager : villagers) {
                            simplifyList.add(Long.valueOf(villager.hashCode()));
                        }
                        return simplifyList;
                    }
                    return new ArrayList<Long>();
                }
            }, new EnhancedProtocolProcessor.JsonInputPreparer<List<VillagerData>>(){

                @Override
                public Map<String, Object> prepareInput(List<VillagerData> jsonInput) {
                    HashMap<String, Object> input = new HashMap<String, Object>();
                    input.put("villagers", jsonInput);
                    input.put("tickCount", EntityProcessor.this.tickCount++);
                    return input;
                }
            }, new EnhancedProtocolProcessor.JsonNativeCaller<String>(){

                @Override
                public String callNative(String jsonInput) throws Exception {
                    return EntityProcessor.this.bridgeProvider.processVillagerAiJson(jsonInput);
                }
            }, new EnhancedProtocolProcessor.JsonResultParser<List<Long>>(){

                @Override
                public List<Long> parseResult(String jsonResult) throws Exception {
                    ArrayList<Long> result = EntityProcessor.this.longListPool.acquire();
                    for (VillagerData villager : villagers) {
                        result.add(Long.valueOf(villager.hashCode()));
                    }
                    return result;
                }
            }, new ArrayList());
            List processedVillagers = result.getDataOrThrow();
            this.monitor.recordVillagerProcessing(villagers.size(), 0, processedVillagers.size(), 0, System.currentTimeMillis() - startTime);
            return processedVillagers;
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error processing villager AI", (Throwable)e);
            ArrayList<Long> fallback = this.longListPool.acquire();
            for (VillagerData villager : villagers) {
                fallback.add(Long.valueOf(villager.hashCode()));
            }
            this.monitor.recordVillagerProcessing(villagers.size(), 0, fallback.size(), 0, System.currentTimeMillis() - startTime);
            return fallback;
        }
    }

    public List<Long> getBlockEntitiesToTick(final List<BlockEntityData> blockEntities) {
        long startTime = System.currentTimeMillis();
        try {
            EnhancedProtocolProcessor.ProtocolResult result = this.protocolProcessor.processWithFallback(blockEntities, "Block processing", new EnhancedProtocolProcessor.BinarySerializer<List<BlockEntityData>>(){

                @Override
                public ByteBuffer serialize(List<BlockEntityData> input) throws Exception {
                    return ManualSerializers.serializeBlockInput(EntityProcessor.this.tickCount++, input);
                }
            }, new EnhancedProtocolProcessor.BinaryNativeCaller<byte[]>(){

                @Override
                public byte[] callNative(ByteBuffer inputBuffer) throws Exception {
                    return EntityProcessor.this.bridgeProvider.processBlockEntitiesBinary(inputBuffer);
                }
            }, new EnhancedProtocolProcessor.BinaryDeserializer<List<Long>>(){

                @Override
                public List<Long> deserialize(byte[] resultBytes) throws Exception {
                    if (resultBytes != null) {
                        ArrayList<Long> resultList = EntityProcessor.this.longListPool.acquire();
                        for (BlockEntityData block : blockEntities) {
                            resultList.add(block.getId());
                        }
                        return resultList;
                    }
                    return new ArrayList<Long>();
                }
            }, new EnhancedProtocolProcessor.JsonInputPreparer<List<BlockEntityData>>(){

                @Override
                public Map<String, Object> prepareInput(List<BlockEntityData> jsonInput) {
                    HashMap<String, Object> input = new HashMap<String, Object>();
                    input.put("tickCount", EntityProcessor.this.tickCount++);
                    input.put("block_entities", jsonInput);
                    return input;
                }
            }, new EnhancedProtocolProcessor.JsonNativeCaller<String>(){

                @Override
                public String callNative(String jsonInput) throws Exception {
                    return EntityProcessor.this.bridgeProvider.processBlockEntitiesJson(jsonInput);
                }
            }, new EnhancedProtocolProcessor.JsonResultParser<List<Long>>(this){

                @Override
                public List<Long> parseResult(String jsonResult) throws Exception {
                    return PerformanceUtils.parseBlockResultFromJson(jsonResult);
                }
            }, new ArrayList());
            List processedBlocks = result.getDataOrThrow();
            this.monitor.recordBlockProcessing(processedBlocks.size(), System.currentTimeMillis() - startTime);
            return processedBlocks;
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error processing block entities", (Throwable)e);
            ArrayList<Long> all = this.longListPool.acquire();
            for (BlockEntityData block : blockEntities) {
                all.add(block.getId());
            }
            this.monitor.recordBlockProcessing(all.size(), System.currentTimeMillis() - startTime);
            return all;
        }
    }

    public static class EntityInput {
        public final List<EntityData> entities;
        public final List<PlayerData> players;

        public EntityInput(List<EntityData> entities, List<PlayerData> players) {
            this.entities = entities;
            this.players = players;
        }
    }

    public static class BatchRequest {
        public final String type;
        public final Object data;
        public final CompletableFuture<Object> future;

        public BatchRequest(String type, Object data, CompletableFuture<Object> future) {
            this.type = type;
            this.data = data;
            this.future = future;
        }
    }
}

