/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.core;

import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class HashMapPool<K, V> {
    private final Queue<HashMap<K, V>> pool = new ConcurrentLinkedQueue<HashMap<K, V>>();
    private final int initialCapacity;

    public HashMapPool() {
        this(16);
    }

    public HashMapPool(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public HashMap<K, V> acquire() {
        HashMap<K, V> map = this.pool.poll();
        if (map == null) {
            map = new HashMap(this.initialCapacity);
        } else {
            map.clear();
        }
        return map;
    }

    public void release(HashMap<K, V> map) {
        if (map != null && this.pool.size() < 100) {
            this.pool.offer(map);
        }
    }
}

