/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.protocol.core;

import java.util.Map;

public class ProtocolException
extends Exception {
    private final int errorCode;
    private final String protocolFormat;
    private final String traceId;
    private final Map<String, Object> context;

    public ProtocolException(String message, int errorCode, String protocolFormat, String traceId) {
        super(message);
        this.errorCode = errorCode;
        this.protocolFormat = protocolFormat;
        this.traceId = traceId;
        this.context = Map.of();
    }

    public ProtocolException(String message, Throwable cause, int errorCode, String protocolFormat, String traceId) {
        super(message, cause);
        this.errorCode = errorCode;
        this.protocolFormat = protocolFormat;
        this.traceId = traceId;
        this.context = Map.of();
    }

    public ProtocolException(String message, int errorCode, String protocolFormat, String traceId, Map<String, Object> context) {
        super(message);
        this.errorCode = errorCode;
        this.protocolFormat = protocolFormat;
        this.traceId = traceId;
        this.context = Map.copyOf(context);
    }

    public ProtocolException(String message, Throwable cause, int errorCode, String protocolFormat, String traceId, Map<String, Object> context) {
        super(message, cause);
        this.errorCode = errorCode;
        this.protocolFormat = protocolFormat;
        this.traceId = traceId;
        this.context = Map.copyOf(context);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getProtocolFormat() {
        return this.protocolFormat;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public static ProtocolException validationFailed(String message, String protocolFormat, String traceId) {
        return new ProtocolException(message, 1001, protocolFormat, traceId);
    }

    public static ProtocolException unsupportedFormat(String format, String traceId) {
        return new ProtocolException("Unsupported protocol format: " + format, 1002, format, traceId);
    }

    public static ProtocolException versionMismatch(String expectedVersion, String actualVersion, String traceId) {
        return new ProtocolException(String.format("Protocol version mismatch. Expected: %s, Actual: %s", expectedVersion, actualVersion), 1003, null, traceId);
    }

    public static ProtocolException sizeExceeded(int actualSize, int maxSize, String traceId) {
        return new ProtocolException(String.format("Data size exceeded limit. Size: %d, Max: %d", actualSize, maxSize), 1004, null, traceId);
    }

    public static ProtocolException integrityFailed(String message, String traceId) {
        return new ProtocolException(message, 1005, null, traceId);
    }

    public static ProtocolException timeout(String operation, long timeoutMs, String traceId) {
        return new ProtocolException(String.format("Operation '%s' timed out after %d ms", operation, timeoutMs), 1006, null, traceId);
    }

    public static ProtocolException nativeFailed(String message, Throwable cause, String traceId) {
        return new ProtocolException(message, cause, 1007, null, traceId);
    }

    public static ProtocolException serializationFailed(String message, Throwable cause, String protocolFormat, String traceId) {
        return new ProtocolException(message, cause, 1008, protocolFormat, traceId);
    }
}

