/*
 * Decompiled with CFR 0.152.
 */
package dev.fernaerell.aerellcrafter.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CrafterBlock.class})
abstract class CrafterBlockMixin {
    CrafterBlockMixin() {
    }

    @Unique
    private boolean aerellcrafter$isTemplatedOrEmpty(Level world, BlockPos pos) {
        CrafterBlockEntity crafterBlockEntity;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity instanceof CrafterBlockEntity && ((crafterBlockEntity = (CrafterBlockEntity)blockEntity).isEmpty() || crafterBlockEntity.getItems().stream().anyMatch(itemStack -> itemStack.getCount() == 1));
    }

    @Inject(method={"neighborChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void neighborChangedInject(BlockState state, Level world, BlockPos pos, Block sourceBlock, Orientation wireOrientation, boolean notify, CallbackInfo ci) {
        if (this.aerellcrafter$isTemplatedOrEmpty(world, pos) && !((Boolean)world.getBlockState(pos).getValue((Property)CrafterBlock.TRIGGERED)).booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"dispenseFrom"}, at={@At(value="HEAD")}, cancellable=true)
    private void dispenseFromInject(BlockState state, ServerLevel world, BlockPos pos, CallbackInfo ci) {
        if (this.aerellcrafter$isTemplatedOrEmpty((Level)world, pos)) {
            ci.cancel();
        }
    }
}

