#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#
#                      DATAPACK INFO                     #
# ------------------------------------------------------ #
#     Author: GenMode                                    #
#     URL: https://github.com/GenMode/Minecraft/wiki     #
#                                                        #
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#

# Initialize
$data modify storage gamerule:private gamerule.set set value "$(set)"

# Validate
execute if data storage gamerule:private gamerule{set: "-1"} run data modify storage gamerule:private gamerule.set set value "blocks"
execute if data storage gamerule:private gamerule{set: "0"} run data modify storage gamerule:private gamerule.set set value "blocks_and_entities"
execute if data storage gamerule:private gamerule{set: "1"} run data modify storage gamerule:private gamerule.set set value "entities"
execute if data storage gamerule:private gamerule{set: "default"} run data modify storage gamerule:private gamerule.set set value "reset"
execute unless data storage gamerule:private gamerule{set: "reset"} \
    unless data storage gamerule:private gamerule{set: "blocks"} \
    unless data storage gamerule:private gamerule{set: "blocks_and_entities"} \
    unless data storage gamerule:private gamerule{set: "entities"} \
    run data modify storage gamerule:private gamerule.set set value "feedback"

# Modify Score
execute unless data storage gamerule:private gamerule{set: "reset"} if data storage gamerule:private gamerule{set: "blocks"} run scoreboard players set *mode reader -1
execute unless data storage gamerule:private gamerule{set: "reset"} if data storage gamerule:private gamerule{set: "blocks_and_entities"} run scoreboard players set *mode reader 0
execute unless data storage gamerule:private gamerule{set: "reset"} if data storage gamerule:private gamerule{set: "entities"} run scoreboard players set *mode reader 1

# Settings (query)
execute unless data storage gamerule:private gamerule{set: "reset"} \
    if data storage gamerule:private gamerule{set: "feedback"} \
    if score *mode reader matches -1 \
    run tellraw @s {\
        color: "light_purple", \
        translate: "commands.gamerule.query", \
        with: ["reader/mode", "blocks"]}
execute unless data storage gamerule:private gamerule{set: "reset"} \
    if data storage gamerule:private gamerule{set: "feedback"} \
    if score *mode reader matches 0 \
    run tellraw @s {\
        color: "light_purple", \
        translate: "commands.gamerule.query", \
        with: ["reader/mode", "blocks_and_entities"]}
execute unless data storage gamerule:private gamerule{set: "reset"} \
    if data storage gamerule:private gamerule{set: "feedback"} \
    if score *mode reader matches 1 \
    run tellraw @s {\
        color: "light_purple", \
        translate: "commands.gamerule.query", \
        with: ["reader/mode", "entities"]}
# Settings (set)
execute unless data storage gamerule:private gamerule{set: "reset"} \
    if data storage gamerule:private gamerule{set: "blocks"} \
    run tellraw @s {\
        color: "light_purple", \
        translate: "commands.gamerule.set", \
        with: ["reader/mode", "blocks"]}
execute unless data storage gamerule:private gamerule{set: "reset"} \
    if data storage gamerule:private gamerule{set: "blocks_and_entities"} \
    run tellraw @s {\
        color: "light_purple", \
        translate: "commands.gamerule.set", \
        with: ["reader/mode", "blocks_and_entities"]}
        execute unless data storage gamerule:private gamerule{set: "reset"} \
    if data storage gamerule:private gamerule{set: "entities"} \
    run tellraw @s {\
        color: "light_purple", \
        translate: "commands.gamerule.set", \
        with: ["reader/mode", "entities"]}
# Settings (reset)
execute if data storage gamerule:private gamerule{set: "reset"} run function gamerule:reader/mode {set: "blocks_and_entities"}

# Close
execute as @a run function reader:entity/player/clear
data remove storage gamerule:private gamerule