/*
 * Decompiled with CFR 0.152.
 */
package net.funkpla.atlas_hud;

import com.mojang.blaze3d.systems.RenderSystem;
import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.WorldAtlasData;
import folk.sisby.surveyor.landmark.Landmark;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.math.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.funkpla.atlas_hud.AtlasHudConfig;
import net.funkpla.atlas_hud.AtlasMarker;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class CompassHudOverlay
implements HudRenderCallback {
    private static final class_6862<class_1792> COMPASS_ITEMS = class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)class_2960.method_60655((String)"atlas_hud", (String)"shows_compass_ribbon"));
    private final AtlasHudConfig config = (AtlasHudConfig)AutoConfig.getConfigHolder(AtlasHudConfig.class).getConfig();
    private int centerX;
    private int compassWidth;
    private int compassStartX;
    private int compassEndX;
    private int alpha;
    private float markerScale;
    private class_332 ctx;
    private class_327 font;
    private class_638 level;
    private class_1657 player;

    public void onHudRender(class_332 ctx, class_9779 deltaTracker) {
        class_310 client = class_310.method_1551();
        this.ctx = ctx;
        int windowWidth = ctx.method_51421();
        this.centerX = windowWidth / 2;
        this.compassWidth = (int)((double)windowWidth * ((double)this.config.CompassWidth / 100.0));
        this.compassStartX = this.centerX - this.compassWidth / 2;
        this.compassEndX = this.centerX + this.compassWidth / 2;
        Objects.requireNonNull(this.config);
        this.alpha = 100 * 255 / 100 << 24;
        Objects.requireNonNull(this.config);
        this.markerScale = 100.0f / 100.0f;
        this.font = client.field_1705.method_1756();
        this.player = client.field_1724;
        this.level = client.field_1687;
        this.renderBackground();
        this.renderMarkers();
        this.renderDirections();
    }

    private boolean shouldShowCompass() {
        return switch (this.config.DisplayRule) {
            case AtlasHudConfig.CompassDisplayRule.COMPASS_HELD -> this.isCompassHeld();
            case AtlasHudConfig.CompassDisplayRule.COMPASS_HOTBAR -> this.isCompassInHotbar();
            case AtlasHudConfig.CompassDisplayRule.COMPASS_INVENTORY -> this.isCompassInInventory();
            default -> true;
        };
    }

    private boolean isCompassHeld() {
        for (class_1799 hand : this.player.method_5877()) {
            if (!hand.method_31573(COMPASS_ITEMS)) continue;
            return true;
        }
        return false;
    }

    private boolean isCompassInHotbar() {
        return IntStream.range(0, class_1661.method_7368()).anyMatch(i -> ((class_1799)this.player.method_31548().field_7547.get(i)).method_31573(COMPASS_ITEMS)) || this.isCompassHeld();
    }

    private boolean isCompassInInventory() {
        if (this.player.method_31548().method_7382(COMPASS_ITEMS)) {
            return true;
        }
        return this.isCompassHeld();
    }

    private boolean shouldDrawBackground() {
        Objects.requireNonNull(this.config);
        return this.shouldShowCompass();
    }

    private boolean shouldDrawMarkers() {
        Objects.requireNonNull(this.config);
        return this.shouldShowCompass();
    }

    private boolean shouldDrawDirections() {
        Objects.requireNonNull(this.config);
        return this.shouldShowCompass();
    }

    private double yawToX(double yaw) {
        double ratio = (double)this.compassWidth / (double)this.config.CompassArc;
        return yaw * ratio;
    }

    private void renderBackground() {
        if (!this.shouldDrawBackground()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Objects.requireNonNull(this.font);
        int y = 9 + 1 + this.config.CompassOffset;
        this.ctx.method_25294(this.compassStartX, y, this.compassEndX, y + 1, this.config.CompassBackgroundColor + this.alpha);
        RenderSystem.disableBlend();
    }

    private void renderMarkers() {
        if (!this.shouldDrawMarkers()) {
            return;
        }
        for (AtlasMarker marker : this.getSortedMarkers(this.level, this.player)) {
            if (marker.getDistance() <= 2.0) break;
            this.renderMarker(marker);
        }
    }

    private void drawTexture(class_2960 id, double x, int width, int height) {
        int dw = (int)((float)width * this.markerScale);
        int dh = (int)((float)height * this.markerScale);
        Objects.requireNonNull(this.font);
        int y = 9 - dh / 2 + this.config.CompassOffset + 1;
        this.ctx.method_25290(id, (int)x, y, 0.0f, 0.0f, dw, dh, dw, dh);
    }

    private void drawMarker(MarkerTexture texture, double x) {
        this.drawTexture(texture.id(), x, texture.textureWidth(), texture.textureHeight());
    }

    private void drawAccent(MarkerTexture texture, double x) {
        this.drawTexture(texture.accentId(), x, texture.textureWidth(), texture.textureHeight());
    }

    private void renderMarker(AtlasMarker marker) {
        double halfWidth;
        double markerX = (double)this.centerX + this.yawToX(marker.getYaw());
        if (markerX - (halfWidth = (double)marker.getWidth() / 2.0) > (double)this.compassStartX && markerX + halfWidth < (double)this.compassEndX) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Objects.requireNonNull(this.config);
            this.ctx.method_51422(1.0f, 1.0f, 1.0f, 100.0f / 100.0f);
            this.drawMarker(marker.getTexture(), markerX -= halfWidth);
            if (marker.hasAccent()) {
                Color accent = Color.ofTransparent((int)marker.getColor().method_7787());
                this.setColor(accent);
                this.drawAccent(marker.getTexture(), markerX);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.defaultBlendFunc();
        }
    }

    private void setColor(Color color) {
        float f = (float)color.getRed() / 255.0f;
        float f2 = (float)color.getGreen() / 255.0f;
        float f3 = (float)color.getBlue() / 255.0f;
        Objects.requireNonNull(this.config);
        this.ctx.method_51422(f, f2, f3, 100.0f / 100.0f);
    }

    private void renderDirections() {
        if (!this.shouldDrawDirections()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int angle = 0;
        for (Direction direction : Direction.values()) {
            double halfWidth;
            double yaw = class_3532.method_15338((double)((double)angle - (double)this.player.method_36454()));
            double x = (double)this.centerX + this.yawToX(yaw);
            if (x - (halfWidth = (double)this.font.method_1727(direction.abbrev) / 2.0) > (double)this.compassStartX && x + halfWidth < (double)this.compassEndX) {
                class_5250 text = class_2561.method_43470((String)direction.abbrev());
                this.ctx.method_51439(this.font, (class_2561)text, (int)(x -= halfWidth), this.config.CompassOffset + 1, this.config.CompassTextColor + this.alpha, true);
            }
            angle += 45;
        }
        RenderSystem.disableBlend();
    }

    private List<AtlasMarker> getSortedMarkers(class_638 level, class_1657 player) {
        Map landmarks = WorldAtlasData.getOrCreate((class_1937)level).getEditableLandmarks();
        return landmarks.keySet().stream().map(landmark -> new AtlasMarker(player, (Landmark<?>)landmark, (MarkerTexture)landmarks.get(landmark))).sorted(Comparator.comparingDouble(AtlasMarker::getDistance).reversed()).toList();
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Direction {
        SOUTH("S"),
        SOUTHWEST("SW"),
        WEST("W"),
        NORTHWEST("NW"),
        NORTH("N"),
        NORTHEAST("NE"),
        EAST("E"),
        SOUTHEAST("SE");

        private final String abbrev;

        private Direction(String abbrev) {
            this.abbrev = abbrev;
        }

        public String abbrev() {
            return this.abbrev;
        }
    }
}

