/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.vibranium;

import com.blocklegend001.immersiveores.config.VibraniumConfig;
import com.blocklegend001.immersiveores.item.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class VibraniumArmor
extends ArmorItem {
    private static Item.Properties createSettings(boolean unbreakable, int durability) {
        Item.Properties settings = new Item.Properties().durability(durability);
        if (unbreakable) {
            settings.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
        return settings;
    }

    public VibraniumArmor(Holder<ArmorMaterial> pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, VibraniumArmor.createSettings((Boolean)VibraniumConfig.UNBREAKABLE_VIBRANIUM.get(), (Integer)VibraniumConfig.DURABILITY_VIBRANIUM.get()));
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return true;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int pSlotId, boolean pIsSelected) {
        if (!level.isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.VIBRANIUM_BOOTS.get()) {
                if (((Boolean)VibraniumConfig.SPEED_I_VIBRANIUM_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 400, 0, false, false));
                }
                if (((Boolean)VibraniumConfig.JUMP_I_VIBRANIUM_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.JUMP, 400, 0, false, false));
                }
            }
            if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.VIBRANIUM_HELMET.get() && ((Boolean)VibraniumConfig.NIGHT_VISION_VIBRANIUM_ARMOR.get()).booleanValue()) {
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, false, false));
            }
        }
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
        super.onCraftedBy(stack, level, player);
        for (int i = 1; i <= 9; ++i) {
            Component customName;
            ArmorItem armorItem;
            ItemStack ingredient = player.containerMenu.getSlot(i).getItem();
            Item item = ingredient.getItem();
            if (!(item instanceof ArmorItem) || (armorItem = (ArmorItem)item).getMaterial() != ArmorMaterials.NETHERITE || armorItem.getType() != ((ArmorItem)stack.getItem()).getType()) continue;
            ItemEnchantments ench = (ItemEnchantments)ingredient.get(DataComponents.ENCHANTMENTS);
            if (ench != null) {
                stack.set(DataComponents.ENCHANTMENTS, (Object)ench);
            }
            if ((customName = (Component)ingredient.get(DataComponents.CUSTOM_NAME)) == null) break;
            stack.set(DataComponents.CUSTOM_NAME, (Object)customName);
            break;
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> components, TooltipFlag pTooltipFlag) {
        if (Screen.hasShiftDown()) {
            if (ModItems.VIBRANIUM_BOOTS.get() == pStack.getItem()) {
                if (((Boolean)VibraniumConfig.UNBREAKABLE_VIBRANIUM.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                if (((Boolean)VibraniumConfig.SPEED_I_VIBRANIUM_ARMOR.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.speed1.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                if (((Boolean)VibraniumConfig.JUMP_I_VIBRANIUM_ARMOR.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.jump1.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                if (((Boolean)VibraniumConfig.CAN_WALK_ON_POWDERED_SNOW_VIBRANIUM.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.canwalkonpowderedsnow.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
            }
            if (ModItems.VIBRANIUM_CHESTPLATE.get() == pStack.getItem()) {
                if (((Boolean)VibraniumConfig.UNBREAKABLE_VIBRANIUM.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
            }
            if (ModItems.VIBRANIUM_HELMET.get() == pStack.getItem()) {
                if (((Boolean)VibraniumConfig.UNBREAKABLE_VIBRANIUM.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                if (((Boolean)VibraniumConfig.NIGHT_VISION_VIBRANIUM_ARMOR.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.nightvision.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
            }
            if (ModItems.VIBRANIUM_LEGGINGS.get() == pStack.getItem()) {
                if (((Boolean)VibraniumConfig.UNBREAKABLE_VIBRANIUM.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
            }
        } else {
            components.add((Component)Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return (Boolean)VibraniumConfig.CAN_WALK_ON_POWDERED_SNOW_VIBRANIUM.get();
    }
}

