/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.datagen;

import com.blocklegend001.immersiveores.blocks.ModBlocks;
import com.blocklegend001.immersiveores.item.ModItems;
import com.blocklegend001.immersiveores.util.ModEquipmentAssets;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.Variant;
import net.minecraft.client.data.models.blockstates.VariantProperties;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.level.block.Block;

public class ModModelProvider
extends ModelProvider {
    private final PackOutput.PathProvider blockStatePathProvider;
    private final PackOutput.PathProvider itemInfoPathProvider;
    private final PackOutput.PathProvider modelPathProvider;
    protected final String modId;

    public ModModelProvider(PackOutput packOutput, String modId) {
        super(packOutput);
        this.blockStatePathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.itemInfoPathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "items");
        this.modelPathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        this.modId = modId;
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.blockModel(blockModels, (Block)ModBlocks.VIBRANIUM_ORE.get());
        this.blockModel(blockModels, (Block)ModBlocks.VULPUS_ORE.get());
        this.blockModel(blockModels, (Block)ModBlocks.ENDERIUM_ORE.get());
        this.blockModel(blockModels, (Block)ModBlocks.VIBRANIUM_BLOCK.get());
        this.blockModel(blockModels, (Block)ModBlocks.VULPUS_BLOCK.get());
        this.blockModel(blockModels, (Block)ModBlocks.ENDERIUM_BLOCK.get());
        this.blockModel(blockModels, (Block)ModBlocks.RAW_VIBRANIUM_BLOCK.get());
        this.blockModel(blockModels, (Block)ModBlocks.RAW_VULPUS_BLOCK.get());
        this.blockModel(blockModels, (Block)ModBlocks.RAW_ENDERIUM_BLOCK.get());
        this.itemModel(itemModels, (Item)ModItems.VIBRANIUM_INGOT.get());
        this.itemModel(itemModels, (Item)ModItems.VULPUS_INGOT.get());
        this.itemModel(itemModels, (Item)ModItems.ENDERIUM_INGOT.get());
        this.itemModel(itemModels, (Item)ModItems.VIBRANIUM_NUGGET.get());
        this.itemModel(itemModels, (Item)ModItems.VULPUS_NUGGET.get());
        this.itemModel(itemModels, (Item)ModItems.ENDERIUM_NUGGET.get());
        this.itemModel(itemModels, (Item)ModItems.VIBRANIUM_STICK.get());
        this.itemModel(itemModels, (Item)ModItems.VULPUS_STICK.get());
        this.itemModel(itemModels, (Item)ModItems.ENDERIUM_STICK.get());
        this.itemModel(itemModels, (Item)ModItems.RAW_VIBRANIUM.get());
        this.itemModel(itemModels, (Item)ModItems.RAW_VULPUS.get());
        this.itemModel(itemModels, (Item)ModItems.RAW_ENDERIUM.get());
        this.armorModel(itemModels, (Item)ModItems.VIBRANIUM_HORSE_ARMOR.get(), ModEquipmentAssets.VIBRANIUM);
        this.armorModel(itemModels, (Item)ModItems.VULPUS_HORSE_ARMOR.get(), ModEquipmentAssets.VULPUS);
        this.armorModel(itemModels, (Item)ModItems.ENDERIUM_HORSE_ARMOR.get(), ModEquipmentAssets.ENDERIUM);
        this.armorModel(itemModels, (Item)ModItems.VIBRANIUM_HELMET.get(), ModEquipmentAssets.VIBRANIUM);
        this.armorModel(itemModels, (Item)ModItems.VIBRANIUM_CHESTPLATE.get(), ModEquipmentAssets.VIBRANIUM);
        this.armorModel(itemModels, (Item)ModItems.VIBRANIUM_LEGGINGS.get(), ModEquipmentAssets.VIBRANIUM);
        this.armorModel(itemModels, (Item)ModItems.VIBRANIUM_BOOTS.get(), ModEquipmentAssets.VIBRANIUM);
        this.armorModel(itemModels, (Item)ModItems.VULPUS_HELMET.get(), ModEquipmentAssets.VULPUS);
        this.armorModel(itemModels, (Item)ModItems.VULPUS_CHESTPLATE.get(), ModEquipmentAssets.VULPUS);
        this.armorModel(itemModels, (Item)ModItems.VULPUS_LEGGINGS.get(), ModEquipmentAssets.VULPUS);
        this.armorModel(itemModels, (Item)ModItems.VULPUS_BOOTS.get(), ModEquipmentAssets.VULPUS);
        this.armorModel(itemModels, (Item)ModItems.ENDERIUM_HELMET.get(), ModEquipmentAssets.ENDERIUM);
        this.armorModel(itemModels, (Item)ModItems.ENDERIUM_CHESTPLATE.get(), ModEquipmentAssets.ENDERIUM);
        this.armorModel(itemModels, (Item)ModItems.ENDERIUM_LEGGINGS.get(), ModEquipmentAssets.ENDERIUM);
        this.armorModel(itemModels, (Item)ModItems.ENDERIUM_BOOTS.get(), ModEquipmentAssets.ENDERIUM);
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_PICKAXE.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_PICKAXE.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_PICKAXE.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_SWORD.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_SWORD.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_SWORD.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_AXE.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_AXE.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_AXE.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_SHOVEL.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_SHOVEL.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_SHOVEL.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_HOE.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_HOE.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_HOE.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_HAMMER.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_HAMMER.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_HAMMER.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_EXCAVATOR.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_EXCAVATOR.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_EXCAVATOR.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_PAXEL.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_PAXEL.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_PAXEL.get());
    }

    public void blockModel(BlockModelGenerators blockModels, Block block) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)TexturedModel.CUBE.create(block, blockModels.modelOutput))));
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        ResourceLocation textureLoc = ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)("block/" + blockId.getPath()));
        blockModels.itemModelOutput.accept(block.asItem(), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(textureLoc, Collections.emptyList()));
    }

    public void itemModel(ItemModelGenerators itemModels, Item item) {
        this.itemModel(itemModels, item, ModelTemplates.FLAT_ITEM);
    }

    public void toolModel(ItemModelGenerators itemModels, Item item) {
        this.itemModel(itemModels, item, ModelTemplates.FLAT_HANDHELD_ITEM);
    }

    public void itemModel(ItemModelGenerators itemModels, Item item, ModelTemplate template) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        ResourceLocation textureLoc = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/" + itemId.getPath()));
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.LAYER0, textureLoc);
        itemModels.itemModelOutput.accept(item, (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(template.create(item, textureMapping, itemModels.modelOutput), Collections.emptyList()));
    }

    public void armorModel(ItemModelGenerators itemModels, Item item, ResourceKey<EquipmentAsset> equipmentKey) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        String armorType = "";
        if (id.getPath().contains("helmet")) {
            armorType = "helmet";
        } else if (id.getPath().contains("chestplate")) {
            armorType = "chestplate";
        } else if (id.getPath().contains("leggings")) {
            armorType = "leggings";
        } else if (id.getPath().contains("boots")) {
            armorType = "boots";
        }
        itemModels.generateTrimmableItem(item, equipmentKey, armorType, false);
    }

    public CompletableFuture<?> run(CachedOutput output) {
        ModelProvider.ItemInfoCollector itemCollector = new ModelProvider.ItemInfoCollector(this::getKnownItems);
        ModelProvider.BlockStateGeneratorCollector blockStateCollector = new ModelProvider.BlockStateGeneratorCollector(this::getKnownBlocks);
        ModelProvider.SimpleModelCollector simpleModelCollector = new ModelProvider.SimpleModelCollector();
        this.registerModels(new BlockModelGenerators((Consumer)blockStateCollector, (ItemModelOutput)itemCollector, (BiConsumer)simpleModelCollector), new ItemModelGenerators((ItemModelOutput)itemCollector, (BiConsumer)simpleModelCollector));
        blockStateCollector.validate();
        itemCollector.finalizeAndValidate();
        return CompletableFuture.allOf(blockStateCollector.save(output, this.blockStatePathProvider), simpleModelCollector.save(output, this.modelPathProvider), itemCollector.save(output, this.itemInfoPathProvider));
    }

    protected Stream<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> Optional.of(BuiltInRegistries.BLOCK.getKey(block)).filter(key -> key.getNamespace().equals(this.modId)).isPresent());
    }

    protected Stream<Item> getKnownItems() {
        return BuiltInRegistries.ITEM.stream().filter(item -> Optional.of(BuiltInRegistries.ITEM.getKey(item)).filter(key -> key.getNamespace().equals(this.modId)).isPresent()).filter(item -> !this.isExcluded((Item)item));
    }

    private boolean isExcluded(Item item) {
        return item == ModItems.ENDERIUM_BOW.get() || item == ModItems.VIBRANIUM_BOW.get() || item == ModItems.VULPUS_BOW.get();
    }
}

