/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.vibranium;

import com.blocklegend001.immersiveores.config.VibraniumConfig;
import com.blocklegend001.immersiveores.item.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.Level;

public class VibraniumArmor
extends ArmorItem {
    private static Item.Properties createSettings(Item.Properties properties, boolean unbreakable, int durability) {
        properties.durability(durability);
        if (unbreakable) {
            properties.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
        return properties;
    }

    public VibraniumArmor(ArmorMaterial pMaterial, ArmorType pType, Item.Properties pProperties) {
        super(pMaterial, pType, VibraniumArmor.createSettings(pProperties, (Boolean)VibraniumConfig.unbreakableVibranium.get(), (Integer)VibraniumConfig.durabilityVibranium.get()));
    }

    public void onInventoryTick(ItemStack stack, Level world, Player player, int slotIndex, int selectedIndex) {
        if (!world.isClientSide()) {
            if (player.getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.VIBRANIUM_BOOTS.get()) {
                if (((Boolean)VibraniumConfig.speedIVibraniumArmor.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 400, 0, false, false));
                }
                if (((Boolean)VibraniumConfig.jumpIVibraniumArmor.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.JUMP, 400, 0, false, false));
                }
            }
            if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.VIBRANIUM_HELMET.get() && ((Boolean)VibraniumConfig.nightVisionVibraniumArmor.get()).booleanValue()) {
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, false, false));
            }
        }
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
        super.onCraftedBy(stack, level, player);
        Item resultItem = stack.getItem();
        for (int i = 1; i <= 9; ++i) {
            Component customName;
            ItemStack ingredient = player.containerMenu.getSlot(i).getItem();
            Item ingredientItem = ingredient.getItem();
            if (!(resultItem == ModItems.VIBRANIUM_HELMET.get() && ingredientItem == Items.NETHERITE_HELMET || resultItem == ModItems.VIBRANIUM_CHESTPLATE.get() && ingredientItem == Items.NETHERITE_CHESTPLATE || resultItem == ModItems.VIBRANIUM_LEGGINGS.get() && ingredientItem == Items.NETHERITE_LEGGINGS) && (resultItem != ModItems.VIBRANIUM_BOOTS.get() || ingredientItem != Items.NETHERITE_BOOTS)) continue;
            ItemEnchantments ench = (ItemEnchantments)ingredient.get(DataComponents.ENCHANTMENTS);
            if (ench != null) {
                stack.set(DataComponents.ENCHANTMENTS, (Object)ench);
            }
            if ((customName = (Component)ingredient.get(DataComponents.CUSTOM_NAME)) == null) break;
            stack.set(DataComponents.CUSTOM_NAME, (Object)customName);
            break;
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> components, TooltipFlag pTooltipFlag) {
        if (Screen.hasShiftDown()) {
            if (ModItems.VIBRANIUM_BOOTS.get() == pStack.getItem()) {
                if (((Boolean)VibraniumConfig.unbreakableVibranium.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                if (((Boolean)VibraniumConfig.speedIVibraniumArmor.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.speed1.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                if (((Boolean)VibraniumConfig.jumpIVibraniumArmor.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.jump1.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                if (((Boolean)VibraniumConfig.canWalkOnPowderedSnowVibranium.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.canwalkonpowderedsnow.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
            }
            if (ModItems.VIBRANIUM_CHESTPLATE.get() == pStack.getItem()) {
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
            }
            if (ModItems.VIBRANIUM_HELMET.get() == pStack.getItem()) {
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                if (((Boolean)VibraniumConfig.nightVisionVibraniumArmor.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.nightvision.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
            }
            if (ModItems.VIBRANIUM_LEGGINGS.get() == pStack.getItem()) {
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
            }
        } else {
            components.add((Component)Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return (Boolean)VibraniumConfig.canWalkOnPowderedSnowVibranium.get();
    }
}

