/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.vulpus;

import com.blocklegend001.immersiveores.config.VulpusConfig;
import com.blocklegend001.immersiveores.item.custom.base.Hammer;
import com.blocklegend001.immersiveores.util.map.RadiusMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;

public class VulpusHammer
extends Hammer {
    private static Item.Properties createSettings(Item.Properties properties, boolean unbreakable, int durability) {
        properties.durability(durability);
        if (unbreakable) {
            properties.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
        return properties;
    }

    public VulpusHammer(ToolMaterial pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, VulpusHammer.createSettings(pProperties, (Boolean)VulpusConfig.unbreakableVulpus.get(), (Integer)VulpusConfig.durabilityVulpus.get()));
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> components, TooltipFlag pTooltipFlag) {
        int radius = this.getRadiusForHammer(pStack);
        int widht = radius * 2 + 1;
        if (Screen.hasShiftDown()) {
            if (((Boolean)VulpusConfig.unbreakableVulpus.get()).booleanValue()) {
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
            }
            components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
            MutableComponent text = Component.literal((String)"Dig area: ").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)(widht + "x1")).withStyle(ChatFormatting.YELLOW));
            components.add((Component)text);
        } else {
            components.add((Component)Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(ChatFormatting.RED));
        }
    }

    private int getRadiusForHammer(ItemStack stack) {
        if (RadiusMap.getHammerRadius().containsKey(stack.getItem())) {
            return RadiusMap.getHammerRadius().get(stack.getItem());
        }
        return 0;
    }
}

