/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item;

import com.blocklegend001.immersiveores.config.EnderiumConfig;
import com.blocklegend001.immersiveores.config.VibraniumConfig;
import com.blocklegend001.immersiveores.config.VulpusConfig;
import com.blocklegend001.immersiveores.item.custom.base.Paxel;
import com.blocklegend001.immersiveores.util.ModTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public record ModToolTiers(TagKey<Block> incorrectBlocksForDrops, int durability, float speed, float attackDamageBonus, int enchantmentValue) {
    public static final ModToolTiers VIBRANIUM = new ModToolTiers(ModTags.Blocks.INCORRECT_FOR_VIBRANIUM_TOOL, (Integer)VibraniumConfig.DURABILITY_VIBRANIUM.get(), ((Integer)VibraniumConfig.SPEED_VIBRANIUM_TIER.get()).intValue(), ((Integer)VibraniumConfig.ATTACK_DAMAGE_BONUS_VIBRANIUM_TIER.get()).intValue(), (Integer)VibraniumConfig.ENCHANTMENT_VALUE_VIBRANIUM_TIER.get());
    public static final ModToolTiers VULPUS = new ModToolTiers(ModTags.Blocks.INCORRECT_FOR_VULPUS_TOOL, (Integer)VulpusConfig.DURABILITY_VULPUS.get(), ((Integer)VulpusConfig.SPEED_VULPUS_TIER.get()).intValue(), ((Integer)VulpusConfig.ATTACK_DAMAGE_BONUS_VULPUS_TIER.get()).intValue(), (Integer)VulpusConfig.ENCHANTMENT_VALUE_VULPUS_TIER.get());
    public static final ModToolTiers ENDERIUM = new ModToolTiers(ModTags.Blocks.INCORRECT_FOR_ENDERIUM_TOOL, (Integer)EnderiumConfig.DURABILITY_ENDERIUM.get(), ((Integer)EnderiumConfig.SPEED_ENDERIUM_TIER.get()).intValue(), ((Integer)EnderiumConfig.ATTACK_DAMAGE_BONUS_ENDERIUM_TIER.get()).intValue(), (Integer)EnderiumConfig.ENCHANTMENT_VALUE_ENDERIUM_TIER.get());

    private Item.Properties applyCommonProperties(Item.Properties props) {
        return props.durability(this.durability).enchantable(this.enchantmentValue);
    }

    private ItemAttributeModifiers createToolAttributes(float attackDamage, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)(attackDamage + this.attackDamageBonus), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public Item.Properties applyToolProperties(Item.Properties properties, TagKey<Block> effectiveBlocks, float damage, float speed) {
        HolderGetter blockGetter = BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)BuiltInRegistries.BLOCK);
        return this.applyCommonProperties(properties).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.deniesDrops((HolderSet)blockGetter.getOrThrow(this.incorrectBlocksForDrops)), Tool.Rule.minesAndDrops((HolderSet)blockGetter.getOrThrow(effectiveBlocks), (float)this.speed)), 1.0f, 1, true)).attributes(this.createToolAttributes(damage, speed));
    }

    public Item.Properties applyPaxelProperties(Item.Properties properties, Set<TagKey<Block>> mineableTags, float damage, float speed) {
        HolderGetter blockGetter = BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)BuiltInRegistries.BLOCK);
        ArrayList<Tool.Rule> rules = new ArrayList<Tool.Rule>();
        rules.add(Tool.Rule.deniesDrops((HolderSet)blockGetter.getOrThrow(this.incorrectBlocksForDrops)));
        for (TagKey<Block> tag : Paxel.getPaxelMineable()) {
            rules.add(Tool.Rule.minesAndDrops((HolderSet)blockGetter.getOrThrow(tag), (float)this.speed));
        }
        return this.applyCommonProperties(properties).component(DataComponents.TOOL, (Object)new Tool(rules, 1.0f, 1, true)).attributes(this.createToolAttributes(damage, speed));
    }

    public Item.Properties applySwordProperties(Item.Properties properties, float damage, float speed) {
        HolderGetter blockGetter = BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)BuiltInRegistries.BLOCK);
        return this.applyCommonProperties(properties).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.minesAndDrops((HolderSet)HolderSet.direct((Holder[])new Holder[]{Blocks.COBWEB.builtInRegistryHolder()}), (float)15.0f), Tool.Rule.overrideSpeed((HolderSet)blockGetter.getOrThrow(BlockTags.SWORD_EFFICIENT), (float)1.5f)), 1.0f, 2, false)).attributes(this.createToolAttributes(damage, speed));
    }
}

