/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.base;

import com.blocklegend001.immersiveores.item.ModToolTiers;
import com.google.common.collect.BiMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class Paxel
extends Item {
    private static Set<TagKey<Block>> paxelMineable = null;
    private static final Map<Block, BlockState> FLATTENABLES = Shovel.getFlattenables();
    private static final Map<Block, Block> STRIPPABLES = Axe.getStrippables();

    public static Set<TagKey<Block>> getPaxelMineable() {
        if (paxelMineable == null) {
            paxelMineable = Set.of(BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.MINEABLE_WITH_SHOVEL, BlockTags.MINEABLE_WITH_AXE);
        }
        return paxelMineable;
    }

    public Paxel(ModToolTiers material, float attackDamage, float attackSpeed, Item.Properties settings) {
        super(material.applyPaxelProperties(settings, Paxel.getPaxelMineable(), attackDamage, attackSpeed));
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            entity.getMainHandItem().hurtAndBreak(1, entity, InteractionHand.MAIN_HAND);
        }
        return super.mineBlock(stack, level, state, pos, entity);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockState state = world.getBlockState(pos);
        BlockState result = this.getModifiedBlockState(context, state, pos);
        if (result == null) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide()) {
            world.setBlock(pos, result, 11);
        }
        return InteractionResult.SUCCESS;
    }

    private BlockState getModifiedBlockState(UseOnContext context, BlockState state, BlockPos pos) {
        Level world = context.getLevel();
        Player player = context.getPlayer();
        if (STRIPPABLES.containsKey(state.getBlock())) {
            world.playSound((Entity)player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return (BlockState)STRIPPABLES.get(state.getBlock()).defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS)));
        }
        Optional<BlockState> newState = this.evaluateNewBlockState(world, pos, player, state);
        if (newState.isPresent()) {
            return newState.get();
        }
        if (context.getClickedFace() == Direction.DOWN) {
            return null;
        }
        if (FLATTENABLES.containsKey(state.getBlock()) && world.getBlockState(pos.above()).isAir()) {
            world.playSound((Entity)player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            return FLATTENABLES.get(state.getBlock());
        }
        if (state.getBlock() instanceof CampfireBlock && ((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            world.playSound((Entity)player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    private Optional<BlockState> evaluateNewBlockState(Level world, BlockPos pos, @Nullable Player player, BlockState state) {
        Optional<BlockState> optional = this.getStripped(state);
        if (optional.isPresent()) {
            world.playSound((Entity)player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return optional;
        }
        Optional optional1 = WeatheringCopper.getPrevious((BlockState)state);
        if (optional1.isPresent()) {
            world.playSound((Entity)player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.levelEvent((Entity)player, 3005, pos, 0);
            return optional1;
        }
        Optional<BlockState> optional2 = Optional.ofNullable((Block)((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state));
        if (optional2.isPresent()) {
            world.playSound((Entity)player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.levelEvent((Entity)player, 3004, pos, 0);
            return optional2;
        }
        return Optional.empty();
    }

    private Optional<BlockState> getStripped(BlockState state) {
        return Optional.ofNullable(STRIPPABLES.get(state.getBlock())).map(block -> (BlockState)block.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS))));
    }

    private static final class Shovel
    extends ShovelItem {
        public static Map<Block, BlockState> getFlattenables() {
            return ShovelItem.FLATTENABLES;
        }

        private Shovel(ToolMaterial tier, float attackDamage, float attackSpeed, Item.Properties properties) {
            super(tier, attackDamage, attackSpeed, properties);
        }
    }

    private static final class Axe
    extends AxeItem {
        public static Map<Block, Block> getStrippables() {
            return AxeItem.STRIPPABLES;
        }

        private Axe(ToolMaterial tier, float attackDamage, float attackSpeed, Item.Properties properties) {
            super(tier, attackDamage, attackSpeed, properties);
        }
    }
}

