/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.blocks;

import com.blocklegend001.immersiveores.blocks.custom.enderium.EnderiumBlock;
import com.blocklegend001.immersiveores.blocks.custom.enderium.EnderiumOre;
import com.blocklegend001.immersiveores.blocks.custom.enderium.RawEnderiumBlock;
import com.blocklegend001.immersiveores.blocks.custom.vibranium.RawVibraniumBlock;
import com.blocklegend001.immersiveores.blocks.custom.vibranium.VibraniumBlock;
import com.blocklegend001.immersiveores.blocks.custom.vibranium.VibraniumOre;
import com.blocklegend001.immersiveores.blocks.custom.vulpus.RawVulpusBlock;
import com.blocklegend001.immersiveores.blocks.custom.vulpus.VulpusBlock;
import com.blocklegend001.immersiveores.blocks.custom.vulpus.VulpusOre;
import com.blocklegend001.immersiveores.item.ModItems;
import com.blocklegend001.immersiveores.util.color.ColoredBlock;
import com.blocklegend001.immersiveores.util.color.ColoredBlockItem;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"immersiveores");
    public static final RegistryObject<Block> VIBRANIUM_BLOCK = ModBlocks.registerBlock("vibranium_block", () -> new VibraniumBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHERITE_BLOCK).strength(6.5f, 1200.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> VULPUS_BLOCK = ModBlocks.registerBlock("vulpus_block", () -> new VulpusBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)VIBRANIUM_BLOCK.get())).strength(6.5f, 1200.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> ENDERIUM_BLOCK = ModBlocks.registerBlock("enderium_block", () -> new EnderiumBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)VULPUS_BLOCK.get())).strength(6.5f, 1200.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> RAW_VIBRANIUM_BLOCK = ModBlocks.registerBlock("raw_vibranium_block", () -> new RawVibraniumBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHERITE_BLOCK).strength(6.5f, 1200.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> RAW_VULPUS_BLOCK = ModBlocks.registerBlock("raw_vulpus_block", () -> new RawVulpusBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)RAW_VIBRANIUM_BLOCK.get())).strength(6.5f, 1200.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> RAW_ENDERIUM_BLOCK = ModBlocks.registerBlock("raw_enderium_block", () -> new RawEnderiumBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)RAW_VULPUS_BLOCK.get())).strength(6.5f, 1200.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> VIBRANIUM_ORE = ModBlocks.registerBlock("vibranium_ore", () -> new VibraniumOre(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ANCIENT_DEBRIS).strength(6.0f, 1200.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> VULPUS_ORE = ModBlocks.registerBlock("vulpus_ore", () -> new VulpusOre(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)VIBRANIUM_ORE.get())).strength(6.0f, 1200.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> ENDERIUM_ORE = ModBlocks.registerBlock("enderium_ore", () -> new EnderiumOre(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)VULPUS_ORE.get())).strength(6.0f, 1200.0f).requiresCorrectToolForDrops()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> {
            Block realBlock = (Block)block.get();
            if (realBlock instanceof ColoredBlock) {
                ColoredBlock coloredBlock = (ColoredBlock)realBlock;
                return new ColoredBlockItem((Block)coloredBlock, new Item.Properties().fireResistant(), coloredBlock.getColor());
            }
            return new BlockItem(realBlock, new Item.Properties().fireResistant());
        });
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

