/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.imp.client.compat;

import com.blocklegend001.immersiveores.item.ModItems;
import com.blocklegend001.immersiveores.util.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.impl.ui.ItemStackElement;

@WailaPlugin
public class JadeCompatibility
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)ToolRequirementComponent.INSTANCE, Block.class);
    }

    static final class ToolRequirementComponent
    implements IBlockComponentProvider {
        static final ToolRequirementComponent INSTANCE = new ToolRequirementComponent();
        private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"immersiveores", (String)"tool_requirement");

        ToolRequirementComponent() {
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            BlockState state = accessor.getBlockState();
            Player player = accessor.getPlayer();
            ItemStack pickaxe = ToolRequirementComponent.pickaxeFor(state);
            if (pickaxe.isEmpty()) {
                return;
            }
            boolean canHarvest = player != null && ToolRequirementComponent.canHarvestWithTag(player.getMainHandItem(), state);
            ITooltip row = JadeUI.tooltip();
            row.add((LayoutElement)ItemStackElement.of((ItemStack)pickaxe));
            row.add((Component)Component.literal((String)(canHarvest ? "\u2714" : "\u2716")).withStyle(canHarvest ? ChatFormatting.GREEN : ChatFormatting.RED));
            tooltip.add((LayoutElement)JadeUI.box((ITooltip)row, (BoxStyle)BoxStyle.DEFAULT_NESTED_BOX));
        }

        public ResourceLocation getUid() {
            return UID;
        }

        private static ItemStack pickaxeFor(BlockState state) {
            if (state.is(ModTags.Blocks.NEEDS_VIBRANIUM_TOOL)) {
                return new ItemStack((ItemLike)ModItems.VIBRANIUM_PICKAXE.get());
            }
            if (state.is(ModTags.Blocks.NEEDS_VULPUS_TOOL)) {
                return new ItemStack((ItemLike)ModItems.VULPUS_PICKAXE.get());
            }
            if (state.is(ModTags.Blocks.NEEDS_ENDERIUM_TOOL)) {
                return new ItemStack((ItemLike)ModItems.ENDERIUM_PICKAXE.get());
            }
            if (state.is(ModTags.Blocks.NEEDS_NETHERITE_TOOL)) {
                return new ItemStack((ItemLike)Items.NETHERITE_PICKAXE);
            }
            return ItemStack.EMPTY;
        }

        private static boolean canHarvestWithTag(ItemStack held, BlockState state) {
            if (held.isEmpty()) {
                return false;
            }
            if (held.is(Items.NETHERITE_PICKAXE)) {
                return state.is(ModTags.Blocks.NEEDS_NETHERITE_TOOL);
            }
            if (held.is(ModItems.VIBRANIUM_PICKAXE) || held.is(ModItems.VIBRANIUM_HAMMER) || held.is(ModItems.VIBRANIUM_PAXEL)) {
                return state.is(ModTags.Blocks.NEEDS_NETHERITE_TOOL) || state.is(ModTags.Blocks.NEEDS_VIBRANIUM_TOOL);
            }
            if (held.is(ModItems.VULPUS_PICKAXE) || held.is(ModItems.VULPUS_HAMMER) || held.is(ModItems.VULPUS_PAXEL)) {
                return true;
            }
            return held.is(ModItems.ENDERIUM_PICKAXE) || held.is(ModItems.ENDERIUM_HAMMER) || held.is(ModItems.ENDERIUM_PAXEL);
        }
    }
}

