/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.vulpus;

import com.blocklegend001.immersiveores.config.VulpusConfig;
import com.blocklegend001.immersiveores.item.ModToolTiers;
import com.blocklegend001.immersiveores.util.ScreenUtils;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class VulpusShovel
extends Item {
    private static final Map<Block, BlockState> FLATTENABLES = Shovel.getFlattenables();

    private static Item.Properties createSettings(Item.Properties properties, boolean unbreakable, int durability) {
        properties.durability(durability);
        if (unbreakable) {
            properties.component(DataComponents.UNBREAKABLE, (Object)Unit.INSTANCE);
        }
        return properties;
    }

    public VulpusShovel(ModToolTiers material, float attackDamage, float attackSpeed, Item.Properties settings) {
        super(material.applyToolProperties(VulpusShovel.createSettings(settings, (Boolean)VulpusConfig.UNBREAKABLE_VULPUS.get(), (Integer)VulpusConfig.DURABILITY_VULPUS.get()), (TagKey<Block>)BlockTags.MINEABLE_WITH_SHOVEL, attackDamage, attackSpeed));
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).copy().withStyle(ChatFormatting.RED);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockState state = world.getBlockState(pos);
        BlockState result = this.getModifiedBlockState(context, state, pos);
        if (result == null) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide()) {
            world.setBlock(pos, result, 11);
        }
        return InteractionResult.SUCCESS;
    }

    private BlockState getModifiedBlockState(UseOnContext context, BlockState state, BlockPos pos) {
        Level world = context.getLevel();
        Player player = context.getPlayer();
        if (context.getClickedFace() == Direction.DOWN) {
            return null;
        }
        if (FLATTENABLES.containsKey(state.getBlock()) && world.getBlockState(pos.above()).isAir()) {
            world.playSound((Entity)player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            return FLATTENABLES.get(state.getBlock());
        }
        return null;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext p_333372_, TooltipDisplay p_396484_, Consumer<Component> consumer, TooltipFlag p_41424_) {
        super.appendHoverText(pStack, p_333372_, p_396484_, consumer, p_41424_);
        if (ScreenUtils.isShiftDown()) {
            if (((Boolean)VulpusConfig.UNBREAKABLE_VULPUS.get()).booleanValue()) {
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
            }
            consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
        } else {
            consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(ChatFormatting.RED));
        }
    }

    private static final class Shovel
    extends ShovelItem {
        public static Map<Block, BlockState> getFlattenables() {
            return ShovelItem.FLATTENABLES;
        }

        private Shovel(ToolMaterial tier, float attackDamage, float attackSpeed, Item.Properties properties) {
            super(tier, attackDamage, attackSpeed, properties);
        }
    }
}

