/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.datagen;

import com.blocklegend001.immersiveores.datagen.ModAdvancementProvider;
import com.blocklegend001.immersiveores.datagen.ModBlockTagGenerator;
import com.blocklegend001.immersiveores.datagen.ModEquipmentAssetProvider;
import com.blocklegend001.immersiveores.datagen.ModItemTagGenerator;
import com.blocklegend001.immersiveores.datagen.ModLootTableProvider;
import com.blocklegend001.immersiveores.datagen.ModModelProvider;
import com.blocklegend001.immersiveores.datagen.ModRecipeProvider;
import com.blocklegend001.immersiveores.datagen.ModWorldGenProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="immersiveores", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        event.addProvider((DataProvider)new ModRecipeProvider.Runner(packOutput, lookupProvider));
        event.addProvider((DataProvider)new ModModelProvider(packOutput, "immersiveores"));
        event.addProvider((DataProvider)ModLootTableProvider.create(packOutput, lookupProvider));
        ModBlockTagGenerator blockTagGenerator = (ModBlockTagGenerator)event.addProvider((DataProvider)new ModBlockTagGenerator(packOutput, lookupProvider));
        event.addProvider((DataProvider)new ModItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.contentsGetter()));
        event.addProvider((DataProvider)new ModWorldGenProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new ModAdvancementProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new ModEquipmentAssetProvider(packOutput));
    }
}

