/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item;

import com.blocklegend001.immersiveores.config.EnderiumConfig;
import com.blocklegend001.immersiveores.config.VibraniumConfig;
import com.blocklegend001.immersiveores.config.VulpusConfig;
import com.blocklegend001.immersiveores.item.ModItems;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class ModArmorMaterials {
    public static final Holder<ArmorMaterial> VIBRANIUM = ModArmorMaterials.register("vibranium", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, VibraniumConfig.protectionValueVibraniumBoots);
        attribute.put(ArmorItem.Type.LEGGINGS, VibraniumConfig.protectionValueVibraniumLeggings);
        attribute.put(ArmorItem.Type.CHESTPLATE, VibraniumConfig.protectionValueVibraniumChestplate);
        attribute.put(ArmorItem.Type.HELMET, VibraniumConfig.protectionValueVibraniumHelmet);
    }), VibraniumConfig.enchantmentValueVibraniumArmor, VibraniumConfig.toughnessValueVibraniumArmor, VibraniumConfig.knockbackResistanceValueVibraniumArmor, (Item)ModItems.VIBRANIUM_INGOT.get());
    public static final Holder<ArmorMaterial> VULPUS = ModArmorMaterials.register("vulpus", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, VulpusConfig.protectionValueVulpusBoots);
        attribute.put(ArmorItem.Type.LEGGINGS, VulpusConfig.protectionValueVulpusLeggings);
        attribute.put(ArmorItem.Type.CHESTPLATE, VulpusConfig.protectionValueVulpusChestplate);
        attribute.put(ArmorItem.Type.HELMET, VulpusConfig.protectionValueVulpusHelmet);
    }), VulpusConfig.enchantmentValueVulpusArmor, VulpusConfig.toughnessValueVulpusArmor, VulpusConfig.knockbackResistanceValueVulpusArmor, (Item)ModItems.VULPUS_INGOT.get());
    public static final Holder<ArmorMaterial> ENDERIUM = ModArmorMaterials.register("enderium", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, EnderiumConfig.protectionValueEnderiumBoots);
        attribute.put(ArmorItem.Type.LEGGINGS, EnderiumConfig.protectionValueEnderiumLeggings);
        attribute.put(ArmorItem.Type.CHESTPLATE, EnderiumConfig.protectionValueEnderiumChestplate);
        attribute.put(ArmorItem.Type.HELMET, EnderiumConfig.protectionValueEnderiumHelmet);
    }), EnderiumConfig.enchantmentValueEnderiumArmor, EnderiumConfig.toughnessValueEnderiumArmor, EnderiumConfig.knockbackResistanceValueEnderiumArmor, (Item)ModItems.ENDERIUM_INGOT.get());

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> typeProtections, int enchantability, float toughness, float knockbackResistance, Item repairItem) {
        ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)"immersiveores", (String)name);
        Holder soundEvent = SoundEvents.ARMOR_EQUIP_NETHERITE;
        Supplier<Ingredient> repairIngredient = () -> Ingredient.of((ItemLike[])new ItemLike[]{repairItem});
        List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(loc));
        EnumMap<ArmorItem.Type, Integer> typeMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            typeMap.put(type, typeProtections.get(type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)loc, (Object)new ArmorMaterial(typeProtections, enchantability, soundEvent, repairIngredient, layers, toughness, knockbackResistance));
    }
}

