/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.vulpus;

import com.blocklegend001.immersiveores.util.BowTier;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class VulpusBow
extends BowItem {
    private final BowTier tier;

    public VulpusBow(BowTier tier, Item.Properties properties) {
        super(properties.durability(tier.getUses()));
        this.tier = tier;
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
        arrow.setBaseDamage(arrow.getBaseDamage() + this.tier.getAttackDamageBonus());
        return arrow;
    }

    public int getEnchantmentValue() {
        return this.tier.getEnchantmentValue();
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            ItemStack arrowStack = player.getProjectile(stack);
            int charge = this.getUseDuration(stack, entityLiving) - timeLeft;
            float arrowVelocity = VulpusBow.getPowerForTime((int)charge);
            if ((double)arrowVelocity >= 0.1) {
                if (!world.isClientSide) {
                    int arrowCount = 3;
                    boolean isPrimaryArrow = true;
                    for (int i = 0; i < arrowCount; ++i) {
                        ArrowItem arrowItem = (ArrowItem)(arrowStack.getItem() instanceof ArrowItem ? arrowStack.getItem() : Items.ARROW);
                        AbstractArrow arrowEntity = arrowItem.createArrow(world, arrowStack, (LivingEntity)player, stack);
                        arrowEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, arrowVelocity * 3.0f, 1.0f);
                        if (arrowVelocity == 1.0f) {
                            arrowEntity.setCritArrow(true);
                        }
                        arrowEntity.igniteForSeconds(15.0f);
                        if (isPrimaryArrow) {
                            arrowEntity.pickup = AbstractArrow.Pickup.ALLOWED;
                            isPrimaryArrow = false;
                        } else {
                            arrowEntity.pickup = AbstractArrow.Pickup.DISALLOWED;
                        }
                        world.addFreshEntity((Entity)arrowEntity);
                    }
                }
                world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (player.getRandom().nextFloat() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
                if (!player.getAbilities().instabuild) {
                    arrowStack.shrink(1);
                    if (arrowStack.isEmpty()) {
                        player.getInventory().removeItem(arrowStack);
                    }
                }
            }
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> components, TooltipFlag pTooltipFlag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.literal((String)("+" + this.tier.getAttackDamageBonus() + " ")).append((Component)Component.translatable((String)"tooltip.immersiveores.damage.tooltip")).withStyle(ChatFormatting.RED));
            components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
            components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
            components.add((Component)Component.translatable((String)"tooltip.immersiveores.shoot3arrows.tooltip").withStyle(ChatFormatting.RED));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(ChatFormatting.RED));
        }
    }
}

