/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.util.tools.excavator;

import com.blocklegend001.immersiveores.item.custom.enderium.EnderiumExcavator;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="immersiveores", bus=EventBusSubscriber.Bus.GAME)
public class ModEventsEnderiumExcavator {
    private static final Set<BlockPos> HARVESTED_BLOCKS = new HashSet<BlockPos>();

    @SubscribeEvent
    public static void onExcavatorUsage(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (item instanceof EnderiumExcavator) {
            EnderiumExcavator excavator = (EnderiumExcavator)item;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockPos initialBlockPos = event.getPos();
                if (HARVESTED_BLOCKS.contains(initialBlockPos)) {
                    return;
                }
                for (BlockPos pos : EnderiumExcavator.getBlocksToBeDestroyed(3, initialBlockPos, serverPlayer)) {
                    if (pos == initialBlockPos || !excavator.isCorrectToolForDrops(mainHandItem, event.getLevel().getBlockState(pos))) continue;
                    HARVESTED_BLOCKS.add(pos);
                    serverPlayer.gameMode.destroyBlock(pos);
                    HARVESTED_BLOCKS.remove(pos);
                }
            }
        }
    }
}

