/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.util.tools.hammer;

import com.blocklegend001.immersiveores.item.custom.vibranium.VibraniumHammer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="immersiveores", bus=EventBusSubscriber.Bus.GAME)
public class ModEventsVibraniumHammer {
    private static final Set<BlockPos> HARVESTED_BLOCKS = new HashSet<BlockPos>();

    @SubscribeEvent
    public static void onExcavatorUsage(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (item instanceof VibraniumHammer) {
            VibraniumHammer excavator = (VibraniumHammer)item;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockPos initalBlockPos = event.getPos();
                if (HARVESTED_BLOCKS.contains(initalBlockPos)) {
                    return;
                }
                for (BlockPos pos : VibraniumHammer.getBlocksToBeDestroyed(1, initalBlockPos, serverPlayer)) {
                    if (pos == initalBlockPos || !excavator.isCorrectToolForDrops(mainHandItem, event.getLevel().getBlockState(pos))) continue;
                    HARVESTED_BLOCKS.add(pos);
                    serverPlayer.gameMode.destroyBlock(pos);
                    HARVESTED_BLOCKS.remove(pos);
                }
            }
        }
    }
}

