/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.vulpus;

import com.blocklegend001.immersiveores.config.VulpusConfig;
import com.blocklegend001.immersiveores.item.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.Level;

public class VulpusArmor
extends ArmorItem {
    private static Item.Properties createSettings(Item.Properties properties, boolean unbreakable, int durability) {
        properties.durability(durability);
        if (unbreakable) {
            properties.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
        return properties;
    }

    public VulpusArmor(ArmorMaterial pMaterial, ArmorType pType, Item.Properties pProperties) {
        super(pMaterial, pType, VulpusArmor.createSettings(pProperties, (Boolean)VulpusConfig.unbreakableVulpus.get(), (Integer)VulpusConfig.durabilityVulpus.get()));
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).copy().withStyle(ChatFormatting.RED);
    }

    public void onInventoryTick(ItemStack stack, Level world, Player player, int slotIndex, int selectedIndex) {
        if (!world.isClientSide()) {
            if (player.getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.VULPUS_BOOTS.get()) {
                if (((Boolean)VulpusConfig.speedIIVulpusArmor.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 400, 1, false, false));
                }
                if (((Boolean)VulpusConfig.jumpIIVulpusArmor.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.JUMP, 400, 1, false, false));
                }
                if (((Boolean)VulpusConfig.fireResistanceVulpusArmor.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0, false, false));
                }
                if (!player.onGround() && player.fallDistance >= 1.0f && ((Boolean)VulpusConfig.immuneToFallDamageVulpusArmor.get()).booleanValue()) {
                    player.fallDistance = 0.0f;
                }
            }
            if (player.getItemBySlot(EquipmentSlot.CHEST).getItem() == ModItems.VULPUS_CHESTPLATE.get() && ((Boolean)VulpusConfig.fireResistanceVulpusArmor.get()).booleanValue()) {
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0, false, false));
            }
            if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.VULPUS_HELMET.get()) {
                if (((Boolean)VulpusConfig.nightVisionVulpusArmor.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, false, false));
                }
                if (((Boolean)VulpusConfig.fireResistanceVulpusArmor.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0, false, false));
                }
            }
            if (player.getItemBySlot(EquipmentSlot.LEGS).getItem() == ModItems.VULPUS_LEGGINGS.get()) {
                if (((Boolean)VulpusConfig.fireResistanceVulpusArmor.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0, false, false));
                }
                if (((Boolean)VulpusConfig.neverLoseHungerVulpusArmor.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.SATURATION, 400, 99, false, false));
                }
            }
        }
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
        super.onCraftedBy(stack, level, player);
        Item resultItem = stack.getItem();
        for (int i = 1; i <= 9; ++i) {
            Component customName;
            ItemStack ingredient = player.containerMenu.getSlot(i).getItem();
            Item ingredientItem = ingredient.getItem();
            if (!(resultItem == ModItems.VULPUS_HELMET.get() && ingredientItem == ModItems.VIBRANIUM_HELMET.get() || resultItem == ModItems.VULPUS_CHESTPLATE.get() && ingredientItem == ModItems.VIBRANIUM_CHESTPLATE.get() || resultItem == ModItems.VULPUS_LEGGINGS.get() && ingredientItem == ModItems.VIBRANIUM_LEGGINGS.get()) && (resultItem != ModItems.VULPUS_BOOTS.get() || ingredientItem != ModItems.VIBRANIUM_BOOTS.get())) continue;
            ItemEnchantments ench = (ItemEnchantments)ingredient.get(DataComponents.ENCHANTMENTS);
            if (ench != null) {
                stack.set(DataComponents.ENCHANTMENTS, (Object)ench);
            }
            if ((customName = (Component)ingredient.get(DataComponents.CUSTOM_NAME)) == null) break;
            stack.set(DataComponents.CUSTOM_NAME, (Object)customName);
            break;
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> components, TooltipFlag pTooltipFlag) {
        if (Screen.hasShiftDown()) {
            if (ModItems.VULPUS_BOOTS.get() == pStack.getItem()) {
                if (((Boolean)VulpusConfig.unbreakableVulpus.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
                }
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
                if (((Boolean)VulpusConfig.speedIIVulpusArmor.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.speed2.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.jumpIIVulpusArmor.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.jump2.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.canWalkOnPowderedSnowVulpus.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.canwalkonpowderedsnow.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.makesPiglinsNeutralVulpus.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.fireResistanceVulpusArmor.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.immuneToFallDamageVulpusArmor.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofalldamage.tooltip").withStyle(ChatFormatting.RED));
                }
            }
            if (ModItems.VULPUS_CHESTPLATE.get() == pStack.getItem()) {
                if (((Boolean)VulpusConfig.unbreakableVulpus.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
                }
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
                if (((Boolean)VulpusConfig.makesPiglinsNeutralVulpus.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.fireResistanceVulpusArmor.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.RED));
                }
            }
            if (ModItems.VULPUS_HELMET.get() == pStack.getItem()) {
                if (((Boolean)VulpusConfig.unbreakableVulpus.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
                }
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
                if (((Boolean)VulpusConfig.nightVisionVulpusArmor.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.nightvision.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.makesPiglinsNeutralVulpus.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.fireResistanceVulpusArmor.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.RED));
                }
            }
            if (ModItems.VULPUS_LEGGINGS.get() == pStack.getItem()) {
                if (((Boolean)VulpusConfig.unbreakableVulpus.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
                }
                components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
                if (((Boolean)VulpusConfig.makesPiglinsNeutralVulpus.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.fireResistanceVulpusArmor.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.RED));
                }
                if (((Boolean)VulpusConfig.neverLoseHungerVulpusArmor.get()).booleanValue()) {
                    components.add((Component)Component.translatable((String)"tooltip.immersiveores.nerverlosehunger.tooltip").withStyle(ChatFormatting.RED));
                }
            }
        } else {
            components.add((Component)Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(ChatFormatting.RED));
        }
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return (Boolean)VulpusConfig.canWalkOnPowderedSnowVulpus.get();
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return (Boolean)VulpusConfig.makesPiglinsNeutralVulpus.get();
    }
}

