/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.vulpus;

import com.blocklegend001.immersiveores.config.VulpusConfig;
import com.blocklegend001.immersiveores.item.ModToolTiers;
import com.blocklegend001.immersiveores.util.ScreenUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class VulpusSword
extends Item {
    private static Item.Properties createSettings(Item.Properties properties, boolean unbreakable, int durability) {
        properties.durability(durability);
        if (unbreakable) {
            properties.component(DataComponents.UNBREAKABLE, (Object)Unit.INSTANCE);
        }
        return properties;
    }

    public VulpusSword(ModToolTiers material, float attackDamage, float attackSpeed, Item.Properties settings) {
        super(material.applySwordProperties(VulpusSword.createSettings(settings, (Boolean)VulpusConfig.unbreakableVulpus.get(), (Integer)VulpusConfig.durabilityVulpus.get()), attackDamage, attackSpeed));
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).copy().withStyle(ChatFormatting.RED);
    }

    public void hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.setRemainingFireTicks(15);
        if (!((Boolean)VulpusConfig.unbreakableVulpus.get()).booleanValue()) {
            attacker.getMainHandItem().hurtAndBreak(1, attacker, InteractionHand.MAIN_HAND);
        }
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        Level world = player.level();
        if (world.isClientSide()) {
            return;
        }
        if (!player.isSprinting() && player.onGround() && target.isDeadOrDying()) {
            double sweepRadius = 1.0;
            List nearby = world.getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(sweepRadius, 0.25, sweepRadius), e -> e != player && e != target && e.isAlive());
            Registry enchantmentRegistry = world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            Holder.Reference enchantmentReference = enchantmentRegistry.getOrThrow(Enchantments.SWEEPING_EDGE);
            int sweepingLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantmentReference, (ItemStack)player.getMainHandItem());
            float sweepDamage = 1.0f + (float)sweepingLevel * 1.0f;
            for (LivingEntity entity : nearby) {
                entity.hurt(player.damageSources().playerAttack(player), sweepDamage);
                double dx = entity.getX() - player.getX();
                double dz = entity.getZ() - player.getZ();
                double dist = Math.max(0.001, dx * dx + dz * dz);
                entity.knockback((double)0.4f, dx / dist, dz / dist);
            }
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, player.getX(), player.getY(0.5), player.getZ(), 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext p_333372_, TooltipDisplay p_396484_, Consumer<Component> consumer, TooltipFlag p_41424_) {
        super.appendHoverText(pStack, p_333372_, p_396484_, consumer, p_41424_);
        if (ScreenUtils.isShiftDown()) {
            if (((Boolean)VulpusConfig.unbreakableVulpus.get()).booleanValue()) {
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.RED));
            }
            consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.RED));
            consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.cansetmobonfire.tooltip").withStyle(ChatFormatting.RED));
        } else {
            consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(ChatFormatting.RED));
        }
    }
}

