/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.world;

import com.blocklegend001.immersiveores.world.ModConfiguredFeatures;
import com.blocklegend001.immersiveores.world.ModOrePlacement;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> VIBRANIUM_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("vibranium_ore_placed");
    public static final ResourceKey<PlacedFeature> NETHER_VULPUS_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("nether_vulpus_ore_placed");
    public static final ResourceKey<PlacedFeature> END_ENDERIUM_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("end_enderium_ore_placed");
    public static final ResourceKey<PlacedFeature> VIBRANIUM_GEODE_PLACED_KEY = ModPlacedFeatures.registerKey("vibranium_geode_placed");
    public static final ResourceKey<PlacedFeature> VULPUS_GEODE_PLACED_KEY = ModPlacedFeatures.registerKey("vulpus_geode_placed");
    public static final ResourceKey<PlacedFeature> ENDERIUM_GEODE_PLACED_KEY = ModPlacedFeatures.registerKey("enderium_geode_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, VIBRANIUM_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_VIBRANIUM_ORE_KEY), ModOrePlacement.commonOrePlacement(7, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-60), (VerticalAnchor)VerticalAnchor.absolute((int)0))));
        ModPlacedFeatures.register(context, NETHER_VULPUS_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_VULPUS_ORE_KEY), ModOrePlacement.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)125))));
        ModPlacedFeatures.register(context, END_ENDERIUM_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.END_ENDERIUM_ORE_KEY), ModOrePlacement.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)125))));
        ModPlacedFeatures.register(context, VIBRANIUM_GEODE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.VIBRANIUM_GEODE_KEY), List.of(RarityFilter.onAverageOnceEvery((int)35), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-60), (VerticalAnchor)VerticalAnchor.absolute((int)0)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, VULPUS_GEODE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.VULPUS_GEODE_KEY), List.of(RarityFilter.onAverageOnceEvery((int)45), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)125)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, ENDERIUM_GEODE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.ENDERIUM_GEODE_KEY), List.of(RarityFilter.onAverageOnceEvery((int)40), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)125)), BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"immersiveores", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

