/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.datagen;

import com.blocklegend001.immersiveores.item.ModItems;
import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "immersiveores", existingFileHelper);
    }

    protected void registerModels() {
        this.handheldItem(ModItems.VIBRANIUM_SWORD);
        this.handheldItem(ModItems.VIBRANIUM_PAXEL);
        this.handheldItem(ModItems.VIBRANIUM_PICKAXE);
        this.handheldItem(ModItems.VIBRANIUM_SHOVEL);
        this.handheldItem(ModItems.VIBRANIUM_HOE);
        this.handheldItem(ModItems.VIBRANIUM_HAMMER);
        this.handheldItem(ModItems.VIBRANIUM_EXCAVATOR);
        this.handheldItem(ModItems.VIBRANIUM_AXE);
        this.simpleItem(ModItems.VIBRANIUM_HORSE_ARMOR);
        this.simpleItem(ModItems.VIBRANIUM_HELMET);
        this.simpleItem(ModItems.VIBRANIUM_CHESTPLATE);
        this.simpleItem(ModItems.VIBRANIUM_LEGGINGS);
        this.simpleItem(ModItems.VIBRANIUM_BOOTS);
        this.simpleItem(ModItems.RAW_VIBRANIUM);
        this.simpleItem(ModItems.VIBRANIUM_INGOT);
        this.simpleItem(ModItems.VIBRANIUM_NUGGET);
        this.simpleItem(ModItems.VIBRANIUM_STICK);
        this.trimmedArmorItem(ModItems.VIBRANIUM_HELMET);
        this.trimmedArmorItem(ModItems.VIBRANIUM_CHESTPLATE);
        this.trimmedArmorItem(ModItems.VIBRANIUM_LEGGINGS);
        this.trimmedArmorItem(ModItems.VIBRANIUM_BOOTS);
        this.handheldItem(ModItems.ENDERIUM_SWORD);
        this.handheldItem(ModItems.ENDERIUM_PAXEL);
        this.handheldItem(ModItems.ENDERIUM_PICKAXE);
        this.handheldItem(ModItems.ENDERIUM_SHOVEL);
        this.handheldItem(ModItems.ENDERIUM_HOE);
        this.handheldItem(ModItems.ENDERIUM_HAMMER);
        this.handheldItem(ModItems.ENDERIUM_EXCAVATOR);
        this.handheldItem(ModItems.ENDERIUM_AXE);
        this.simpleItem(ModItems.ENDERIUM_HORSE_ARMOR);
        this.simpleItem(ModItems.ENDERIUM_HELMET);
        this.simpleItem(ModItems.ENDERIUM_CHESTPLATE);
        this.simpleItem(ModItems.ENDERIUM_LEGGINGS);
        this.simpleItem(ModItems.ENDERIUM_BOOTS);
        this.simpleItem(ModItems.RAW_ENDERIUM);
        this.simpleItem(ModItems.ENDERIUM_INGOT);
        this.simpleItem(ModItems.ENDERIUM_NUGGET);
        this.simpleItem(ModItems.ENDERIUM_STICK);
        this.trimmedArmorItem(ModItems.ENDERIUM_HELMET);
        this.trimmedArmorItem(ModItems.ENDERIUM_CHESTPLATE);
        this.trimmedArmorItem(ModItems.ENDERIUM_LEGGINGS);
        this.trimmedArmorItem(ModItems.ENDERIUM_BOOTS);
        this.handheldItem(ModItems.VULPUS_SWORD);
        this.handheldItem(ModItems.VULPUS_PAXEL);
        this.handheldItem(ModItems.VULPUS_PICKAXE);
        this.handheldItem(ModItems.VULPUS_SHOVEL);
        this.handheldItem(ModItems.VULPUS_HOE);
        this.handheldItem(ModItems.VULPUS_HAMMER);
        this.handheldItem(ModItems.VULPUS_EXCAVATOR);
        this.handheldItem(ModItems.VULPUS_AXE);
        this.simpleItem(ModItems.VULPUS_HORSE_ARMOR);
        this.simpleItem(ModItems.RAW_VULPUS);
        this.simpleItem(ModItems.VULPUS_INGOT);
        this.simpleItem(ModItems.VULPUS_NUGGET);
        this.simpleItem(ModItems.VULPUS_STICK);
        this.simpleItem(ModItems.VULPUS_HELMET);
        this.simpleItem(ModItems.VULPUS_CHESTPLATE);
        this.simpleItem(ModItems.VULPUS_LEGGINGS);
        this.simpleItem(ModItems.VULPUS_BOOTS);
        this.trimmedArmorItem(ModItems.VULPUS_HELMET);
        this.trimmedArmorItem(ModItems.VULPUS_CHESTPLATE);
        this.trimmedArmorItem(ModItems.VULPUS_LEGGINGS);
        this.trimmedArmorItem(ModItems.VULPUS_BOOTS);
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"immersiveores", (String)("item/" + item.getId().getPath())));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"immersiveores", (String)("item/" + item.getId().getPath())));
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "immersiveores";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = "item/" + itemRegistryObject.getId().getPath();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.fromNamespaceAndPath((String)"immersiveores", (String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.withDefaultNamespace((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.fromNamespaceAndPath((String)"immersiveores", (String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"immersiveores", (String)("item/" + itemRegistryObject.getId().getPath())));
            });
        }
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

