/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.mixin;

import com.blocklegend001.immersiveores.item.ModItems;
import com.blocklegend001.immersiveores.item.custom.base.Hammer;
import com.blocklegend001.immersiveores.util.tools.OverlayRender;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererHammerMixin {
    private static Map<Item, Integer> getHammerRanges = null;

    private static Map<Item, Integer> getHammerRanges() {
        if (getHammerRanges == null) {
            getHammerRanges = Map.of((Item)ModItems.VIBRANIUM_HAMMER.get(), 1, (Item)ModItems.VULPUS_HAMMER.get(), 2, (Item)ModItems.ENDERIUM_HAMMER.get(), 3);
        }
        return getHammerRanges;
    }

    @Inject(method={"renderLevel"}, at={@At(value="TAIL")})
    private void renderLevelAfter(DeltaTracker p_342180_, boolean p_109603_, Camera p_109604_, GameRenderer p_109605_, LightTexture p_109606_, Matrix4f p_254120_, Matrix4f p_330527_, CallbackInfo ci) {
        BlockHitResult blockHit;
        if (Minecraft.getInstance().level == null || Minecraft.getInstance().player == null) {
            return;
        }
        ItemStack heldItem = Minecraft.getInstance().player.getMainHandItem();
        if (!(heldItem.getItem() instanceof Hammer)) {
            return;
        }
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (!(hitResult instanceof BlockHitResult) || (blockHit = (BlockHitResult)hitResult).getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos origin = blockHit.getBlockPos();
        Direction side = blockHit.getDirection();
        int range = Minecraft.getInstance().player.isShiftKeyDown() ? 0 : LevelRendererHammerMixin.getHammerRanges().get(heldItem.getItem());
        if (!Minecraft.getInstance().level.getBlockState(origin).is(BlockTags.MINEABLE_WITH_PICKAXE)) {
            return;
        }
        AABB box = LevelRendererHammerMixin.getSelectionBox(range, side, origin);
        Vec3 cameraPos = p_109604_.getPosition();
        box = box.move(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        Matrix4f matrix = p_254120_;
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer builder = buffer.getBuffer(RenderType.lines());
        OverlayRender.drawBox(matrix, builder, box, 1.0f, 1.0f, 1.0f, 1.0f);
        buffer.endBatch();
    }

    private static AABB getSelectionBox(int range, Direction side, BlockPos origin) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                BlockPos pos = switch (side.getAxis()) {
                    default -> throw new MatchException(null, null);
                    case Direction.Axis.Y -> origin.offset(x, 0, y);
                    case Direction.Axis.X -> origin.offset(0, y, x);
                    case Direction.Axis.Z -> origin.offset(x, y, 0);
                };
                minX = Math.min(minX, pos.getX());
                minY = Math.min(minY, pos.getY());
                minZ = Math.min(minZ, pos.getZ());
                maxX = Math.max(maxX, pos.getX() + 1);
                maxY = Math.max(maxY, pos.getY() + 1);
                maxZ = Math.max(maxZ, pos.getZ() + 1);
            }
        }
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }
}

