/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.imp.client.compat;

import com.blocklegend001.immersiveores.item.ModItems;
import com.blocklegend001.immersiveores.util.ModTags;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.component.ItemComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class WthitCompatibility
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.addComponent((IBlockComponentProvider)ToolRequirementComponent.INSTANCE, TooltipPosition.BODY, Block.class);
    }

    public static class ToolRequirementComponent
    implements IBlockComponentProvider {
        public static final ToolRequirementComponent INSTANCE = new ToolRequirementComponent();

        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            BlockState state = accessor.getBlockState();
            Player player = accessor.getPlayer();
            ItemStack requiredTool = ItemStack.EMPTY;
            String toolName = "";
            if (state.is(ModTags.Blocks.NEEDS_VIBRANIUM_TOOL)) {
                requiredTool = new ItemStack((ItemLike)ModItems.VIBRANIUM_PICKAXE.get());
                toolName = "Vibranium Tool";
            } else if (state.is(ModTags.Blocks.NEEDS_VULPUS_TOOL)) {
                requiredTool = new ItemStack((ItemLike)ModItems.VULPUS_PICKAXE.get());
                toolName = "Vulpus Tool";
            } else if (state.is(ModTags.Blocks.NEEDS_ENDERIUM_TOOL)) {
                requiredTool = new ItemStack((ItemLike)ModItems.ENDERIUM_PICKAXE.get());
                toolName = "Enderium Tool";
            } else if (state.is(ModTags.Blocks.NEEDS_NETHERITE_TOOL)) {
                requiredTool = new ItemStack((ItemLike)Items.NETHERITE_PICKAXE);
                toolName = "Netherite Tool";
            }
            if (!requiredTool.isEmpty()) {
                boolean canHarvest = player != null && ToolRequirementComponent.canHarvestWithTag(player.getMainHandItem(), state);
                String symbol = canHarvest ? String.valueOf(ChatFormatting.GREEN) + "\u2714 " : String.valueOf(ChatFormatting.RED) + "\u2716 ";
                tooltip.addLine((ITooltipComponent)new ItemComponent(requiredTool));
                tooltip.addLine((Component)Component.literal((String)(symbol + "Requires " + toolName)).withStyle(ChatFormatting.GRAY));
            }
        }

        private static boolean canHarvestWithTag(ItemStack held, BlockState state) {
            if (held.isEmpty()) {
                return false;
            }
            if (held.is(Items.NETHERITE_PICKAXE)) {
                return state.is(ModTags.Blocks.NEEDS_NETHERITE_TOOL);
            }
            if (held.is((Item)ModItems.VIBRANIUM_PICKAXE.get()) || held.is((Item)ModItems.VIBRANIUM_HAMMER.get()) || held.is((Item)ModItems.VIBRANIUM_PAXEL.get())) {
                return state.is(ModTags.Blocks.NEEDS_NETHERITE_TOOL) || state.is(ModTags.Blocks.NEEDS_VIBRANIUM_TOOL);
            }
            if (held.is((Item)ModItems.VULPUS_PICKAXE.get()) || held.is((Item)ModItems.VULPUS_HAMMER.get()) || held.is((Item)ModItems.VULPUS_PAXEL.get())) {
                return true;
            }
            return held.is((Item)ModItems.ENDERIUM_PICKAXE.get()) || held.is((Item)ModItems.ENDERIUM_HAMMER.get()) || held.is((Item)ModItems.ENDERIUM_PAXEL.get());
        }
    }
}

