/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.datagen;

import com.blocklegend001.immersiveores.block.ModBlocks;
import com.blocklegend001.immersiveores.item.ModItems;
import com.blocklegend001.immersiveores.util.ModEquipmentAssets;
import java.util.Collections;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.RangeSelectItemModel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.client.renderer.item.properties.numeric.UseDuration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.level.block.Block;

public class ModModelProvider
extends ModelProvider {
    public ModModelProvider(PackOutput packOutput, String modId) {
        super(packOutput, "immersiveores");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.blockModel(blockModels, (Block)ModBlocks.VIBRANIUM_ORE.get());
        this.blockModel(blockModels, (Block)ModBlocks.VULPUS_ORE.get());
        this.blockModel(blockModels, (Block)ModBlocks.ENDERIUM_ORE.get());
        this.blockModel(blockModels, (Block)ModBlocks.VIBRANIUM_BLOCK.get());
        this.blockModel(blockModels, (Block)ModBlocks.VULPUS_BLOCK.get());
        this.blockModel(blockModels, (Block)ModBlocks.ENDERIUM_BLOCK.get());
        this.blockModel(blockModels, (Block)ModBlocks.RAW_VIBRANIUM_BLOCK.get());
        this.blockModel(blockModels, (Block)ModBlocks.RAW_VULPUS_BLOCK.get());
        this.blockModel(blockModels, (Block)ModBlocks.RAW_ENDERIUM_BLOCK.get());
        this.itemModel(itemModels, (Item)ModItems.VIBRANIUM_INGOT.get());
        this.itemModel(itemModels, (Item)ModItems.VULPUS_INGOT.get());
        this.itemModel(itemModels, (Item)ModItems.ENDERIUM_INGOT.get());
        this.itemModel(itemModels, (Item)ModItems.VIBRANIUM_NUGGET.get());
        this.itemModel(itemModels, (Item)ModItems.VULPUS_NUGGET.get());
        this.itemModel(itemModels, (Item)ModItems.ENDERIUM_NUGGET.get());
        this.itemModel(itemModels, (Item)ModItems.VIBRANIUM_STICK.get());
        this.itemModel(itemModels, (Item)ModItems.VULPUS_STICK.get());
        this.itemModel(itemModels, (Item)ModItems.ENDERIUM_STICK.get());
        this.itemModel(itemModels, (Item)ModItems.RAW_VIBRANIUM.get());
        this.itemModel(itemModels, (Item)ModItems.RAW_VULPUS.get());
        this.itemModel(itemModels, (Item)ModItems.RAW_ENDERIUM.get());
        this.armorModel(itemModels, (Item)ModItems.VIBRANIUM_HORSE_ARMOR.get(), ModEquipmentAssets.VIBRANIUM);
        this.armorModel(itemModels, (Item)ModItems.VULPUS_HORSE_ARMOR.get(), ModEquipmentAssets.VULPUS);
        this.armorModel(itemModels, (Item)ModItems.ENDERIUM_HORSE_ARMOR.get(), ModEquipmentAssets.ENDERIUM);
        this.armorModel(itemModels, (Item)ModItems.VIBRANIUM_HELMET.get(), ModEquipmentAssets.VIBRANIUM);
        this.armorModel(itemModels, (Item)ModItems.VIBRANIUM_CHESTPLATE.get(), ModEquipmentAssets.VIBRANIUM);
        this.armorModel(itemModels, (Item)ModItems.VIBRANIUM_LEGGINGS.get(), ModEquipmentAssets.VIBRANIUM);
        this.armorModel(itemModels, (Item)ModItems.VIBRANIUM_BOOTS.get(), ModEquipmentAssets.VIBRANIUM);
        this.armorModel(itemModels, (Item)ModItems.VULPUS_HELMET.get(), ModEquipmentAssets.VULPUS);
        this.armorModel(itemModels, (Item)ModItems.VULPUS_CHESTPLATE.get(), ModEquipmentAssets.VULPUS);
        this.armorModel(itemModels, (Item)ModItems.VULPUS_LEGGINGS.get(), ModEquipmentAssets.VULPUS);
        this.armorModel(itemModels, (Item)ModItems.VULPUS_BOOTS.get(), ModEquipmentAssets.VULPUS);
        this.armorModel(itemModels, (Item)ModItems.ENDERIUM_HELMET.get(), ModEquipmentAssets.ENDERIUM);
        this.armorModel(itemModels, (Item)ModItems.ENDERIUM_CHESTPLATE.get(), ModEquipmentAssets.ENDERIUM);
        this.armorModel(itemModels, (Item)ModItems.ENDERIUM_LEGGINGS.get(), ModEquipmentAssets.ENDERIUM);
        this.armorModel(itemModels, (Item)ModItems.ENDERIUM_BOOTS.get(), ModEquipmentAssets.ENDERIUM);
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_PICKAXE.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_PICKAXE.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_PICKAXE.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_SWORD.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_SWORD.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_SWORD.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_AXE.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_AXE.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_AXE.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_SHOVEL.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_SHOVEL.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_SHOVEL.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_HOE.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_HOE.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_HOE.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_HAMMER.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_HAMMER.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_HAMMER.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_EXCAVATOR.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_EXCAVATOR.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_EXCAVATOR.get());
        this.toolModel(itemModels, (Item)ModItems.VIBRANIUM_PAXEL.get());
        this.toolModel(itemModels, (Item)ModItems.VULPUS_PAXEL.get());
        this.toolModel(itemModels, (Item)ModItems.ENDERIUM_PAXEL.get());
        this.bowModel(itemModels, (Item)ModItems.VIBRANIUM_BOW.get());
        this.bowModel(itemModels, (Item)ModItems.VULPUS_BOW.get());
        this.bowModel(itemModels, (Item)ModItems.ENDERIUM_BOW.get());
    }

    public void blockModel(BlockModelGenerators blockModels, Block block) {
        blockModels.createTrivialCube(block);
    }

    public void itemModel(ItemModelGenerators itemModels, Item item) {
        this.itemModel(itemModels, item, ModelTemplates.FLAT_ITEM);
    }

    public void toolModel(ItemModelGenerators itemModels, Item item) {
        this.itemModel(itemModels, item, ModelTemplates.FLAT_HANDHELD_ITEM);
    }

    public void itemModel(ItemModelGenerators itemModels, Item item, ModelTemplate template) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        ResourceLocation textureLoc = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/" + itemId.getPath()));
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.LAYER0, textureLoc);
        itemModels.itemModelOutput.accept(item, (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(template.create(item, textureMapping, itemModels.modelOutput), Collections.emptyList()));
    }

    public void bowModel(ItemModelGenerators itemModels, Item item) {
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)item));
        ItemModel.Unbaked itemmodel = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(item, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(item, "_pulling_0", ModelTemplates.BOW));
        ItemModel.Unbaked itemmodel$unbaked2 = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(item, "_pulling_1", ModelTemplates.BOW));
        ItemModel.Unbaked itemmodel$unbaked3 = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(item, "_pulling_2", ModelTemplates.BOW));
        itemModels.itemModelOutput.accept(item, ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new UseDuration(false), (float)0.05f, (ItemModel.Unbaked)itemmodel$unbaked1, (RangeSelectItemModel.Entry[])new RangeSelectItemModel.Entry[]{ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked2, (float)0.65f), ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked3, (float)0.9f)}), (ItemModel.Unbaked)itemmodel$unbaked));
    }

    public void armorModel(ItemModelGenerators itemModels, Item item, ResourceKey<EquipmentAsset> equipmentKey) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        String armorType = "";
        if (id.getPath().contains("helmet")) {
            armorType = "helmet";
        } else if (id.getPath().contains("chestplate")) {
            armorType = "chestplate";
        } else if (id.getPath().contains("leggings")) {
            armorType = "leggings";
        } else if (id.getPath().contains("boots")) {
            armorType = "boots";
        }
        itemModels.generateTrimmableItem(item, equipmentKey, ResourceLocation.withDefaultNamespace((String)("trims/items/" + armorType + "_trim")), false);
    }
}

