/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.vibranium;

import com.blocklegend001.immersiveores.config.VibraniumConfig;
import com.blocklegend001.immersiveores.item.ModToolTiers;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class VibraniumHoe
extends Item {
    private static final Map<Block, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>> TILLABLES = Hoe.getTillables();

    private static Item.Properties createSettings(Item.Properties properties, boolean unbreakable, int durability) {
        properties.durability(durability);
        if (unbreakable) {
            properties.component(DataComponents.UNBREAKABLE, (Object)Unit.INSTANCE);
        }
        return properties;
    }

    public VibraniumHoe(ModToolTiers material, float attackDamage, float attackSpeed, Item.Properties settings) {
        super(material.applyToolProperties(VibraniumHoe.createSettings(settings, (Boolean)VibraniumConfig.UNBREAKABLE_VIBRANIUM.get(), (Integer)VibraniumConfig.DURABILITY_VIBRANIUM.get()), (TagKey<Block>)BlockTags.MINEABLE_WITH_HOE, attackDamage, attackSpeed));
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).copy().withStyle(ChatFormatting.LIGHT_PURPLE);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        BlockState tilled = state.getToolModifiedState(context, ItemAbilities.HOE_TILL, false);
        if (tilled != null) {
            Player player = context.getPlayer();
            level.playSound((Entity)player, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide) {
                level.setBlock(pos, tilled, 11);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_HOE_ACTIONS.contains(itemAbility);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext p_333372_, TooltipDisplay p_396484_, Consumer<Component> consumer, TooltipFlag p_41424_) {
        super.appendHoverText(pStack, p_333372_, p_396484_, consumer, p_41424_);
        if (Screen.hasShiftDown()) {
            if (((Boolean)VibraniumConfig.UNBREAKABLE_VIBRANIUM.get()).booleanValue()) {
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
            }
            consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
        } else {
            consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }

    private static final class Hoe
    extends HoeItem {
        public static Map<Block, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>> getTillables() {
            return HoeItem.TILLABLES;
        }

        private Hoe(ToolMaterial tier, float attackDamage, float attackSpeed, Item.Properties properties) {
            super(tier, attackDamage, attackSpeed, properties);
        }
    }
}

