/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.vibranium;

import com.blocklegend001.immersiveores.config.EnderiumConfig;
import com.blocklegend001.immersiveores.config.VibraniumConfig;
import com.blocklegend001.immersiveores.item.ModItems;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import org.jetbrains.annotations.Nullable;

public class VibraniumArmor
extends Item {
    public VibraniumArmor(ArmorMaterial material, ArmorType type, Item.Properties settings) {
        super(VibraniumArmor.computeSettings(material, type, (Boolean)EnderiumConfig.UNBREAKABLE_ENDERIUM.get(), (Integer)EnderiumConfig.DURABILITY_ENDERIUM.get(), settings));
    }

    private static Item.Properties computeSettings(ArmorMaterial material, ArmorType type, boolean unbreakable, int durability, Item.Properties settings) {
        settings.humanoidArmor(material, ArmorType.BODY).attributes(material.createAttributes(type)).enchantable(material.enchantmentValue()).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)type.getSlot()).setEquipSound(material.equipSound()).setAsset(material.assetId()).build()).durability(durability);
        if (unbreakable) {
            settings.component(DataComponents.UNBREAKABLE, (Object)Unit.INSTANCE);
        }
        return settings;
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
        super.inventoryTick(stack, level, entity, equipmentSlot);
        if (!level.isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.VIBRANIUM_BOOTS.get()) {
                if (((Boolean)VibraniumConfig.SPEED_I_VIBRANIUM_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.SPEED, 400, 0, false, false));
                }
                if (((Boolean)VibraniumConfig.JUMP_I_VIBRANIUM_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.JUMP_BOOST, 400, 0, false, false));
                }
            }
            if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.VIBRANIUM_HELMET.get() && ((Boolean)VibraniumConfig.NIGHT_VISION_VIBRANIUM_ARMOR.get()).booleanValue()) {
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, false, false));
            }
        }
    }

    public void onCraftedBy(ItemStack stack, Player player) {
        super.onCraftedBy(stack, player);
        Item resultItem = stack.getItem();
        for (int i = 1; i <= 9; ++i) {
            Component customName;
            ItemStack ingredient = player.containerMenu.getSlot(i).getItem();
            Item ingredientItem = ingredient.getItem();
            if (!(resultItem == ModItems.VIBRANIUM_HELMET.get() && ingredientItem == Items.NETHERITE_HELMET || resultItem == ModItems.VIBRANIUM_CHESTPLATE.get() && ingredientItem == Items.NETHERITE_CHESTPLATE || resultItem == ModItems.VIBRANIUM_LEGGINGS.get() && ingredientItem == Items.NETHERITE_LEGGINGS) && (resultItem != ModItems.VIBRANIUM_BOOTS.get() || ingredientItem != Items.NETHERITE_BOOTS)) continue;
            ItemEnchantments ench = (ItemEnchantments)ingredient.get(DataComponents.ENCHANTMENTS);
            if (ench != null) {
                stack.set(DataComponents.ENCHANTMENTS, (Object)ench);
            }
            if ((customName = (Component)ingredient.get(DataComponents.CUSTOM_NAME)) == null) break;
            stack.set(DataComponents.CUSTOM_NAME, (Object)customName);
            break;
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext p_333372_, TooltipDisplay p_396484_, Consumer<Component> consumer, TooltipFlag p_41424_) {
        super.appendHoverText(pStack, p_333372_, p_396484_, consumer, p_41424_);
        if (Screen.hasShiftDown()) {
            if (ModItems.VIBRANIUM_BOOTS.get() == pStack.getItem()) {
                if (((Boolean)EnderiumConfig.UNBREAKABLE_ENDERIUM.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                if (((Boolean)VibraniumConfig.SPEED_I_VIBRANIUM_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.speed1.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                if (((Boolean)VibraniumConfig.JUMP_I_VIBRANIUM_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.jump1.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                if (((Boolean)VibraniumConfig.CAN_WALK_ON_POWDERED_SNOW_VIBRANIUM.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.canwalkonpowderedsnow.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
            }
            if (ModItems.VIBRANIUM_CHESTPLATE.get() == pStack.getItem()) {
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
            }
            if (ModItems.VIBRANIUM_HELMET.get() == pStack.getItem()) {
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                if (((Boolean)VibraniumConfig.NIGHT_VISION_VIBRANIUM_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.nightvision.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
            }
            if (ModItems.VIBRANIUM_LEGGINGS.get() == pStack.getItem()) {
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
            }
        } else {
            consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return (Boolean)VibraniumConfig.CAN_WALK_ON_POWDERED_SNOW_VIBRANIUM.get();
    }
}

