/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.immersiveores.item.custom.enderium;

import com.blocklegend001.immersiveores.config.EnderiumConfig;
import com.blocklegend001.immersiveores.item.ModItems;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import org.jetbrains.annotations.Nullable;

public class EnderiumArmor
extends Item {
    public EnderiumArmor(ArmorMaterial material, ArmorType type, Item.Properties settings) {
        super(EnderiumArmor.computeSettings(material, type, (Boolean)EnderiumConfig.UNBREAKABLE_ENDERIUM.get(), (Integer)EnderiumConfig.DURABILITY_ENDERIUM.get(), settings));
    }

    private static Item.Properties computeSettings(ArmorMaterial material, ArmorType type, boolean unbreakable, int durability, Item.Properties settings) {
        settings.humanoidArmor(material, ArmorType.BODY).attributes(material.createAttributes(type)).enchantable(material.enchantmentValue()).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)type.getSlot()).setEquipSound(material.equipSound()).setAsset(material.assetId()).build()).durability(durability);
        if (unbreakable) {
            settings.component(DataComponents.UNBREAKABLE, (Object)Unit.INSTANCE);
        }
        return settings;
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
        super.inventoryTick(stack, level, entity, equipmentSlot);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.ENDERIUM_BOOTS.get()) {
                if (((Boolean)EnderiumConfig.SPEED_III_ENDERIUM_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.SPEED, 400, 2, false, false));
                }
                if (((Boolean)EnderiumConfig.JUMP_III_ENDERIUM_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.JUMP_BOOST, 400, 2, false, false));
                }
                if (((Boolean)EnderiumConfig.FIRE_RESISTANCE_ENDERIUM_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 1, false, false));
                }
                if (!player.onGround() && player.fallDistance >= 1.0 && ((Boolean)EnderiumConfig.IMMUNE_TO_FALL_DAMAGE_ENDERIUM_ARMOR.get()).booleanValue()) {
                    player.fallDistance = 0.0;
                }
            }
            if (player.getItemBySlot(EquipmentSlot.CHEST).getItem() == ModItems.ENDERIUM_CHESTPLATE.get() && ((Boolean)EnderiumConfig.FIRE_RESISTANCE_ENDERIUM_ARMOR.get()).booleanValue()) {
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0, false, false));
            }
            if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.ENDERIUM_HELMET.get()) {
                if (((Boolean)EnderiumConfig.NIGHT_VISION_ENDERIUM_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, false, false));
                }
                if (((Boolean)EnderiumConfig.FIRE_RESISTANCE_ENDERIUM_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0, false, false));
                }
            }
            if (player.getItemBySlot(EquipmentSlot.LEGS).getItem() == ModItems.ENDERIUM_LEGGINGS.get()) {
                if (((Boolean)EnderiumConfig.NEVER_LOSE_HUNGER_ENDERIUM_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.SATURATION, 400, 99, false, false));
                }
                if (((Boolean)EnderiumConfig.FIRE_RESISTANCE_ENDERIUM_ARMOR.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0, false, false));
                }
            }
        }
    }

    public void onCraftedBy(ItemStack stack, Player player) {
        super.onCraftedBy(stack, player);
        Item resultItem = stack.getItem();
        for (int i = 1; i <= 9; ++i) {
            Component customName;
            ItemStack ingredient = player.containerMenu.getSlot(i).getItem();
            Item ingredientItem = ingredient.getItem();
            if (!(resultItem == ModItems.ENDERIUM_HELMET.get() && ingredientItem == ModItems.VULPUS_HELMET.get() || resultItem == ModItems.ENDERIUM_CHESTPLATE.get() && ingredientItem == ModItems.VULPUS_CHESTPLATE.get() || resultItem == ModItems.ENDERIUM_LEGGINGS.get() && ingredientItem == ModItems.VULPUS_LEGGINGS.get()) && (resultItem != ModItems.ENDERIUM_BOOTS.get() || ingredientItem != ModItems.VULPUS_BOOTS.get())) continue;
            ItemEnchantments ench = (ItemEnchantments)ingredient.get(DataComponents.ENCHANTMENTS);
            if (ench != null) {
                stack.set(DataComponents.ENCHANTMENTS, (Object)ench);
            }
            if ((customName = (Component)ingredient.get(DataComponents.CUSTOM_NAME)) == null) break;
            stack.set(DataComponents.CUSTOM_NAME, (Object)customName);
            break;
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext p_333372_, TooltipDisplay p_396484_, Consumer<Component> consumer, TooltipFlag p_41424_) {
        super.appendHoverText(pStack, p_333372_, p_396484_, consumer, p_41424_);
        if (Screen.hasShiftDown()) {
            if (ModItems.ENDERIUM_BOOTS.get() == pStack.getItem()) {
                if (((Boolean)EnderiumConfig.UNBREAKABLE_ENDERIUM.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                if (((Boolean)EnderiumConfig.SPEED_III_ENDERIUM_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.speed3.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
                if (((Boolean)EnderiumConfig.JUMP_III_ENDERIUM_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.jump3.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
                if (((Boolean)EnderiumConfig.CAN_WALK_ON_POWDERED_SNOW_ENDERIUM.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.canwalkonpowderedsnow.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
                if (((Boolean)EnderiumConfig.FIRE_RESISTANCE_ENDERIUM_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
                if (((Boolean)EnderiumConfig.MAKES_PIGLINS_NEUTRAL_ENDERIUM.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
                if (((Boolean)EnderiumConfig.IMMUNE_TO_FALL_DAMAGE_ENDERIUM_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofalldamage.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
                if (((Boolean)EnderiumConfig.CAN_FLY_ENDERIUM_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.canfly.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
            }
            if (ModItems.ENDERIUM_CHESTPLATE.get() == pStack.getItem()) {
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                if (((Boolean)EnderiumConfig.FIRE_RESISTANCE_ENDERIUM_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.playerimmunetofire.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
                if (((Boolean)EnderiumConfig.MAKES_PIGLINS_NEUTRAL_ENDERIUM.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
            }
            if (ModItems.ENDERIUM_LEGGINGS.get() == pStack.getItem()) {
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                if (((Boolean)EnderiumConfig.FIRE_RESISTANCE_ENDERIUM_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
                if (((Boolean)EnderiumConfig.MAKES_PIGLINS_NEUTRAL_ENDERIUM.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
                if (((Boolean)EnderiumConfig.NEVER_LOSE_HUNGER_ENDERIUM_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.nerverlosehunger.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
            }
            if (ModItems.ENDERIUM_HELMET.get() == pStack.getItem()) {
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.unbreakble.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetofire.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                if (((Boolean)EnderiumConfig.NIGHT_VISION_ENDERIUM_ARMOR.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.nightvision.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
                if (((Boolean)EnderiumConfig.MAKES_PIGLINS_NEUTRAL_ENDERIUM.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.immunetopiglin.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
                if (((Boolean)EnderiumConfig.ENDERMAN_WILL_NOT_BE_ANGRY_WITH_YOU_ENDERIUM.get()).booleanValue()) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.endermanwillnotbeangrywithyou.tooltip").withStyle(ChatFormatting.DARK_AQUA));
                }
            }
        } else {
            consumer.accept((Component)Component.translatable((String)"tooltip.immersiveores.pressshiftformoreinfo.tooltip").withStyle(ChatFormatting.DARK_AQUA));
        }
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return (Boolean)EnderiumConfig.CAN_WALK_ON_POWDERED_SNOW_ENDERIUM.get();
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return (Boolean)EnderiumConfig.MAKES_PIGLINS_NEUTRAL_ENDERIUM.get();
    }
}

